/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request object for listing harvest jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHarvestJobsRequest extends MediaPackageV2Request implements
        ToCopyableBuilder<ListHarvestJobsRequest.Builder, ListHarvestJobsRequest> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(ListHarvestJobsRequest::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelGroupName").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(ListHarvestJobsRequest::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("channelName").build()).build();

    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginEndpointName").getter(getter(ListHarvestJobsRequest::originEndpointName))
            .setter(setter(Builder::originEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("originEndpointName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListHarvestJobsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeStatus").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListHarvestJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHarvestJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD,
            CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelGroupName;

    private final String channelName;

    private final String originEndpointName;

    private final String status;

    private final Integer maxResults;

    private final String nextToken;

    private ListHarvestJobsRequest(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.status = builder.status;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the channel group to filter the harvest jobs by. If specified, only harvest jobs associated with
     * channels in this group will be returned.
     * </p>
     * 
     * @return The name of the channel group to filter the harvest jobs by. If specified, only harvest jobs associated
     *         with channels in this group will be returned.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The name of the channel to filter the harvest jobs by. If specified, only harvest jobs associated with this
     * channel will be returned.
     * </p>
     * 
     * @return The name of the channel to filter the harvest jobs by. If specified, only harvest jobs associated with
     *         this channel will be returned.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name of the origin endpoint to filter the harvest jobs by. If specified, only harvest jobs associated with
     * this origin endpoint will be returned.
     * </p>
     * 
     * @return The name of the origin endpoint to filter the harvest jobs by. If specified, only harvest jobs associated
     *         with this origin endpoint will be returned.
     */
    public final String originEndpointName() {
        return originEndpointName;
    }

    /**
     * <p>
     * The status to filter the harvest jobs by. If specified, only harvest jobs with this status will be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HarvestJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status to filter the harvest jobs by. If specified, only harvest jobs with this status will be
     *         returned.
     * @see HarvestJobStatus
     */
    public final HarvestJobStatus status() {
        return HarvestJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status to filter the harvest jobs by. If specified, only harvest jobs with this status will be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HarvestJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status to filter the harvest jobs by. If specified, only harvest jobs with this status will be
     *         returned.
     * @see HarvestJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The maximum number of harvest jobs to return in a single request. If not specified, a default value will be used.
     * </p>
     * 
     * @return The maximum number of harvest jobs to return in a single request. If not specified, a default value will
     *         be used.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token used for pagination. Provide this value in subsequent requests to retrieve the next set of results.
     * </p>
     * 
     * @return A token used for pagination. Provide this value in subsequent requests to retrieve the next set of
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHarvestJobsRequest)) {
            return false;
        }
        ListHarvestJobsRequest other = (ListHarvestJobsRequest) obj;
        return Objects.equals(channelGroupName(), other.channelGroupName()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(originEndpointName(), other.originEndpointName())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHarvestJobsRequest").add("ChannelGroupName", channelGroupName())
                .add("ChannelName", channelName()).add("OriginEndpointName", originEndpointName())
                .add("Status", statusAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "OriginEndpointName":
            return Optional.ofNullable(clazz.cast(originEndpointName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
        map.put("channelName", CHANNEL_NAME_FIELD);
        map.put("originEndpointName", ORIGIN_ENDPOINT_NAME_FIELD);
        map.put("includeStatus", STATUS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHarvestJobsRequest, T> g) {
        return obj -> g.apply((ListHarvestJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListHarvestJobsRequest> {
        /**
         * <p>
         * The name of the channel group to filter the harvest jobs by. If specified, only harvest jobs associated with
         * channels in this group will be returned.
         * </p>
         * 
         * @param channelGroupName
         *        The name of the channel group to filter the harvest jobs by. If specified, only harvest jobs
         *        associated with channels in this group will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The name of the channel to filter the harvest jobs by. If specified, only harvest jobs associated with this
         * channel will be returned.
         * </p>
         * 
         * @param channelName
         *        The name of the channel to filter the harvest jobs by. If specified, only harvest jobs associated with
         *        this channel will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name of the origin endpoint to filter the harvest jobs by. If specified, only harvest jobs associated
         * with this origin endpoint will be returned.
         * </p>
         * 
         * @param originEndpointName
         *        The name of the origin endpoint to filter the harvest jobs by. If specified, only harvest jobs
         *        associated with this origin endpoint will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpointName(String originEndpointName);

        /**
         * <p>
         * The status to filter the harvest jobs by. If specified, only harvest jobs with this status will be returned.
         * </p>
         * 
         * @param status
         *        The status to filter the harvest jobs by. If specified, only harvest jobs with this status will be
         *        returned.
         * @see HarvestJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HarvestJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status to filter the harvest jobs by. If specified, only harvest jobs with this status will be returned.
         * </p>
         * 
         * @param status
         *        The status to filter the harvest jobs by. If specified, only harvest jobs with this status will be
         *        returned.
         * @see HarvestJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HarvestJobStatus
         */
        Builder status(HarvestJobStatus status);

        /**
         * <p>
         * The maximum number of harvest jobs to return in a single request. If not specified, a default value will be
         * used.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of harvest jobs to return in a single request. If not specified, a default value
         *        will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token used for pagination. Provide this value in subsequent requests to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination. Provide this value in subsequent requests to retrieve the next set of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageV2Request.BuilderImpl implements Builder {
        private String channelGroupName;

        private String channelName;

        private String originEndpointName;

        private String status;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHarvestJobsRequest model) {
            super(model);
            channelGroupName(model.channelGroupName);
            channelName(model.channelName);
            originEndpointName(model.originEndpointName);
            status(model.status);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HarvestJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHarvestJobsRequest build() {
            return new ListHarvestJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
