/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specified resource doesn't exist.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceNotFoundException extends MediaPackageV2Exception implements
        ToCopyableBuilder<ResourceNotFoundException.Builder, ResourceNotFoundException> {
    private static final SdkField<String> RESOURCE_TYPE_NOT_FOUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceTypeNotFound").getter(getter(ResourceNotFoundException::resourceTypeNotFoundAsString))
            .setter(setter(Builder::resourceTypeNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeNotFound").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(RESOURCE_TYPE_NOT_FOUND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceTypeNotFound;

    private ResourceNotFoundException(BuilderImpl builder) {
        super(builder);
        this.resourceTypeNotFound = builder.resourceTypeNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The specified resource type wasn't found.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceTypeNotFound} will return {@link ResourceTypeNotFound#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceTypeNotFoundAsString}.
     * </p>
     * 
     * @return The specified resource type wasn't found.
     * @see ResourceTypeNotFound
     */
    public ResourceTypeNotFound resourceTypeNotFound() {
        return ResourceTypeNotFound.fromValue(resourceTypeNotFound);
    }

    /**
     * <p>
     * The specified resource type wasn't found.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceTypeNotFound} will return {@link ResourceTypeNotFound#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceTypeNotFoundAsString}.
     * </p>
     * 
     * @return The specified resource type wasn't found.
     * @see ResourceTypeNotFound
     */
    public String resourceTypeNotFoundAsString() {
        return resourceTypeNotFound;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceTypeNotFound", RESOURCE_TYPE_NOT_FOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceNotFoundException, T> g) {
        return obj -> g.apply((ResourceNotFoundException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceNotFoundException>,
            MediaPackageV2Exception.Builder {
        /**
         * <p>
         * The specified resource type wasn't found.
         * </p>
         * 
         * @param resourceTypeNotFound
         *        The specified resource type wasn't found.
         * @see ResourceTypeNotFound
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceTypeNotFound
         */
        Builder resourceTypeNotFound(String resourceTypeNotFound);

        /**
         * <p>
         * The specified resource type wasn't found.
         * </p>
         * 
         * @param resourceTypeNotFound
         *        The specified resource type wasn't found.
         * @see ResourceTypeNotFound
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceTypeNotFound
         */
        Builder resourceTypeNotFound(ResourceTypeNotFound resourceTypeNotFound);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends MediaPackageV2Exception.BuilderImpl implements Builder {
        private String resourceTypeNotFound;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceNotFoundException model) {
            super(model);
            resourceTypeNotFound(model.resourceTypeNotFound);
        }

        public final String getResourceTypeNotFound() {
            return resourceTypeNotFound;
        }

        public final void setResourceTypeNotFound(String resourceTypeNotFound) {
            this.resourceTypeNotFound = resourceTypeNotFound;
        }

        @Override
        public final Builder resourceTypeNotFound(String resourceTypeNotFound) {
            this.resourceTypeNotFound = resourceTypeNotFound;
            return this;
        }

        @Override
        public final Builder resourceTypeNotFound(ResourceTypeNotFound resourceTypeNotFound) {
            this.resourceTypeNotFound(resourceTypeNotFound == null ? null : resourceTypeNotFound.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ResourceNotFoundException build() {
            return new ResourceNotFoundException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
