/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration parameters for where in an S3 bucket to place the harvested content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3DestinationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<S3DestinationConfig.Builder, S3DestinationConfig> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(S3DestinationConfig::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> DESTINATION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPath").getter(getter(S3DestinationConfig::destinationPath))
            .setter(setter(Builder::destinationPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            DESTINATION_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String destinationPath;

    private S3DestinationConfig(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.destinationPath = builder.destinationPath;
    }

    /**
     * <p>
     * The name of an S3 bucket within which harvested content will be exported.
     * </p>
     * 
     * @return The name of an S3 bucket within which harvested content will be exported.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The path within the specified S3 bucket where the harvested content will be placed.
     * </p>
     * 
     * @return The path within the specified S3 bucket where the harvested content will be placed.
     */
    public final String destinationPath() {
        return destinationPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationConfig)) {
            return false;
        }
        S3DestinationConfig other = (S3DestinationConfig) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(destinationPath(), other.destinationPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3DestinationConfig").add("BucketName", bucketName()).add("DestinationPath", destinationPath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "DestinationPath":
            return Optional.ofNullable(clazz.cast(destinationPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BucketName", BUCKET_NAME_FIELD);
        map.put("DestinationPath", DESTINATION_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3DestinationConfig, T> g) {
        return obj -> g.apply((S3DestinationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3DestinationConfig> {
        /**
         * <p>
         * The name of an S3 bucket within which harvested content will be exported.
         * </p>
         * 
         * @param bucketName
         *        The name of an S3 bucket within which harvested content will be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The path within the specified S3 bucket where the harvested content will be placed.
         * </p>
         * 
         * @param destinationPath
         *        The path within the specified S3 bucket where the harvested content will be placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPath(String destinationPath);
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String destinationPath;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationConfig model) {
            bucketName(model.bucketName);
            destinationPath(model.destinationPath);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getDestinationPath() {
            return destinationPath;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        @Override
        public S3DestinationConfig build() {
            return new S3DestinationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
