/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SCTE configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scte implements SdkPojo, Serializable, ToCopyableBuilder<Scte.Builder, Scte> {
    private static final SdkField<List<String>> SCTE_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ScteFilter")
            .getter(getter(Scte::scteFilterAsStrings))
            .setter(setter(Builder::scteFilterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScteFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCTE_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> scteFilter;

    private Scte(BuilderImpl builder) {
        this.scteFilter = builder.scteFilter;
    }

    /**
     * <p>
     * The SCTE-35 message types that you want to be treated as ad markers in the output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScteFilter} method.
     * </p>
     * 
     * @return The SCTE-35 message types that you want to be treated as ad markers in the output.
     */
    public final List<ScteFilter> scteFilter() {
        return ScteFilterListCopier.copyStringToEnum(scteFilter);
    }

    /**
     * For responses, this returns true if the service returned a value for the ScteFilter property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScteFilter() {
        return scteFilter != null && !(scteFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The SCTE-35 message types that you want to be treated as ad markers in the output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScteFilter} method.
     * </p>
     * 
     * @return The SCTE-35 message types that you want to be treated as ad markers in the output.
     */
    public final List<String> scteFilterAsStrings() {
        return scteFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasScteFilter() ? scteFilterAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scte)) {
            return false;
        }
        Scte other = (Scte) obj;
        return hasScteFilter() == other.hasScteFilter() && Objects.equals(scteFilterAsStrings(), other.scteFilterAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Scte").add("ScteFilter", hasScteFilter() ? scteFilterAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScteFilter":
            return Optional.ofNullable(clazz.cast(scteFilterAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScteFilter", SCTE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Scte, T> g) {
        return obj -> g.apply((Scte) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scte> {
        /**
         * <p>
         * The SCTE-35 message types that you want to be treated as ad markers in the output.
         * </p>
         * 
         * @param scteFilter
         *        The SCTE-35 message types that you want to be treated as ad markers in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scteFilterWithStrings(Collection<String> scteFilter);

        /**
         * <p>
         * The SCTE-35 message types that you want to be treated as ad markers in the output.
         * </p>
         * 
         * @param scteFilter
         *        The SCTE-35 message types that you want to be treated as ad markers in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scteFilterWithStrings(String... scteFilter);

        /**
         * <p>
         * The SCTE-35 message types that you want to be treated as ad markers in the output.
         * </p>
         * 
         * @param scteFilter
         *        The SCTE-35 message types that you want to be treated as ad markers in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scteFilter(Collection<ScteFilter> scteFilter);

        /**
         * <p>
         * The SCTE-35 message types that you want to be treated as ad markers in the output.
         * </p>
         * 
         * @param scteFilter
         *        The SCTE-35 message types that you want to be treated as ad markers in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scteFilter(ScteFilter... scteFilter);
    }

    static final class BuilderImpl implements Builder {
        private List<String> scteFilter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Scte model) {
            scteFilterWithStrings(model.scteFilter);
        }

        public final Collection<String> getScteFilter() {
            if (scteFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return scteFilter;
        }

        public final void setScteFilter(Collection<String> scteFilter) {
            this.scteFilter = ScteFilterListCopier.copy(scteFilter);
        }

        @Override
        public final Builder scteFilterWithStrings(Collection<String> scteFilter) {
            this.scteFilter = ScteFilterListCopier.copy(scteFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scteFilterWithStrings(String... scteFilter) {
            scteFilterWithStrings(Arrays.asList(scteFilter));
            return this;
        }

        @Override
        public final Builder scteFilter(Collection<ScteFilter> scteFilter) {
            this.scteFilter = ScteFilterListCopier.copyEnumToString(scteFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scteFilter(ScteFilter... scteFilter) {
            scteFilter(Arrays.asList(scteFilter));
            return this;
        }

        @Override
        public Scte build() {
            return new Scte(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
