/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SCTE configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScteDash implements SdkPojo, Serializable, ToCopyableBuilder<ScteDash.Builder, ScteDash> {
    private static final SdkField<String> AD_MARKER_DASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdMarkerDash").getter(getter(ScteDash::adMarkerDashAsString)).setter(setter(Builder::adMarkerDash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdMarkerDash").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKER_DASH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String adMarkerDash;

    private ScteDash(BuilderImpl builder) {
        this.adMarkerDash = builder.adMarkerDash;
    }

    /**
     * <p>
     * Choose how ad markers are included in the packaged content. If you include ad markers in the content stream in
     * your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the output.
     * </p>
     * <p>
     * Value description:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Binary</code> - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full XML.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>XML</code> - The SCTE marker is expressed fully in XML.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adMarkerDash} will
     * return {@link AdMarkerDash#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adMarkerDashAsString}.
     * </p>
     * 
     * @return Choose how ad markers are included in the packaged content. If you include ad markers in the content
     *         stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in
     *         the output.</p>
     *         <p>
     *         Value description:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Binary</code> - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full
     *         XML.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>XML</code> - The SCTE marker is expressed fully in XML.
     *         </p>
     *         </li>
     * @see AdMarkerDash
     */
    public final AdMarkerDash adMarkerDash() {
        return AdMarkerDash.fromValue(adMarkerDash);
    }

    /**
     * <p>
     * Choose how ad markers are included in the packaged content. If you include ad markers in the content stream in
     * your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the output.
     * </p>
     * <p>
     * Value description:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Binary</code> - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full XML.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>XML</code> - The SCTE marker is expressed fully in XML.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adMarkerDash} will
     * return {@link AdMarkerDash#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adMarkerDashAsString}.
     * </p>
     * 
     * @return Choose how ad markers are included in the packaged content. If you include ad markers in the content
     *         stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in
     *         the output.</p>
     *         <p>
     *         Value description:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Binary</code> - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full
     *         XML.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>XML</code> - The SCTE marker is expressed fully in XML.
     *         </p>
     *         </li>
     * @see AdMarkerDash
     */
    public final String adMarkerDashAsString() {
        return adMarkerDash;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adMarkerDashAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScteDash)) {
            return false;
        }
        ScteDash other = (ScteDash) obj;
        return Objects.equals(adMarkerDashAsString(), other.adMarkerDashAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScteDash").add("AdMarkerDash", adMarkerDashAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdMarkerDash":
            return Optional.ofNullable(clazz.cast(adMarkerDashAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdMarkerDash", AD_MARKER_DASH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScteDash, T> g) {
        return obj -> g.apply((ScteDash) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScteDash> {
        /**
         * <p>
         * Choose how ad markers are included in the packaged content. If you include ad markers in the content stream
         * in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the output.
         * </p>
         * <p>
         * Value description:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Binary</code> - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full XML.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>XML</code> - The SCTE marker is expressed fully in XML.
         * </p>
         * </li>
         * </ul>
         * 
         * @param adMarkerDash
         *        Choose how ad markers are included in the packaged content. If you include ad markers in the content
         *        stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers
         *        in the output.</p>
         *        <p>
         *        Value description:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Binary</code> - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full
         *        XML.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>XML</code> - The SCTE marker is expressed fully in XML.
         *        </p>
         *        </li>
         * @see AdMarkerDash
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdMarkerDash
         */
        Builder adMarkerDash(String adMarkerDash);

        /**
         * <p>
         * Choose how ad markers are included in the packaged content. If you include ad markers in the content stream
         * in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the output.
         * </p>
         * <p>
         * Value description:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Binary</code> - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full XML.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>XML</code> - The SCTE marker is expressed fully in XML.
         * </p>
         * </li>
         * </ul>
         * 
         * @param adMarkerDash
         *        Choose how ad markers are included in the packaged content. If you include ad markers in the content
         *        stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers
         *        in the output.</p>
         *        <p>
         *        Value description:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Binary</code> - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full
         *        XML.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>XML</code> - The SCTE marker is expressed fully in XML.
         *        </p>
         *        </li>
         * @see AdMarkerDash
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdMarkerDash
         */
        Builder adMarkerDash(AdMarkerDash adMarkerDash);
    }

    static final class BuilderImpl implements Builder {
        private String adMarkerDash;

        private BuilderImpl() {
        }

        private BuilderImpl(ScteDash model) {
            adMarkerDash(model.adMarkerDash);
        }

        public final String getAdMarkerDash() {
            return adMarkerDash;
        }

        public final void setAdMarkerDash(String adMarkerDash) {
            this.adMarkerDash = adMarkerDash;
        }

        @Override
        public final Builder adMarkerDash(String adMarkerDash) {
            this.adMarkerDash = adMarkerDash;
            return this;
        }

        @Override
        public final Builder adMarkerDash(AdMarkerDash adMarkerDash) {
            this.adMarkerDash(adMarkerDash == null ? null : adMarkerDash.toString());
            return this;
        }

        @Override
        public ScteDash build() {
            return new ScteDash(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
