/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SCTE configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScteHls implements SdkPojo, Serializable, ToCopyableBuilder<ScteHls.Builder, ScteHls> {
    private static final SdkField<String> AD_MARKER_HLS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdMarkerHls").getter(getter(ScteHls::adMarkerHlsAsString)).setter(setter(Builder::adMarkerHls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdMarkerHls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKER_HLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String adMarkerHls;

    private ScteHls(BuilderImpl builder) {
        this.adMarkerHls = builder.adMarkerHls;
    }

    /**
     * <p>
     * Ad markers indicate when ads should be inserted during playback. If you include ad markers in the content stream
     * in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the output.
     * Choose what you want MediaPackage to do with the ad markers.
     * </p>
     * <p>
     * Value description:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DATERANGE - Insert EXT-X-DATERANGE tags to signal ad and program transition events in TS and CMAF manifests. If
     * you use DATERANGE, you must set a programDateTimeIntervalSeconds value of 1 or higher. To learn more about
     * DATERANGE, see <a
     * href="http://docs.aws.amazon.com/mediapackage/latest/ug/scte-35-ad-marker-ext-x-daterange.html">SCTE-35 Ad Marker
     * EXT-X-DATERANGE</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adMarkerHls} will
     * return {@link AdMarkerHls#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adMarkerHlsAsString}.
     * </p>
     * 
     * @return Ad markers indicate when ads should be inserted during playback. If you include ad markers in the content
     *         stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in
     *         the output. Choose what you want MediaPackage to do with the ad markers.</p>
     *         <p>
     *         Value description:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         DATERANGE - Insert EXT-X-DATERANGE tags to signal ad and program transition events in TS and CMAF
     *         manifests. If you use DATERANGE, you must set a programDateTimeIntervalSeconds value of 1 or higher. To
     *         learn more about DATERANGE, see <a
     *         href="http://docs.aws.amazon.com/mediapackage/latest/ug/scte-35-ad-marker-ext-x-daterange.html">SCTE-35
     *         Ad Marker EXT-X-DATERANGE</a>.
     *         </p>
     *         </li>
     * @see AdMarkerHls
     */
    public final AdMarkerHls adMarkerHls() {
        return AdMarkerHls.fromValue(adMarkerHls);
    }

    /**
     * <p>
     * Ad markers indicate when ads should be inserted during playback. If you include ad markers in the content stream
     * in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the output.
     * Choose what you want MediaPackage to do with the ad markers.
     * </p>
     * <p>
     * Value description:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DATERANGE - Insert EXT-X-DATERANGE tags to signal ad and program transition events in TS and CMAF manifests. If
     * you use DATERANGE, you must set a programDateTimeIntervalSeconds value of 1 or higher. To learn more about
     * DATERANGE, see <a
     * href="http://docs.aws.amazon.com/mediapackage/latest/ug/scte-35-ad-marker-ext-x-daterange.html">SCTE-35 Ad Marker
     * EXT-X-DATERANGE</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adMarkerHls} will
     * return {@link AdMarkerHls#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adMarkerHlsAsString}.
     * </p>
     * 
     * @return Ad markers indicate when ads should be inserted during playback. If you include ad markers in the content
     *         stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in
     *         the output. Choose what you want MediaPackage to do with the ad markers.</p>
     *         <p>
     *         Value description:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         DATERANGE - Insert EXT-X-DATERANGE tags to signal ad and program transition events in TS and CMAF
     *         manifests. If you use DATERANGE, you must set a programDateTimeIntervalSeconds value of 1 or higher. To
     *         learn more about DATERANGE, see <a
     *         href="http://docs.aws.amazon.com/mediapackage/latest/ug/scte-35-ad-marker-ext-x-daterange.html">SCTE-35
     *         Ad Marker EXT-X-DATERANGE</a>.
     *         </p>
     *         </li>
     * @see AdMarkerHls
     */
    public final String adMarkerHlsAsString() {
        return adMarkerHls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adMarkerHlsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScteHls)) {
            return false;
        }
        ScteHls other = (ScteHls) obj;
        return Objects.equals(adMarkerHlsAsString(), other.adMarkerHlsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScteHls").add("AdMarkerHls", adMarkerHlsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdMarkerHls":
            return Optional.ofNullable(clazz.cast(adMarkerHlsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdMarkerHls", AD_MARKER_HLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScteHls, T> g) {
        return obj -> g.apply((ScteHls) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScteHls> {
        /**
         * <p>
         * Ad markers indicate when ads should be inserted during playback. If you include ad markers in the content
         * stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the
         * output. Choose what you want MediaPackage to do with the ad markers.
         * </p>
         * <p>
         * Value description:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DATERANGE - Insert EXT-X-DATERANGE tags to signal ad and program transition events in TS and CMAF manifests.
         * If you use DATERANGE, you must set a programDateTimeIntervalSeconds value of 1 or higher. To learn more about
         * DATERANGE, see <a
         * href="http://docs.aws.amazon.com/mediapackage/latest/ug/scte-35-ad-marker-ext-x-daterange.html">SCTE-35 Ad
         * Marker EXT-X-DATERANGE</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param adMarkerHls
         *        Ad markers indicate when ads should be inserted during playback. If you include ad markers in the
         *        content stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad
         *        markers in the output. Choose what you want MediaPackage to do with the ad markers.</p>
         *        <p>
         *        Value description:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        DATERANGE - Insert EXT-X-DATERANGE tags to signal ad and program transition events in TS and CMAF
         *        manifests. If you use DATERANGE, you must set a programDateTimeIntervalSeconds value of 1 or higher.
         *        To learn more about DATERANGE, see <a
         *        href="http://docs.aws.amazon.com/mediapackage/latest/ug/scte-35-ad-marker-ext-x-daterange.html"
         *        >SCTE-35 Ad Marker EXT-X-DATERANGE</a>.
         *        </p>
         *        </li>
         * @see AdMarkerHls
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdMarkerHls
         */
        Builder adMarkerHls(String adMarkerHls);

        /**
         * <p>
         * Ad markers indicate when ads should be inserted during playback. If you include ad markers in the content
         * stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the
         * output. Choose what you want MediaPackage to do with the ad markers.
         * </p>
         * <p>
         * Value description:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DATERANGE - Insert EXT-X-DATERANGE tags to signal ad and program transition events in TS and CMAF manifests.
         * If you use DATERANGE, you must set a programDateTimeIntervalSeconds value of 1 or higher. To learn more about
         * DATERANGE, see <a
         * href="http://docs.aws.amazon.com/mediapackage/latest/ug/scte-35-ad-marker-ext-x-daterange.html">SCTE-35 Ad
         * Marker EXT-X-DATERANGE</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param adMarkerHls
         *        Ad markers indicate when ads should be inserted during playback. If you include ad markers in the
         *        content stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad
         *        markers in the output. Choose what you want MediaPackage to do with the ad markers.</p>
         *        <p>
         *        Value description:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        DATERANGE - Insert EXT-X-DATERANGE tags to signal ad and program transition events in TS and CMAF
         *        manifests. If you use DATERANGE, you must set a programDateTimeIntervalSeconds value of 1 or higher.
         *        To learn more about DATERANGE, see <a
         *        href="http://docs.aws.amazon.com/mediapackage/latest/ug/scte-35-ad-marker-ext-x-daterange.html"
         *        >SCTE-35 Ad Marker EXT-X-DATERANGE</a>.
         *        </p>
         *        </li>
         * @see AdMarkerHls
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdMarkerHls
         */
        Builder adMarkerHls(AdMarkerHls adMarkerHls);
    }

    static final class BuilderImpl implements Builder {
        private String adMarkerHls;

        private BuilderImpl() {
        }

        private BuilderImpl(ScteHls model) {
            adMarkerHls(model.adMarkerHls);
        }

        public final String getAdMarkerHls() {
            return adMarkerHls;
        }

        public final void setAdMarkerHls(String adMarkerHls) {
            this.adMarkerHls = adMarkerHls;
        }

        @Override
        public final Builder adMarkerHls(String adMarkerHls) {
            this.adMarkerHls = adMarkerHls;
            return this;
        }

        @Override
        public final Builder adMarkerHls(AdMarkerHls adMarkerHls) {
            this.adMarkerHls(adMarkerHls == null ? null : adMarkerHls.toString());
            return this;
        }

        @Override
        public ScteHls build() {
            return new ScteHls(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
