/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * To insert an EXT-X-START tag in your HLS playlist, specify a StartTag configuration object with a valid TimeOffset.
 * When you do, you can also optionally specify whether to include a PRECISE value in the EXT-X-START tag.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTag implements SdkPojo, Serializable, ToCopyableBuilder<StartTag.Builder, StartTag> {
    private static final SdkField<Float> TIME_OFFSET_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("TimeOffset").getter(getter(StartTag::timeOffset)).setter(setter(Builder::timeOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeOffset").build()).build();

    private static final SdkField<Boolean> PRECISE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Precise").getter(getter(StartTag::precise)).setter(setter(Builder::precise))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precise").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_OFFSET_FIELD,
            PRECISE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float timeOffset;

    private final Boolean precise;

    private StartTag(BuilderImpl builder) {
        this.timeOffset = builder.timeOffset;
        this.precise = builder.precise;
    }

    /**
     * <p>
     * Specify the value for TIME-OFFSET within your EXT-X-START tag. Enter a signed floating point value which, if
     * positive, must be less than the configured manifest duration minus three times the configured segment target
     * duration. If negative, the absolute value must be larger than three times the configured segment target duration,
     * and the absolute value must be smaller than the configured manifest duration.
     * </p>
     * 
     * @return Specify the value for TIME-OFFSET within your EXT-X-START tag. Enter a signed floating point value which,
     *         if positive, must be less than the configured manifest duration minus three times the configured segment
     *         target duration. If negative, the absolute value must be larger than three times the configured segment
     *         target duration, and the absolute value must be smaller than the configured manifest duration.
     */
    public final Float timeOffset() {
        return timeOffset;
    }

    /**
     * <p>
     * Specify the value for PRECISE within your EXT-X-START tag. Leave blank, or choose false, to use the default value
     * NO. Choose yes to use the value YES.
     * </p>
     * 
     * @return Specify the value for PRECISE within your EXT-X-START tag. Leave blank, or choose false, to use the
     *         default value NO. Choose yes to use the value YES.
     */
    public final Boolean precise() {
        return precise;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeOffset());
        hashCode = 31 * hashCode + Objects.hashCode(precise());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTag)) {
            return false;
        }
        StartTag other = (StartTag) obj;
        return Objects.equals(timeOffset(), other.timeOffset()) && Objects.equals(precise(), other.precise());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTag").add("TimeOffset", timeOffset()).add("Precise", precise()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeOffset":
            return Optional.ofNullable(clazz.cast(timeOffset()));
        case "Precise":
            return Optional.ofNullable(clazz.cast(precise()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimeOffset", TIME_OFFSET_FIELD);
        map.put("Precise", PRECISE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTag, T> g) {
        return obj -> g.apply((StartTag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartTag> {
        /**
         * <p>
         * Specify the value for TIME-OFFSET within your EXT-X-START tag. Enter a signed floating point value which, if
         * positive, must be less than the configured manifest duration minus three times the configured segment target
         * duration. If negative, the absolute value must be larger than three times the configured segment target
         * duration, and the absolute value must be smaller than the configured manifest duration.
         * </p>
         * 
         * @param timeOffset
         *        Specify the value for TIME-OFFSET within your EXT-X-START tag. Enter a signed floating point value
         *        which, if positive, must be less than the configured manifest duration minus three times the
         *        configured segment target duration. If negative, the absolute value must be larger than three times
         *        the configured segment target duration, and the absolute value must be smaller than the configured
         *        manifest duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeOffset(Float timeOffset);

        /**
         * <p>
         * Specify the value for PRECISE within your EXT-X-START tag. Leave blank, or choose false, to use the default
         * value NO. Choose yes to use the value YES.
         * </p>
         * 
         * @param precise
         *        Specify the value for PRECISE within your EXT-X-START tag. Leave blank, or choose false, to use the
         *        default value NO. Choose yes to use the value YES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precise(Boolean precise);
    }

    static final class BuilderImpl implements Builder {
        private Float timeOffset;

        private Boolean precise;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTag model) {
            timeOffset(model.timeOffset);
            precise(model.precise);
        }

        public final Float getTimeOffset() {
            return timeOffset;
        }

        public final void setTimeOffset(Float timeOffset) {
            this.timeOffset = timeOffset;
        }

        @Override
        public final Builder timeOffset(Float timeOffset) {
            this.timeOffset = timeOffset;
            return this;
        }

        public final Boolean getPrecise() {
            return precise;
        }

        public final void setPrecise(Boolean precise) {
            this.precise = precise;
        }

        @Override
        public final Builder precise(Boolean precise) {
            this.precise = precise;
            return this;
        }

        @Override
        public StartTag build() {
            return new StartTag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
