/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input failed to meet the constraints specified by the AWS service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationException extends MediaPackageV2Exception implements
        ToCopyableBuilder<ValidationException.Builder, ValidationException> {
    private static final SdkField<String> VALIDATION_EXCEPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationExceptionType").getter(getter(ValidationException::validationExceptionTypeAsString))
            .setter(setter(Builder::validationExceptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationExceptionType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VALIDATION_EXCEPTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String validationExceptionType;

    private ValidationException(BuilderImpl builder) {
        super(builder);
        this.validationExceptionType = builder.validationExceptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The type of ValidationException.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #validationExceptionType} will return {@link ValidationExceptionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #validationExceptionTypeAsString}.
     * </p>
     * 
     * @return The type of ValidationException.
     * @see ValidationExceptionType
     */
    public ValidationExceptionType validationExceptionType() {
        return ValidationExceptionType.fromValue(validationExceptionType);
    }

    /**
     * <p>
     * The type of ValidationException.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #validationExceptionType} will return {@link ValidationExceptionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #validationExceptionTypeAsString}.
     * </p>
     * 
     * @return The type of ValidationException.
     * @see ValidationExceptionType
     */
    public String validationExceptionTypeAsString() {
        return validationExceptionType;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ValidationExceptionType", VALIDATION_EXCEPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationException, T> g) {
        return obj -> g.apply((ValidationException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationException>, MediaPackageV2Exception.Builder {
        /**
         * <p>
         * The type of ValidationException.
         * </p>
         * 
         * @param validationExceptionType
         *        The type of ValidationException.
         * @see ValidationExceptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionType
         */
        Builder validationExceptionType(String validationExceptionType);

        /**
         * <p>
         * The type of ValidationException.
         * </p>
         * 
         * @param validationExceptionType
         *        The type of ValidationException.
         * @see ValidationExceptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionType
         */
        Builder validationExceptionType(ValidationExceptionType validationExceptionType);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends MediaPackageV2Exception.BuilderImpl implements Builder {
        private String validationExceptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationException model) {
            super(model);
            validationExceptionType(model.validationExceptionType);
        }

        public final String getValidationExceptionType() {
            return validationExceptionType;
        }

        public final void setValidationExceptionType(String validationExceptionType) {
            this.validationExceptionType = validationExceptionType;
        }

        @Override
        public final Builder validationExceptionType(String validationExceptionType) {
            this.validationExceptionType = validationExceptionType;
            return this;
        }

        @Override
        public final Builder validationExceptionType(ValidationExceptionType validationExceptionType) {
            this.validationExceptionType(validationExceptionType == null ? null : validationExceptionType.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ValidationException build() {
            return new ValidationException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
