/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2Client;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2ServiceClientConfiguration;
import software.amazon.awssdk.services.mediapackagev2.internal.MediaPackageV2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.mediapackagev2.model.AccessDeniedException;
import software.amazon.awssdk.services.mediapackagev2.model.CancelHarvestJobRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CancelHarvestJobResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ConflictException;
import software.amazon.awssdk.services.mediapackagev2.model.CreateChannelGroupRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CreateChannelGroupResponse;
import software.amazon.awssdk.services.mediapackagev2.model.CreateChannelRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CreateChannelResponse;
import software.amazon.awssdk.services.mediapackagev2.model.CreateHarvestJobRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CreateHarvestJobResponse;
import software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetHarvestJobRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetHarvestJobResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointResponse;
import software.amazon.awssdk.services.mediapackagev2.model.InternalServerException;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediapackagev2.model.MediaPackageV2Exception;
import software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.PutOriginEndpointPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.PutOriginEndpointPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ResetChannelStateRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ResetChannelStateResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ResetOriginEndpointStateRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ResetOriginEndpointStateResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.mediapackagev2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.mediapackagev2.model.TagResourceRequest;
import software.amazon.awssdk.services.mediapackagev2.model.TagResourceResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ThrottlingException;
import software.amazon.awssdk.services.mediapackagev2.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediapackagev2.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupRequest;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupResponse;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelRequest;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelResponse;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointRequest;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ValidationException;
import software.amazon.awssdk.services.mediapackagev2.transform.CancelHarvestJobRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.CreateChannelGroupRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.CreateChannelRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.CreateHarvestJobRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.CreateOriginEndpointRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.DeleteChannelGroupRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.DeleteChannelPolicyRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.DeleteChannelRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.DeleteOriginEndpointPolicyRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.DeleteOriginEndpointRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.GetChannelGroupRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.GetChannelPolicyRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.GetChannelRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.GetHarvestJobRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.GetOriginEndpointPolicyRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.GetOriginEndpointRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.ListChannelGroupsRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.ListChannelsRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.ListHarvestJobsRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.ListOriginEndpointsRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.PutChannelPolicyRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.PutOriginEndpointPolicyRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.ResetChannelStateRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.ResetOriginEndpointStateRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.UpdateChannelGroupRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.UpdateChannelRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.transform.UpdateOriginEndpointRequestMarshaller;
import software.amazon.awssdk.services.mediapackagev2.waiters.MediaPackageV2Waiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultMediaPackageV2Client
implements MediaPackageV2Client {
    private static final Logger log = Logger.loggerFor(DefaultMediaPackageV2Client.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMediaPackageV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelHarvestJobResponse cancelHarvestJob(CancelHarvestJobRequest cancelHarvestJobRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelHarvestJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelHarvestJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, cancelHarvestJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelHarvestJob");
            CancelHarvestJobResponse cancelHarvestJobResponse = (CancelHarvestJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelHarvestJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelHarvestJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelHarvestJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelHarvestJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$cancelHarvestJob$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, createChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateChannel");
            CreateChannelResponse createChannelResponse = (CreateChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$createChannel$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateChannelGroupResponse createChannelGroup(CreateChannelGroupRequest createChannelGroupRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateChannelGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createChannelGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, createChannelGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateChannelGroup");
            CreateChannelGroupResponse createChannelGroupResponse = (CreateChannelGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateChannelGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createChannelGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateChannelGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createChannelGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$createChannelGroup$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHarvestJobResponse createHarvestJob(CreateHarvestJobRequest createHarvestJobRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHarvestJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHarvestJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, createHarvestJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHarvestJob");
            CreateHarvestJobResponse createHarvestJobResponse = (CreateHarvestJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHarvestJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createHarvestJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateHarvestJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createHarvestJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$createHarvestJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateOriginEndpointResponse createOriginEndpoint(CreateOriginEndpointRequest createOriginEndpointRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateOriginEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createOriginEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, createOriginEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateOriginEndpoint");
            CreateOriginEndpointResponse createOriginEndpointResponse = (CreateOriginEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOriginEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createOriginEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateOriginEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createOriginEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$createOriginEndpoint$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, deleteChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteChannel");
            DeleteChannelResponse deleteChannelResponse = (DeleteChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$deleteChannel$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteChannelGroupResponse deleteChannelGroup(DeleteChannelGroupRequest deleteChannelGroupRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteChannelGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteChannelGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, deleteChannelGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteChannelGroup");
            DeleteChannelGroupResponse deleteChannelGroupResponse = (DeleteChannelGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteChannelGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteChannelGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteChannelGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteChannelGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$deleteChannelGroup$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteChannelPolicyResponse deleteChannelPolicy(DeleteChannelPolicyRequest deleteChannelPolicyRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteChannelPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteChannelPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, deleteChannelPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteChannelPolicy");
            DeleteChannelPolicyResponse deleteChannelPolicyResponse = (DeleteChannelPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteChannelPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteChannelPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteChannelPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteChannelPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$deleteChannelPolicy$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOriginEndpointResponse deleteOriginEndpoint(DeleteOriginEndpointRequest deleteOriginEndpointRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOriginEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteOriginEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, deleteOriginEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOriginEndpoint");
            DeleteOriginEndpointResponse deleteOriginEndpointResponse = (DeleteOriginEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOriginEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteOriginEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteOriginEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteOriginEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$deleteOriginEndpoint$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOriginEndpointPolicyResponse deleteOriginEndpointPolicy(DeleteOriginEndpointPolicyRequest deleteOriginEndpointPolicyRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOriginEndpointPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteOriginEndpointPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, deleteOriginEndpointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOriginEndpointPolicy");
            DeleteOriginEndpointPolicyResponse deleteOriginEndpointPolicyResponse = (DeleteOriginEndpointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOriginEndpointPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteOriginEndpointPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteOriginEndpointPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteOriginEndpointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$deleteOriginEndpointPolicy$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChannelResponse getChannel(GetChannelRequest getChannelRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, getChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChannel");
            GetChannelResponse getChannelResponse = (GetChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$getChannel$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChannelGroupResponse getChannelGroup(GetChannelGroupRequest getChannelGroupRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetChannelGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getChannelGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, getChannelGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChannelGroup");
            GetChannelGroupResponse getChannelGroupResponse = (GetChannelGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChannelGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getChannelGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetChannelGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getChannelGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$getChannelGroup$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChannelPolicyResponse getChannelPolicy(GetChannelPolicyRequest getChannelPolicyRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetChannelPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getChannelPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, getChannelPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChannelPolicy");
            GetChannelPolicyResponse getChannelPolicyResponse = (GetChannelPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChannelPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getChannelPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetChannelPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getChannelPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$getChannelPolicy$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHarvestJobResponse getHarvestJob(GetHarvestJobRequest getHarvestJobRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetHarvestJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getHarvestJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, getHarvestJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHarvestJob");
            GetHarvestJobResponse getHarvestJobResponse = (GetHarvestJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHarvestJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getHarvestJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetHarvestJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getHarvestJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$getHarvestJob$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOriginEndpointResponse getOriginEndpoint(GetOriginEndpointRequest getOriginEndpointRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOriginEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOriginEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, getOriginEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOriginEndpoint");
            GetOriginEndpointResponse getOriginEndpointResponse = (GetOriginEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOriginEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getOriginEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOriginEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOriginEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$getOriginEndpoint$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOriginEndpointPolicyResponse getOriginEndpointPolicy(GetOriginEndpointPolicyRequest getOriginEndpointPolicyRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOriginEndpointPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOriginEndpointPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, getOriginEndpointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOriginEndpointPolicy");
            GetOriginEndpointPolicyResponse getOriginEndpointPolicyResponse = (GetOriginEndpointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOriginEndpointPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getOriginEndpointPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOriginEndpointPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOriginEndpointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$getOriginEndpointPolicy$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListChannelGroupsResponse listChannelGroups(ListChannelGroupsRequest listChannelGroupsRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChannelGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listChannelGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, listChannelGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListChannelGroups");
            ListChannelGroupsResponse listChannelGroupsResponse = (ListChannelGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChannelGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listChannelGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListChannelGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listChannelGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$listChannelGroups$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChannelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, listChannelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListChannels");
            ListChannelsResponse listChannelsResponse = (ListChannelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChannels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listChannelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listChannelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$listChannels$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHarvestJobsResponse listHarvestJobs(ListHarvestJobsRequest listHarvestJobsRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHarvestJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listHarvestJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, listHarvestJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHarvestJobs");
            ListHarvestJobsResponse listHarvestJobsResponse = (ListHarvestJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHarvestJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listHarvestJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListHarvestJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listHarvestJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$listHarvestJobs$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOriginEndpointsResponse listOriginEndpoints(ListOriginEndpointsRequest listOriginEndpointsRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOriginEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOriginEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, listOriginEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOriginEndpoints");
            ListOriginEndpointsResponse listOriginEndpointsResponse = (ListOriginEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOriginEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listOriginEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOriginEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOriginEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$listOriginEndpoints$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$listTagsForResource$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutChannelPolicyResponse putChannelPolicy(PutChannelPolicyRequest putChannelPolicyRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutChannelPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putChannelPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, putChannelPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutChannelPolicy");
            PutChannelPolicyResponse putChannelPolicyResponse = (PutChannelPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutChannelPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putChannelPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutChannelPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putChannelPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$putChannelPolicy$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutOriginEndpointPolicyResponse putOriginEndpointPolicy(PutOriginEndpointPolicyRequest putOriginEndpointPolicyRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutOriginEndpointPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putOriginEndpointPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, putOriginEndpointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutOriginEndpointPolicy");
            PutOriginEndpointPolicyResponse putOriginEndpointPolicyResponse = (PutOriginEndpointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutOriginEndpointPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putOriginEndpointPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutOriginEndpointPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putOriginEndpointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$putOriginEndpointPolicy$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetChannelStateResponse resetChannelState(ResetChannelStateRequest resetChannelStateRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetChannelStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resetChannelStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, resetChannelStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetChannelState");
            ResetChannelStateResponse resetChannelStateResponse = (ResetChannelStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetChannelState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)resetChannelStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetChannelStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resetChannelStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$resetChannelState$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetOriginEndpointStateResponse resetOriginEndpointState(ResetOriginEndpointStateRequest resetOriginEndpointStateRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetOriginEndpointStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resetOriginEndpointStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, resetOriginEndpointStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetOriginEndpointState");
            ResetOriginEndpointStateResponse resetOriginEndpointStateResponse = (ResetOriginEndpointStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetOriginEndpointState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)resetOriginEndpointStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetOriginEndpointStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resetOriginEndpointStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$resetOriginEndpointState$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$tagResource$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$untagResource$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateChannelResponse updateChannel(UpdateChannelRequest updateChannelRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, updateChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateChannel");
            UpdateChannelResponse updateChannelResponse = (UpdateChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$updateChannel$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateChannelGroupResponse updateChannelGroup(UpdateChannelGroupRequest updateChannelGroupRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateChannelGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateChannelGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, updateChannelGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateChannelGroup");
            UpdateChannelGroupResponse updateChannelGroupResponse = (UpdateChannelGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateChannelGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateChannelGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateChannelGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateChannelGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$updateChannelGroup$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOriginEndpointResponse updateOriginEndpoint(UpdateOriginEndpointRequest updateOriginEndpointRequest) throws ThrottlingException, ConflictException, InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateOriginEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateOriginEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaPackageV2Client.resolveMetricPublishers(clientConfiguration, updateOriginEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackageV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateOriginEndpoint");
            UpdateOriginEndpointResponse updateOriginEndpointResponse = (UpdateOriginEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOriginEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateOriginEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateOriginEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateOriginEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaPackageV2Client.lambda$updateOriginEndpoint$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public MediaPackageV2Waiter waiter() {
        return MediaPackageV2Waiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "mediapackagev2";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        MediaPackageV2ServiceClientConfigurationBuilder serviceConfigBuilder = new MediaPackageV2ServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MediaPackageV2Exception::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
    }

    @Override
    public final MediaPackageV2ServiceClientConfiguration serviceClientConfiguration() {
        return new MediaPackageV2ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateOriginEndpoint$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateChannelGroup$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateChannel$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetOriginEndpointState$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetChannelState$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putOriginEndpointPolicy$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putChannelPolicy$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOriginEndpoints$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listHarvestJobs$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listChannels$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listChannelGroups$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOriginEndpointPolicy$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOriginEndpoint$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHarvestJob$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getChannelPolicy$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getChannelGroup$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getChannel$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteOriginEndpointPolicy$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteOriginEndpoint$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteChannelPolicy$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteChannelGroup$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteChannel$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createOriginEndpoint$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHarvestJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createChannelGroup$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createChannel$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelHarvestJob$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

