/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashBaseUrl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashBaseUrl> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(DashBaseUrl.getter(DashBaseUrl::url)).setter(DashBaseUrl.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> SERVICE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceLocation").getter(DashBaseUrl.getter(DashBaseUrl::serviceLocation)).setter(DashBaseUrl.setter(Builder::serviceLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLocation").build()}).build();
    private static final SdkField<Integer> DVB_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DvbPriority").getter(DashBaseUrl.getter(DashBaseUrl::dvbPriority)).setter(DashBaseUrl.setter(Builder::dvbPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DvbPriority").build()}).build();
    private static final SdkField<Integer> DVB_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DvbWeight").getter(DashBaseUrl.getter(DashBaseUrl::dvbWeight)).setter(DashBaseUrl.setter(Builder::dvbWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DvbWeight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, SERVICE_LOCATION_FIELD, DVB_PRIORITY_FIELD, DVB_WEIGHT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DashBaseUrl.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String url;
    private final String serviceLocation;
    private final Integer dvbPriority;
    private final Integer dvbWeight;

    private DashBaseUrl(BuilderImpl builder) {
        this.url = builder.url;
        this.serviceLocation = builder.serviceLocation;
        this.dvbPriority = builder.dvbPriority;
        this.dvbWeight = builder.dvbWeight;
    }

    public final String url() {
        return this.url;
    }

    public final String serviceLocation() {
        return this.serviceLocation;
    }

    public final Integer dvbPriority() {
        return this.dvbPriority;
    }

    public final Integer dvbWeight() {
        return this.dvbWeight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbWeight());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashBaseUrl)) {
            return false;
        }
        DashBaseUrl other = (DashBaseUrl)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.serviceLocation(), other.serviceLocation()) && Objects.equals(this.dvbPriority(), other.dvbPriority()) && Objects.equals(this.dvbWeight(), other.dvbWeight());
    }

    public final String toString() {
        return ToString.builder((String)"DashBaseUrl").add("Url", (Object)this.url()).add("ServiceLocation", (Object)this.serviceLocation()).add("DvbPriority", (Object)this.dvbPriority()).add("DvbWeight", (Object)this.dvbWeight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "ServiceLocation": {
                return Optional.ofNullable(clazz.cast(this.serviceLocation()));
            }
            case "DvbPriority": {
                return Optional.ofNullable(clazz.cast(this.dvbPriority()));
            }
            case "DvbWeight": {
                return Optional.ofNullable(clazz.cast(this.dvbWeight()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Url", URL_FIELD);
        map.put("ServiceLocation", SERVICE_LOCATION_FIELD);
        map.put("DvbPriority", DVB_PRIORITY_FIELD);
        map.put("DvbWeight", DVB_WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashBaseUrl, T> g) {
        return obj -> g.apply((DashBaseUrl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String url;
        private String serviceLocation;
        private Integer dvbPriority;
        private Integer dvbWeight;

        private BuilderImpl() {
        }

        private BuilderImpl(DashBaseUrl model) {
            this.url(model.url);
            this.serviceLocation(model.serviceLocation);
            this.dvbPriority(model.dvbPriority);
            this.dvbWeight(model.dvbWeight);
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getServiceLocation() {
            return this.serviceLocation;
        }

        public final void setServiceLocation(String serviceLocation) {
            this.serviceLocation = serviceLocation;
        }

        @Override
        public final Builder serviceLocation(String serviceLocation) {
            this.serviceLocation = serviceLocation;
            return this;
        }

        public final Integer getDvbPriority() {
            return this.dvbPriority;
        }

        public final void setDvbPriority(Integer dvbPriority) {
            this.dvbPriority = dvbPriority;
        }

        @Override
        public final Builder dvbPriority(Integer dvbPriority) {
            this.dvbPriority = dvbPriority;
            return this;
        }

        public final Integer getDvbWeight() {
            return this.dvbWeight;
        }

        public final void setDvbWeight(Integer dvbWeight) {
            this.dvbWeight = dvbWeight;
        }

        @Override
        public final Builder dvbWeight(Integer dvbWeight) {
            this.dvbWeight = dvbWeight;
            return this;
        }

        public DashBaseUrl build() {
            return new DashBaseUrl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashBaseUrl> {
        public Builder url(String var1);

        public Builder serviceLocation(String var1);

        public Builder dvbPriority(Integer var1);

        public Builder dvbWeight(Integer var1);
    }
}

