/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashProgramInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashProgramInformation> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(DashProgramInformation.getter(DashProgramInformation::title)).setter(DashProgramInformation.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(DashProgramInformation.getter(DashProgramInformation::source)).setter(DashProgramInformation.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> COPYRIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Copyright").getter(DashProgramInformation.getter(DashProgramInformation::copyright)).setter(DashProgramInformation.setter(Builder::copyright)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Copyright").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(DashProgramInformation.getter(DashProgramInformation::languageCode)).setter(DashProgramInformation.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> MORE_INFORMATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MoreInformationUrl").getter(DashProgramInformation.getter(DashProgramInformation::moreInformationUrl)).setter(DashProgramInformation.setter(Builder::moreInformationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MoreInformationUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, SOURCE_FIELD, COPYRIGHT_FIELD, LANGUAGE_CODE_FIELD, MORE_INFORMATION_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DashProgramInformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String source;
    private final String copyright;
    private final String languageCode;
    private final String moreInformationUrl;

    private DashProgramInformation(BuilderImpl builder) {
        this.title = builder.title;
        this.source = builder.source;
        this.copyright = builder.copyright;
        this.languageCode = builder.languageCode;
        this.moreInformationUrl = builder.moreInformationUrl;
    }

    public final String title() {
        return this.title;
    }

    public final String source() {
        return this.source;
    }

    public final String copyright() {
        return this.copyright;
    }

    public final String languageCode() {
        return this.languageCode;
    }

    public final String moreInformationUrl() {
        return this.moreInformationUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyright());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.moreInformationUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashProgramInformation)) {
            return false;
        }
        DashProgramInformation other = (DashProgramInformation)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.copyright(), other.copyright()) && Objects.equals(this.languageCode(), other.languageCode()) && Objects.equals(this.moreInformationUrl(), other.moreInformationUrl());
    }

    public final String toString() {
        return ToString.builder((String)"DashProgramInformation").add("Title", (Object)this.title()).add("Source", (Object)this.source()).add("Copyright", (Object)this.copyright()).add("LanguageCode", (Object)this.languageCode()).add("MoreInformationUrl", (Object)this.moreInformationUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Copyright": {
                return Optional.ofNullable(clazz.cast(this.copyright()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCode()));
            }
            case "MoreInformationUrl": {
                return Optional.ofNullable(clazz.cast(this.moreInformationUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Title", TITLE_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Copyright", COPYRIGHT_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("MoreInformationUrl", MORE_INFORMATION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashProgramInformation, T> g) {
        return obj -> g.apply((DashProgramInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String source;
        private String copyright;
        private String languageCode;
        private String moreInformationUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(DashProgramInformation model) {
            this.title(model.title);
            this.source(model.source);
            this.copyright(model.copyright);
            this.languageCode(model.languageCode);
            this.moreInformationUrl(model.moreInformationUrl);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getCopyright() {
            return this.copyright;
        }

        public final void setCopyright(String copyright) {
            this.copyright = copyright;
        }

        @Override
        public final Builder copyright(String copyright) {
            this.copyright = copyright;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final String getMoreInformationUrl() {
            return this.moreInformationUrl;
        }

        public final void setMoreInformationUrl(String moreInformationUrl) {
            this.moreInformationUrl = moreInformationUrl;
        }

        @Override
        public final Builder moreInformationUrl(String moreInformationUrl) {
            this.moreInformationUrl = moreInformationUrl;
            return this;
        }

        public DashProgramInformation build() {
            return new DashProgramInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashProgramInformation> {
        public Builder title(String var1);

        public Builder source(String var1);

        public Builder copyright(String var1);

        public Builder languageCode(String var1);

        public Builder moreInformationUrl(String var1);
    }
}

