/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagev2.model.EndpointErrorCondition;
import software.amazon.awssdk.services.mediapackagev2.model.EndpointErrorConditionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ForceEndpointErrorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ForceEndpointErrorConfiguration> {
    private static final SdkField<List<String>> ENDPOINT_ERROR_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointErrorConditions").getter(ForceEndpointErrorConfiguration.getter(ForceEndpointErrorConfiguration::endpointErrorConditionsAsStrings)).setter(ForceEndpointErrorConfiguration.setter(Builder::endpointErrorConditionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointErrorConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ERROR_CONDITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ForceEndpointErrorConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> endpointErrorConditions;

    private ForceEndpointErrorConfiguration(BuilderImpl builder) {
        this.endpointErrorConditions = builder.endpointErrorConditions;
    }

    public final List<EndpointErrorCondition> endpointErrorConditions() {
        return EndpointErrorConditionsCopier.copyStringToEnum(this.endpointErrorConditions);
    }

    public final boolean hasEndpointErrorConditions() {
        return this.endpointErrorConditions != null && !(this.endpointErrorConditions instanceof SdkAutoConstructList);
    }

    public final List<String> endpointErrorConditionsAsStrings() {
        return this.endpointErrorConditions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointErrorConditions() ? this.endpointErrorConditionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForceEndpointErrorConfiguration)) {
            return false;
        }
        ForceEndpointErrorConfiguration other = (ForceEndpointErrorConfiguration)obj;
        return this.hasEndpointErrorConditions() == other.hasEndpointErrorConditions() && Objects.equals(this.endpointErrorConditionsAsStrings(), other.endpointErrorConditionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ForceEndpointErrorConfiguration").add("EndpointErrorConditions", this.hasEndpointErrorConditions() ? this.endpointErrorConditionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointErrorConditions": {
                return Optional.ofNullable(clazz.cast(this.endpointErrorConditionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("EndpointErrorConditions", ENDPOINT_ERROR_CONDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ForceEndpointErrorConfiguration, T> g) {
        return obj -> g.apply((ForceEndpointErrorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> endpointErrorConditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ForceEndpointErrorConfiguration model) {
            this.endpointErrorConditionsWithStrings(model.endpointErrorConditions);
        }

        public final Collection<String> getEndpointErrorConditions() {
            if (this.endpointErrorConditions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpointErrorConditions;
        }

        public final void setEndpointErrorConditions(Collection<String> endpointErrorConditions) {
            this.endpointErrorConditions = EndpointErrorConditionsCopier.copy(endpointErrorConditions);
        }

        @Override
        public final Builder endpointErrorConditionsWithStrings(Collection<String> endpointErrorConditions) {
            this.endpointErrorConditions = EndpointErrorConditionsCopier.copy(endpointErrorConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointErrorConditionsWithStrings(String ... endpointErrorConditions) {
            this.endpointErrorConditionsWithStrings(Arrays.asList(endpointErrorConditions));
            return this;
        }

        @Override
        public final Builder endpointErrorConditions(Collection<EndpointErrorCondition> endpointErrorConditions) {
            this.endpointErrorConditions = EndpointErrorConditionsCopier.copyEnumToString(endpointErrorConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointErrorConditions(EndpointErrorCondition ... endpointErrorConditions) {
            this.endpointErrorConditions(Arrays.asList(endpointErrorConditions));
            return this;
        }

        public ForceEndpointErrorConfiguration build() {
            return new ForceEndpointErrorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ForceEndpointErrorConfiguration> {
        public Builder endpointErrorConditionsWithStrings(Collection<String> var1);

        public Builder endpointErrorConditionsWithStrings(String ... var1);

        public Builder endpointErrorConditions(Collection<EndpointErrorCondition> var1);

        public Builder endpointErrorConditions(EndpointErrorCondition ... var1);
    }
}

