/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.mediapackagev2.model.AccessDeniedException;
import software.amazon.awssdk.services.mediapackagev2.model.CancelHarvestJobRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CancelHarvestJobResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ConflictException;
import software.amazon.awssdk.services.mediapackagev2.model.CreateChannelGroupRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CreateChannelGroupResponse;
import software.amazon.awssdk.services.mediapackagev2.model.CreateChannelRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CreateChannelResponse;
import software.amazon.awssdk.services.mediapackagev2.model.CreateHarvestJobRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CreateHarvestJobResponse;
import software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetHarvestJobRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetHarvestJobResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointResponse;
import software.amazon.awssdk.services.mediapackagev2.model.InternalServerException;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediapackagev2.model.MediaPackageV2Exception;
import software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.PutOriginEndpointPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.PutOriginEndpointPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ResetChannelStateRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ResetChannelStateResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ResetOriginEndpointStateRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ResetOriginEndpointStateResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.mediapackagev2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.mediapackagev2.model.TagResourceRequest;
import software.amazon.awssdk.services.mediapackagev2.model.TagResourceResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ThrottlingException;
import software.amazon.awssdk.services.mediapackagev2.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediapackagev2.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupRequest;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupResponse;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelRequest;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelResponse;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointRequest;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ValidationException;
import software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelGroupsIterable;
import software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelsIterable;
import software.amazon.awssdk.services.mediapackagev2.paginators.ListHarvestJobsIterable;
import software.amazon.awssdk.services.mediapackagev2.paginators.ListOriginEndpointsIterable;
import software.amazon.awssdk.services.mediapackagev2.waiters.MediaPackageV2Waiter;

/**
 * Service client for accessing mediapackagev2. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * <note>
 * <p>
 * This guide is intended for creating AWS Elemental MediaPackage resources in MediaPackage Version 2 (v2) starting from
 * May 2023. To get started with MediaPackage v2, create your MediaPackage resources. There isn't an automated process
 * to migrate your resources from MediaPackage v1 to MediaPackage v2.
 * </p>
 * <p>
 * The names of the entities that you use to access this API, like URLs and ARNs, all have the versioning information
 * added, like &quot;v2&quot;, to distinguish from the prior version. If you used MediaPackage prior to this release,
 * you can't use the MediaPackage v2 CLI or the MediaPackage v2 API to access any MediaPackage v1 resources.
 * </p>
 * <p>
 * If you created resources in MediaPackage v1, use video on demand (VOD) workflows, and aren't looking to migrate to
 * MediaPackage v2 yet, see the <a
 * href="https://docs.aws.amazon.com/mediapackage/latest/apireference/what-is.html">MediaPackage v1 Live API
 * Reference</a>.
 * </p>
 * </note>
 * <p>
 * This is the AWS Elemental MediaPackage v2 Live REST API Reference. It describes all the MediaPackage API operations
 * for live content in detail, and provides sample requests, responses, and errors for the supported web services
 * protocols.
 * </p>
 * <p>
 * We assume that you have the IAM permissions that you need to use MediaPackage via the REST API. We also assume that
 * you are familiar with the features and operations of MediaPackage, as described in the AWS Elemental MediaPackage
 * User Guide.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MediaPackageV2Client extends AwsClient {
    String SERVICE_NAME = "mediapackagev2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mediapackagev2";

    /**
     * <p>
     * Cancels an in-progress harvest job.
     * </p>
     *
     * @param cancelHarvestJobRequest
     * @return Result of the CancelHarvestJob operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.CancelHarvestJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CancelHarvestJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelHarvestJobResponse cancelHarvestJob(CancelHarvestJobRequest cancelHarvestJobRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an in-progress harvest job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelHarvestJobRequest.Builder} avoiding the need
     * to create one manually via {@link CancelHarvestJobRequest#builder()}
     * </p>
     *
     * @param cancelHarvestJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.CancelHarvestJobRequest.Builder} to create a
     *        request.
     * @return Result of the CancelHarvestJob operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.CancelHarvestJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CancelHarvestJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelHarvestJobResponse cancelHarvestJob(Consumer<CancelHarvestJobRequest.Builder> cancelHarvestJobRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return cancelHarvestJob(CancelHarvestJobRequest.builder().applyMutation(cancelHarvestJobRequest).build());
    }

    /**
     * <p>
     * Create a channel to start receiving content streams. The channel represents the input to MediaPackage for
     * incoming live content from an encoder such as AWS Elemental MediaLive. The channel receives content, and after
     * packaging it, outputs it through an origin endpoint to downstream devices (such as video players or CDNs) that
     * request the content. You can create only one channel with each request. We recommend that you spread out channels
     * between channel groups, such as putting redundant channels in the same AWS Region in different channel groups.
     * </p>
     *
     * @param createChannelRequest
     * @return Result of the CreateChannel operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a channel to start receiving content streams. The channel represents the input to MediaPackage for
     * incoming live content from an encoder such as AWS Elemental MediaLive. The channel receives content, and after
     * packaging it, outputs it through an origin endpoint to downstream devices (such as video players or CDNs) that
     * request the content. You can create only one channel with each request. We recommend that you spread out channels
     * between channel groups, such as putting redundant channels in the same AWS Region in different channel groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateChannelRequest#builder()}
     * </p>
     *
     * @param createChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.CreateChannelRequest.Builder} to create a
     *        request.
     * @return Result of the CreateChannel operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateChannelResponse createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            MediaPackageV2Exception {
        return createChannel(CreateChannelRequest.builder().applyMutation(createChannelRequest).build());
    }

    /**
     * <p>
     * Create a channel group to group your channels and origin endpoints. A channel group is the top-level resource
     * that consists of channels and origin endpoints that are associated with it and that provides predictable URLs for
     * stream delivery. All channels and origin endpoints within the channel group are guaranteed to share the DNS. You
     * can create only one channel group with each request.
     * </p>
     *
     * @param createChannelGroupRequest
     * @return Result of the CreateChannelGroup operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.CreateChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateChannelGroupResponse createChannelGroup(CreateChannelGroupRequest createChannelGroupRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a channel group to group your channels and origin endpoints. A channel group is the top-level resource
     * that consists of channels and origin endpoints that are associated with it and that provides predictable URLs for
     * stream delivery. All channels and origin endpoints within the channel group are guaranteed to share the DNS. You
     * can create only one channel group with each request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateChannelGroupRequest#builder()}
     * </p>
     *
     * @param createChannelGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.CreateChannelGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateChannelGroup operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.CreateChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateChannelGroupResponse createChannelGroup(Consumer<CreateChannelGroupRequest.Builder> createChannelGroupRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            MediaPackageV2Exception {
        return createChannelGroup(CreateChannelGroupRequest.builder().applyMutation(createChannelGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new harvest job to export content from a MediaPackage v2 channel to an S3 bucket.
     * </p>
     *
     * @param createHarvestJobRequest
     *        The request object for creating a new harvest job.
     * @return Result of the CreateHarvestJob operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.CreateHarvestJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateHarvestJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHarvestJobResponse createHarvestJob(CreateHarvestJobRequest createHarvestJobRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new harvest job to export content from a MediaPackage v2 channel to an S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHarvestJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateHarvestJobRequest#builder()}
     * </p>
     *
     * @param createHarvestJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.CreateHarvestJobRequest.Builder} to create a
     *        request. The request object for creating a new harvest job.
     * @return Result of the CreateHarvestJob operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.CreateHarvestJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateHarvestJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHarvestJobResponse createHarvestJob(Consumer<CreateHarvestJobRequest.Builder> createHarvestJobRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            MediaPackageV2Exception {
        return createHarvestJob(CreateHarvestJobRequest.builder().applyMutation(createHarvestJobRequest).build());
    }

    /**
     * <p>
     * The endpoint is attached to a channel, and represents the output of the live content. You can associate multiple
     * endpoints to a single channel. Each endpoint gives players and downstream CDNs (such as Amazon CloudFront) access
     * to the content for playback. Content can't be served from a channel until it has an endpoint. You can create only
     * one endpoint with each request.
     * </p>
     *
     * @param createOriginEndpointRequest
     * @return Result of the CreateOriginEndpoint operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.CreateOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOriginEndpointResponse createOriginEndpoint(CreateOriginEndpointRequest createOriginEndpointRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The endpoint is attached to a channel, and represents the output of the live content. You can associate multiple
     * endpoints to a single channel. Each endpoint gives players and downstream CDNs (such as Amazon CloudFront) access
     * to the content for playback. Content can't be served from a channel until it has an endpoint. You can create only
     * one endpoint with each request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOriginEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link CreateOriginEndpointRequest#builder()}
     * </p>
     *
     * @param createOriginEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointRequest.Builder} to create
     *        a request.
     * @return Result of the CreateOriginEndpoint operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.CreateOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOriginEndpointResponse createOriginEndpoint(
            Consumer<CreateOriginEndpointRequest.Builder> createOriginEndpointRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return createOriginEndpoint(CreateOriginEndpointRequest.builder().applyMutation(createOriginEndpointRequest).build());
    }

    /**
     * <p>
     * Delete a channel to stop AWS Elemental MediaPackage from receiving further content. You must delete the channel's
     * origin endpoints before you can delete the channel.
     * </p>
     *
     * @param deleteChannelRequest
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a channel to stop AWS Elemental MediaPackage from receiving further content. You must delete the channel's
     * origin endpoints before you can delete the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteChannelRequest#builder()}
     * </p>
     *
     * @param deleteChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteChannelResponse deleteChannel(Consumer<DeleteChannelRequest.Builder> deleteChannelRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return deleteChannel(DeleteChannelRequest.builder().applyMutation(deleteChannelRequest).build());
    }

    /**
     * <p>
     * Delete a channel group. You must delete the channel group's channels and origin endpoints before you can delete
     * the channel group. If you delete a channel group, you'll lose access to the egress domain and will have to create
     * a new channel group to replace it.
     * </p>
     *
     * @param deleteChannelGroupRequest
     * @return Result of the DeleteChannelGroup operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.DeleteChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChannelGroupResponse deleteChannelGroup(DeleteChannelGroupRequest deleteChannelGroupRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a channel group. You must delete the channel group's channels and origin endpoints before you can delete
     * the channel group. If you delete a channel group, you'll lose access to the egress domain and will have to create
     * a new channel group to replace it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteChannelGroupRequest#builder()}
     * </p>
     *
     * @param deleteChannelGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteChannelGroup operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.DeleteChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChannelGroupResponse deleteChannelGroup(Consumer<DeleteChannelGroupRequest.Builder> deleteChannelGroupRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return deleteChannelGroup(DeleteChannelGroupRequest.builder().applyMutation(deleteChannelGroupRequest).build());
    }

    /**
     * <p>
     * Delete a channel policy.
     * </p>
     *
     * @param deleteChannelPolicyRequest
     * @return Result of the DeleteChannelPolicy operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.DeleteChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChannelPolicyResponse deleteChannelPolicy(DeleteChannelPolicyRequest deleteChannelPolicyRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a channel policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteChannelPolicyRequest#builder()}
     * </p>
     *
     * @param deleteChannelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteChannelPolicy operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.DeleteChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChannelPolicyResponse deleteChannelPolicy(
            Consumer<DeleteChannelPolicyRequest.Builder> deleteChannelPolicyRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        return deleteChannelPolicy(DeleteChannelPolicyRequest.builder().applyMutation(deleteChannelPolicyRequest).build());
    }

    /**
     * <p>
     * Origin endpoints can serve content until they're deleted. Delete the endpoint if it should no longer respond to
     * playback requests. You must delete all endpoints from a channel before you can delete the channel.
     * </p>
     *
     * @param deleteOriginEndpointRequest
     * @return Result of the DeleteOriginEndpoint operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.DeleteOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOriginEndpointResponse deleteOriginEndpoint(DeleteOriginEndpointRequest deleteOriginEndpointRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Origin endpoints can serve content until they're deleted. Delete the endpoint if it should no longer respond to
     * playback requests. You must delete all endpoints from a channel before you can delete the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOriginEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteOriginEndpointRequest#builder()}
     * </p>
     *
     * @param deleteOriginEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteOriginEndpoint operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.DeleteOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOriginEndpointResponse deleteOriginEndpoint(
            Consumer<DeleteOriginEndpointRequest.Builder> deleteOriginEndpointRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            MediaPackageV2Exception {
        return deleteOriginEndpoint(DeleteOriginEndpointRequest.builder().applyMutation(deleteOriginEndpointRequest).build());
    }

    /**
     * <p>
     * Delete an origin endpoint policy.
     * </p>
     *
     * @param deleteOriginEndpointPolicyRequest
     * @return Result of the DeleteOriginEndpointPolicy operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.DeleteOriginEndpointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteOriginEndpointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOriginEndpointPolicyResponse deleteOriginEndpointPolicy(
            DeleteOriginEndpointPolicyRequest deleteOriginEndpointPolicyRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an origin endpoint policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOriginEndpointPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOriginEndpointPolicyRequest#builder()}
     * </p>
     *
     * @param deleteOriginEndpointPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteOriginEndpointPolicy operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.DeleteOriginEndpointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteOriginEndpointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOriginEndpointPolicyResponse deleteOriginEndpointPolicy(
            Consumer<DeleteOriginEndpointPolicyRequest.Builder> deleteOriginEndpointPolicyRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        return deleteOriginEndpointPolicy(DeleteOriginEndpointPolicyRequest.builder()
                .applyMutation(deleteOriginEndpointPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified channel that's configured in AWS Elemental MediaPackage.
     * </p>
     *
     * @param getChannelRequest
     * @return Result of the GetChannel operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetChannelResponse getChannel(GetChannelRequest getChannelRequest) throws ThrottlingException, AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified channel that's configured in AWS Elemental MediaPackage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetChannelRequest#builder()}
     * </p>
     *
     * @param getChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetChannelRequest.Builder} to create a
     *        request.
     * @return Result of the GetChannel operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetChannelResponse getChannel(Consumer<GetChannelRequest.Builder> getChannelRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        return getChannel(GetChannelRequest.builder().applyMutation(getChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified channel group that's configured in AWS Elemental MediaPackage.
     * </p>
     *
     * @param getChannelGroupRequest
     * @return Result of the GetChannelGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.GetChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChannelGroupResponse getChannelGroup(GetChannelGroupRequest getChannelGroupRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified channel group that's configured in AWS Elemental MediaPackage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetChannelGroupRequest#builder()}
     * </p>
     *
     * @param getChannelGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupRequest.Builder} to create a
     *        request.
     * @return Result of the GetChannelGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.GetChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChannelGroupResponse getChannelGroup(Consumer<GetChannelGroupRequest.Builder> getChannelGroupRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return getChannelGroup(GetChannelGroupRequest.builder().applyMutation(getChannelGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified channel policy that's configured in AWS Elemental MediaPackage. With policies, you can
     * specify who has access to AWS resources and what actions they can perform on those resources.
     * </p>
     *
     * @param getChannelPolicyRequest
     * @return Result of the GetChannelPolicy operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.GetChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChannelPolicyResponse getChannelPolicy(GetChannelPolicyRequest getChannelPolicyRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified channel policy that's configured in AWS Elemental MediaPackage. With policies, you can
     * specify who has access to AWS resources and what actions they can perform on those resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetChannelPolicyRequest#builder()}
     * </p>
     *
     * @param getChannelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetChannelPolicy operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.GetChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChannelPolicyResponse getChannelPolicy(Consumer<GetChannelPolicyRequest.Builder> getChannelPolicyRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return getChannelPolicy(GetChannelPolicyRequest.builder().applyMutation(getChannelPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a specific harvest job.
     * </p>
     *
     * @param getHarvestJobRequest
     *        The request object for retrieving a specific harvest job.
     * @return Result of the GetHarvestJob operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.GetHarvestJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetHarvestJob" target="_top">AWS
     *      API Documentation</a>
     */
    default GetHarvestJobResponse getHarvestJob(GetHarvestJobRequest getHarvestJobRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a specific harvest job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHarvestJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetHarvestJobRequest#builder()}
     * </p>
     *
     * @param getHarvestJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetHarvestJobRequest.Builder} to create a
     *        request. The request object for retrieving a specific harvest job.
     * @return Result of the GetHarvestJob operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.GetHarvestJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetHarvestJob" target="_top">AWS
     *      API Documentation</a>
     */
    default GetHarvestJobResponse getHarvestJob(Consumer<GetHarvestJobRequest.Builder> getHarvestJobRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return getHarvestJob(GetHarvestJobRequest.builder().applyMutation(getHarvestJobRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified origin endpoint that's configured in AWS Elemental MediaPackage to obtain its playback
     * URL and to view the packaging settings that it's currently using.
     * </p>
     *
     * @param getOriginEndpointRequest
     * @return Result of the GetOriginEndpoint operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.GetOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOriginEndpointResponse getOriginEndpoint(GetOriginEndpointRequest getOriginEndpointRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified origin endpoint that's configured in AWS Elemental MediaPackage to obtain its playback
     * URL and to view the packaging settings that it's currently using.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOriginEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link GetOriginEndpointRequest#builder()}
     * </p>
     *
     * @param getOriginEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the GetOriginEndpoint operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.GetOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOriginEndpointResponse getOriginEndpoint(Consumer<GetOriginEndpointRequest.Builder> getOriginEndpointRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return getOriginEndpoint(GetOriginEndpointRequest.builder().applyMutation(getOriginEndpointRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified origin endpoint policy that's configured in AWS Elemental MediaPackage.
     * </p>
     *
     * @param getOriginEndpointPolicyRequest
     * @return Result of the GetOriginEndpointPolicy operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.GetOriginEndpointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetOriginEndpointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOriginEndpointPolicyResponse getOriginEndpointPolicy(GetOriginEndpointPolicyRequest getOriginEndpointPolicyRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified origin endpoint policy that's configured in AWS Elemental MediaPackage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOriginEndpointPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetOriginEndpointPolicyRequest#builder()}
     * </p>
     *
     * @param getOriginEndpointPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the GetOriginEndpointPolicy operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.GetOriginEndpointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetOriginEndpointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOriginEndpointPolicyResponse getOriginEndpointPolicy(
            Consumer<GetOriginEndpointPolicyRequest.Builder> getOriginEndpointPolicyRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        return getOriginEndpointPolicy(GetOriginEndpointPolicyRequest.builder().applyMutation(getOriginEndpointPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves all channel groups that are configured in Elemental MediaPackage.
     * </p>
     *
     * @param listChannelGroupsRequest
     * @return Result of the ListChannelGroups operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListChannelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelGroupsResponse listChannelGroups(ListChannelGroupsRequest listChannelGroupsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all channel groups that are configured in Elemental MediaPackage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListChannelGroupsRequest#builder()}
     * </p>
     *
     * @param listChannelGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListChannelGroups operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListChannelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelGroupsResponse listChannelGroups(Consumer<ListChannelGroupsRequest.Builder> listChannelGroupsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        return listChannelGroups(ListChannelGroupsRequest.builder().applyMutation(listChannelGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannelGroups(software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelGroupsIterable responses = client.listChannelGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelGroupsIterable responses = client
     *             .listChannelGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelGroupsIterable responses = client.listChannelGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannelGroups(software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChannelGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListChannelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelGroupsIterable listChannelGroupsPaginator(ListChannelGroupsRequest listChannelGroupsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        return new ListChannelGroupsIterable(this, listChannelGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannelGroups(software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelGroupsIterable responses = client.listChannelGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelGroupsIterable responses = client
     *             .listChannelGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelGroupsIterable responses = client.listChannelGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannelGroups(software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListChannelGroupsRequest#builder()}
     * </p>
     *
     * @param listChannelGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListChannelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelGroupsIterable listChannelGroupsPaginator(
            Consumer<ListChannelGroupsRequest.Builder> listChannelGroupsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            MediaPackageV2Exception {
        return listChannelGroupsPaginator(ListChannelGroupsRequest.builder().applyMutation(listChannelGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves all channels in a specific channel group that are configured in AWS Elemental MediaPackage.
     * </p>
     *
     * @param listChannelsRequest
     * @return Result of the ListChannels operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all channels in a specific channel group that are configured in AWS Elemental MediaPackage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest.Builder} to create a
     *        request.
     * @return Result of the ListChannels operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChannelsResponse listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannels(software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelsIterable responses = client
     *             .listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(ListChannelsRequest listChannelsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        return new ListChannelsIterable(this, listChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannels(software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelsIterable responses = client
     *             .listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of harvest jobs that match the specified criteria.
     * </p>
     *
     * @param listHarvestJobsRequest
     *        The request object for listing harvest jobs.
     * @return Result of the ListHarvestJobs operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListHarvestJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListHarvestJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHarvestJobsResponse listHarvestJobs(ListHarvestJobsRequest listHarvestJobsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of harvest jobs that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHarvestJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListHarvestJobsRequest#builder()}
     * </p>
     *
     * @param listHarvestJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsRequest.Builder} to create a
     *        request. The request object for listing harvest jobs.
     * @return Result of the ListHarvestJobs operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListHarvestJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListHarvestJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHarvestJobsResponse listHarvestJobs(Consumer<ListHarvestJobsRequest.Builder> listHarvestJobsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return listHarvestJobs(ListHarvestJobsRequest.builder().applyMutation(listHarvestJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHarvestJobs(software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListHarvestJobsIterable responses = client.listHarvestJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediapackagev2.paginators.ListHarvestJobsIterable responses = client
     *             .listHarvestJobsPaginator(request);
     *     for (software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListHarvestJobsIterable responses = client.listHarvestJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHarvestJobs(software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHarvestJobsRequest
     *        The request object for listing harvest jobs.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListHarvestJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListHarvestJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHarvestJobsIterable listHarvestJobsPaginator(ListHarvestJobsRequest listHarvestJobsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return new ListHarvestJobsIterable(this, listHarvestJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHarvestJobs(software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListHarvestJobsIterable responses = client.listHarvestJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediapackagev2.paginators.ListHarvestJobsIterable responses = client
     *             .listHarvestJobsPaginator(request);
     *     for (software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListHarvestJobsIterable responses = client.listHarvestJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHarvestJobs(software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHarvestJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListHarvestJobsRequest#builder()}
     * </p>
     *
     * @param listHarvestJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsRequest.Builder} to create a
     *        request. The request object for listing harvest jobs.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListHarvestJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListHarvestJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHarvestJobsIterable listHarvestJobsPaginator(Consumer<ListHarvestJobsRequest.Builder> listHarvestJobsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return listHarvestJobsPaginator(ListHarvestJobsRequest.builder().applyMutation(listHarvestJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves all origin endpoints in a specific channel that are configured in AWS Elemental MediaPackage.
     * </p>
     *
     * @param listOriginEndpointsRequest
     * @return Result of the ListOriginEndpoints operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListOriginEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListOriginEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOriginEndpointsResponse listOriginEndpoints(ListOriginEndpointsRequest listOriginEndpointsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all origin endpoints in a specific channel that are configured in AWS Elemental MediaPackage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOriginEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListOriginEndpointsRequest#builder()}
     * </p>
     *
     * @param listOriginEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest.Builder} to create
     *        a request.
     * @return Result of the ListOriginEndpoints operation returned by the service.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListOriginEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListOriginEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOriginEndpointsResponse listOriginEndpoints(
            Consumer<ListOriginEndpointsRequest.Builder> listOriginEndpointsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        return listOriginEndpoints(ListOriginEndpointsRequest.builder().applyMutation(listOriginEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOriginEndpoints(software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListOriginEndpointsIterable responses = client.listOriginEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediapackagev2.paginators.ListOriginEndpointsIterable responses = client
     *             .listOriginEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListOriginEndpointsIterable responses = client.listOriginEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOriginEndpoints(software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOriginEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListOriginEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListOriginEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOriginEndpointsIterable listOriginEndpointsPaginator(ListOriginEndpointsRequest listOriginEndpointsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return new ListOriginEndpointsIterable(this, listOriginEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOriginEndpoints(software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListOriginEndpointsIterable responses = client.listOriginEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediapackagev2.paginators.ListOriginEndpointsIterable responses = client
     *             .listOriginEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListOriginEndpointsIterable responses = client.listOriginEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOriginEndpoints(software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOriginEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListOriginEndpointsRequest#builder()}
     * </p>
     *
     * @param listOriginEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListOriginEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListOriginEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOriginEndpointsIterable listOriginEndpointsPaginator(
            Consumer<ListOriginEndpointsRequest.Builder> listOriginEndpointsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        return listOriginEndpointsPaginator(ListOriginEndpointsRequest.builder().applyMutation(listOriginEndpointsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified channel. With policies, you can specify who has access to AWS resources
     * and what actions they can perform on those resources. You can attach only one policy with each request.
     * </p>
     *
     * @param putChannelPolicyRequest
     * @return Result of the PutChannelPolicy operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.PutChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/PutChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutChannelPolicyResponse putChannelPolicy(PutChannelPolicyRequest putChannelPolicyRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified channel. With policies, you can specify who has access to AWS resources
     * and what actions they can perform on those resources. You can attach only one policy with each request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutChannelPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutChannelPolicyRequest#builder()}
     * </p>
     *
     * @param putChannelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutChannelPolicy operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.PutChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/PutChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutChannelPolicyResponse putChannelPolicy(Consumer<PutChannelPolicyRequest.Builder> putChannelPolicyRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return putChannelPolicy(PutChannelPolicyRequest.builder().applyMutation(putChannelPolicyRequest).build());
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified origin endpoint. You can attach only one policy with each request.
     * </p>
     *
     * @param putOriginEndpointPolicyRequest
     * @return Result of the PutOriginEndpointPolicy operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.PutOriginEndpointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/PutOriginEndpointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutOriginEndpointPolicyResponse putOriginEndpointPolicy(PutOriginEndpointPolicyRequest putOriginEndpointPolicyRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified origin endpoint. You can attach only one policy with each request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutOriginEndpointPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutOriginEndpointPolicyRequest#builder()}
     * </p>
     *
     * @param putOriginEndpointPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.PutOriginEndpointPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the PutOriginEndpointPolicy operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.PutOriginEndpointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/PutOriginEndpointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutOriginEndpointPolicyResponse putOriginEndpointPolicy(
            Consumer<PutOriginEndpointPolicyRequest.Builder> putOriginEndpointPolicyRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return putOriginEndpointPolicy(PutOriginEndpointPolicyRequest.builder().applyMutation(putOriginEndpointPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Resetting the channel can help to clear errors from misconfigurations in the encoder. A reset refreshes the
     * ingest stream and removes previous content.
     * </p>
     * <p>
     * Be sure to stop the encoder before you reset the channel, and wait at least 30 seconds before you restart the
     * encoder.
     * </p>
     *
     * @param resetChannelStateRequest
     * @return Result of the ResetChannelState operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ResetChannelState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ResetChannelState"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetChannelStateResponse resetChannelState(ResetChannelStateRequest resetChannelStateRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resetting the channel can help to clear errors from misconfigurations in the encoder. A reset refreshes the
     * ingest stream and removes previous content.
     * </p>
     * <p>
     * Be sure to stop the encoder before you reset the channel, and wait at least 30 seconds before you restart the
     * encoder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetChannelStateRequest.Builder} avoiding the need
     * to create one manually via {@link ResetChannelStateRequest#builder()}
     * </p>
     *
     * @param resetChannelStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ResetChannelStateRequest.Builder} to create a
     *        request.
     * @return Result of the ResetChannelState operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ResetChannelState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ResetChannelState"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetChannelStateResponse resetChannelState(Consumer<ResetChannelStateRequest.Builder> resetChannelStateRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return resetChannelState(ResetChannelStateRequest.builder().applyMutation(resetChannelStateRequest).build());
    }

    /**
     * <p>
     * Resetting the origin endpoint can help to resolve unexpected behavior and other content packaging issues. It also
     * helps to preserve special events when you don't want the previous content to be available for viewing. A reset
     * clears out all previous content from the origin endpoint.
     * </p>
     * <p>
     * MediaPackage might return old content from this endpoint in the first 30 seconds after the endpoint reset. For
     * best results, when possible, wait 30 seconds from endpoint reset to send playback requests to this endpoint.
     * </p>
     *
     * @param resetOriginEndpointStateRequest
     * @return Result of the ResetOriginEndpointState operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ResetOriginEndpointState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ResetOriginEndpointState"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetOriginEndpointStateResponse resetOriginEndpointState(
            ResetOriginEndpointStateRequest resetOriginEndpointStateRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resetting the origin endpoint can help to resolve unexpected behavior and other content packaging issues. It also
     * helps to preserve special events when you don't want the previous content to be available for viewing. A reset
     * clears out all previous content from the origin endpoint.
     * </p>
     * <p>
     * MediaPackage might return old content from this endpoint in the first 30 seconds after the endpoint reset. For
     * best results, when possible, wait 30 seconds from endpoint reset to send playback requests to this endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetOriginEndpointStateRequest.Builder} avoiding
     * the need to create one manually via {@link ResetOriginEndpointStateRequest#builder()}
     * </p>
     *
     * @param resetOriginEndpointStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ResetOriginEndpointStateRequest.Builder} to
     *        create a request.
     * @return Result of the ResetOriginEndpointState operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.ResetOriginEndpointState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ResetOriginEndpointState"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetOriginEndpointStateResponse resetOriginEndpointState(
            Consumer<ResetOriginEndpointStateRequest.Builder> resetOriginEndpointStateRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return resetOriginEndpointState(ResetOriginEndpointStateRequest.builder().applyMutation(resetOriginEndpointStateRequest)
                .build());
    }

    /**
     * <p>
     * Assigns one of more tags (key-value pairs) to the specified MediaPackage resource.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only resources with certain tag values. You can use the
     * TagResource operation with a resource that already has tags. If you specify a new tag key for the resource, this
     * tag is appended to the list of tags associated with the resource. If you specify a tag key that is already
     * associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one of more tags (key-value pairs) to the specified MediaPackage resource.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only resources with certain tag values. You can use the
     * TagResource operation with a resource that already has tags. If you specify a new tag key for the resource, this
     * tag is appended to the list of tags associated with the resource. If you specify a tag key that is already
     * associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update the specified channel. You can edit if MediaPackage sends ingest or egress access logs to the CloudWatch
     * log group, if content will be encrypted, the description on a channel, and your channel's policy settings. You
     * can't edit the name of the channel or CloudFront distribution details.
     * </p>
     * <p>
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     * </p>
     *
     * @param updateChannelRequest
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateChannelResponse updateChannel(UpdateChannelRequest updateChannelRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the specified channel. You can edit if MediaPackage sends ingest or egress access logs to the CloudWatch
     * log group, if content will be encrypted, the description on a channel, and your channel's policy settings. You
     * can't edit the name of the channel or CloudFront distribution details.
     * </p>
     * <p>
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateChannelRequest#builder()}
     * </p>
     *
     * @param updateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateChannelResponse updateChannel(Consumer<UpdateChannelRequest.Builder> updateChannelRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return updateChannel(UpdateChannelRequest.builder().applyMutation(updateChannelRequest).build());
    }

    /**
     * <p>
     * Update the specified channel group. You can edit the description on a channel group for easier identification
     * later from the AWS Elemental MediaPackage console. You can't edit the name of the channel group.
     * </p>
     * <p>
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     * </p>
     *
     * @param updateChannelGroupRequest
     * @return Result of the UpdateChannelGroup operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.UpdateChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateChannelGroupResponse updateChannelGroup(UpdateChannelGroupRequest updateChannelGroupRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the specified channel group. You can edit the description on a channel group for easier identification
     * later from the AWS Elemental MediaPackage console. You can't edit the name of the channel group.
     * </p>
     * <p>
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateChannelGroupRequest#builder()}
     * </p>
     *
     * @param updateChannelGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateChannelGroup operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.UpdateChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateChannelGroupResponse updateChannelGroup(Consumer<UpdateChannelGroupRequest.Builder> updateChannelGroupRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return updateChannelGroup(UpdateChannelGroupRequest.builder().applyMutation(updateChannelGroupRequest).build());
    }

    /**
     * <p>
     * Update the specified origin endpoint. Edit the packaging preferences on an endpoint to optimize the viewing
     * experience. You can't edit the name of the endpoint.
     * </p>
     * <p>
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     * </p>
     *
     * @param updateOriginEndpointRequest
     * @return Result of the UpdateOriginEndpoint operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.UpdateOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOriginEndpointResponse updateOriginEndpoint(UpdateOriginEndpointRequest updateOriginEndpointRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            MediaPackageV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the specified origin endpoint. Edit the packaging preferences on an endpoint to optimize the viewing
     * experience. You can't edit the name of the endpoint.
     * </p>
     * <p>
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOriginEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateOriginEndpointRequest#builder()}
     * </p>
     *
     * @param updateOriginEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateOriginEndpoint operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws AccessDeniedException
     *         Access is denied because either you don't have permissions to perform the requested operation or
     *         MediaPackage is getting throttling errors with CDN authorization. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see Access Management in the IAM User Guide. Or, if you're using CDN authorization, you
     *         will receive this exception if MediaPackage receives a throttling error from Secrets Manager.
     * @throws InternalServerException
     *         Indicates that an error from the service occurred while trying to process a request.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaPackageV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaPackageV2Client.UpdateOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOriginEndpointResponse updateOriginEndpoint(
            Consumer<UpdateOriginEndpointRequest.Builder> updateOriginEndpointRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, MediaPackageV2Exception {
        return updateOriginEndpoint(UpdateOriginEndpointRequest.builder().applyMutation(updateOriginEndpointRequest).build());
    }

    /**
     * Create an instance of {@link MediaPackageV2Waiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link MediaPackageV2Waiter}
     */
    default MediaPackageV2Waiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MediaPackageV2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaPackageV2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaPackageV2Client}.
     */
    static MediaPackageV2ClientBuilder builder() {
        return new DefaultMediaPackageV2ClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MediaPackageV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
