/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelRequest extends MediaPackageV2Request implements
        ToCopyableBuilder<CreateChannelRequest.Builder, CreateChannelRequest> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(CreateChannelRequest::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelGroupName").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(CreateChannelRequest::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateChannelRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-client-token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputType").getter(getter(CreateChannelRequest::inputTypeAsString)).setter(setter(Builder::inputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateChannelRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<InputSwitchConfiguration> INPUT_SWITCH_CONFIGURATION_FIELD = SdkField
            .<InputSwitchConfiguration> builder(MarshallingType.SDK_POJO).memberName("InputSwitchConfiguration")
            .getter(getter(CreateChannelRequest::inputSwitchConfiguration)).setter(setter(Builder::inputSwitchConfiguration))
            .constructor(InputSwitchConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputSwitchConfiguration").build())
            .build();

    private static final SdkField<OutputHeaderConfiguration> OUTPUT_HEADER_CONFIGURATION_FIELD = SdkField
            .<OutputHeaderConfiguration> builder(MarshallingType.SDK_POJO).memberName("OutputHeaderConfiguration")
            .getter(getter(CreateChannelRequest::outputHeaderConfiguration)).setter(setter(Builder::outputHeaderConfiguration))
            .constructor(OutputHeaderConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputHeaderConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateChannelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD,
            CHANNEL_NAME_FIELD, CLIENT_TOKEN_FIELD, INPUT_TYPE_FIELD, DESCRIPTION_FIELD, INPUT_SWITCH_CONFIGURATION_FIELD,
            OUTPUT_HEADER_CONFIGURATION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelGroupName;

    private final String channelName;

    private final String clientToken;

    private final String inputType;

    private final String description;

    private final InputSwitchConfiguration inputSwitchConfiguration;

    private final OutputHeaderConfiguration outputHeaderConfiguration;

    private final Map<String, String> tags;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.clientToken = builder.clientToken;
        this.inputType = builder.inputType;
        this.description = builder.description;
        this.inputSwitchConfiguration = builder.inputSwitchConfiguration;
        this.outputHeaderConfiguration = builder.outputHeaderConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be
     * unique for your account in the AWS Region.
     * </p>
     * 
     * @return The name that describes the channel group. The name is the primary identifier for the channel group, and
     *         must be unique for your account in the AWS Region.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for
     * your account in the AWS Region and channel group. You can't change the name after you create the channel.
     * </p>
     * 
     * @return The name that describes the channel. The name is the primary identifier for the channel, and must be
     *         unique for your account in the AWS Region and channel group. You can't change the name after you create
     *         the channel.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest
     * or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
     * </p>
     * <p>
     * The allowed values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
     * manifests).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputType} will
     * return {@link InputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTypeAsString}.
     * </p>
     * 
     * @return The input type will be an immutable field which will be used to define whether the channel will allow
     *         CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p>
     *         <p>
     *         The allowed values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
     *         manifests).
     *         </p>
     *         </li>
     * @see InputType
     */
    public final InputType inputType() {
        return InputType.fromValue(inputType);
    }

    /**
     * <p>
     * The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest
     * or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
     * </p>
     * <p>
     * The allowed values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
     * manifests).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputType} will
     * return {@link InputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTypeAsString}.
     * </p>
     * 
     * @return The input type will be an immutable field which will be used to define whether the channel will allow
     *         CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p>
     *         <p>
     *         The allowed values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
     *         manifests).
     *         </p>
     *         </li>
     * @see InputType
     */
    public final String inputTypeAsString() {
        return inputType;
    }

    /**
     * <p>
     * Enter any descriptive text that helps you to identify the channel.
     * </p>
     * 
     * @return Enter any descriptive text that helps you to identify the channel.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration for input switching based on the media quality confidence score (MQCS) as provided from AWS
     * Elemental MediaLive. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.
     * </p>
     * 
     * @return The configuration for input switching based on the media quality confidence score (MQCS) as provided from
     *         AWS Elemental MediaLive. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.
     */
    public final InputSwitchConfiguration inputSwitchConfiguration() {
        return inputSwitchConfiguration;
    }

    /**
     * <p>
     * The settings for what common media server data (CMSD) headers AWS Elemental MediaPackage includes in responses to
     * the CDN. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.
     * </p>
     * 
     * @return The settings for what common media server data (CMSD) headers AWS Elemental MediaPackage includes in
     *         responses to the CDN. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.
     */
    public final OutputHeaderConfiguration outputHeaderConfiguration() {
        return outputHeaderConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A comma-separated list of tag key:value pairs that you define. For example:
     * </p>
     * <p>
     * <code>"Key1": "Value1",</code>
     * </p>
     * <p>
     * <code>"Key2": "Value2"</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A comma-separated list of tag key:value pairs that you define. For example:</p>
     *         <p>
     *         <code>"Key1": "Value1",</code>
     *         </p>
     *         <p>
     *         <code>"Key2": "Value2"</code>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(inputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(inputSwitchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(outputHeaderConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest) obj;
        return Objects.equals(channelGroupName(), other.channelGroupName()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(inputTypeAsString(), other.inputTypeAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(inputSwitchConfiguration(), other.inputSwitchConfiguration())
                && Objects.equals(outputHeaderConfiguration(), other.outputHeaderConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelRequest").add("ChannelGroupName", channelGroupName())
                .add("ChannelName", channelName()).add("ClientToken", clientToken()).add("InputType", inputTypeAsString())
                .add("Description", description()).add("InputSwitchConfiguration", inputSwitchConfiguration())
                .add("OutputHeaderConfiguration", outputHeaderConfiguration()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "InputType":
            return Optional.ofNullable(clazz.cast(inputTypeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "InputSwitchConfiguration":
            return Optional.ofNullable(clazz.cast(inputSwitchConfiguration()));
        case "OutputHeaderConfiguration":
            return Optional.ofNullable(clazz.cast(outputHeaderConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("x-amzn-client-token", CLIENT_TOKEN_FIELD);
        map.put("InputType", INPUT_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("InputSwitchConfiguration", INPUT_SWITCH_CONFIGURATION_FIELD);
        map.put("OutputHeaderConfiguration", OUTPUT_HEADER_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaPackageV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelRequest> {
        /**
         * <p>
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must
         * be unique for your account in the AWS Region.
         * </p>
         * 
         * @param channelGroupName
         *        The name that describes the channel group. The name is the primary identifier for the channel group,
         *        and must be unique for your account in the AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique
         * for your account in the AWS Region and channel group. You can't change the name after you create the channel.
         * </p>
         * 
         * @param channelName
         *        The name that describes the channel. The name is the primary identifier for the channel, and must be
         *        unique for your account in the AWS Region and channel group. You can't change the name after you
         *        create the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The input type will be an immutable field which will be used to define whether the channel will allow CMAF
         * ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
         * </p>
         * <p>
         * The allowed values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
         * manifests).
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputType
         *        The input type will be an immutable field which will be used to define whether the channel will allow
         *        CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p>
         *        <p>
         *        The allowed values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional
         *        DASH manifests).
         *        </p>
         *        </li>
         * @see InputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputType
         */
        Builder inputType(String inputType);

        /**
         * <p>
         * The input type will be an immutable field which will be used to define whether the channel will allow CMAF
         * ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
         * </p>
         * <p>
         * The allowed values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
         * manifests).
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputType
         *        The input type will be an immutable field which will be used to define whether the channel will allow
         *        CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p>
         *        <p>
         *        The allowed values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional
         *        DASH manifests).
         *        </p>
         *        </li>
         * @see InputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputType
         */
        Builder inputType(InputType inputType);

        /**
         * <p>
         * Enter any descriptive text that helps you to identify the channel.
         * </p>
         * 
         * @param description
         *        Enter any descriptive text that helps you to identify the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration for input switching based on the media quality confidence score (MQCS) as provided from AWS
         * Elemental MediaLive. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.
         * </p>
         * 
         * @param inputSwitchConfiguration
         *        The configuration for input switching based on the media quality confidence score (MQCS) as provided
         *        from AWS Elemental MediaLive. This setting is valid only when <code>InputType</code> is
         *        <code>CMAF</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSwitchConfiguration(InputSwitchConfiguration inputSwitchConfiguration);

        /**
         * <p>
         * The configuration for input switching based on the media quality confidence score (MQCS) as provided from AWS
         * Elemental MediaLive. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputSwitchConfiguration.Builder}
         * avoiding the need to create one manually via {@link InputSwitchConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputSwitchConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #inputSwitchConfiguration(InputSwitchConfiguration)}.
         * 
         * @param inputSwitchConfiguration
         *        a consumer that will call methods on {@link InputSwitchConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSwitchConfiguration(InputSwitchConfiguration)
         */
        default Builder inputSwitchConfiguration(Consumer<InputSwitchConfiguration.Builder> inputSwitchConfiguration) {
            return inputSwitchConfiguration(InputSwitchConfiguration.builder().applyMutation(inputSwitchConfiguration).build());
        }

        /**
         * <p>
         * The settings for what common media server data (CMSD) headers AWS Elemental MediaPackage includes in
         * responses to the CDN. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.
         * </p>
         * 
         * @param outputHeaderConfiguration
         *        The settings for what common media server data (CMSD) headers AWS Elemental MediaPackage includes in
         *        responses to the CDN. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputHeaderConfiguration(OutputHeaderConfiguration outputHeaderConfiguration);

        /**
         * <p>
         * The settings for what common media server data (CMSD) headers AWS Elemental MediaPackage includes in
         * responses to the CDN. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputHeaderConfiguration.Builder}
         * avoiding the need to create one manually via {@link OutputHeaderConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputHeaderConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #outputHeaderConfiguration(OutputHeaderConfiguration)}.
         * 
         * @param outputHeaderConfiguration
         *        a consumer that will call methods on {@link OutputHeaderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputHeaderConfiguration(OutputHeaderConfiguration)
         */
        default Builder outputHeaderConfiguration(Consumer<OutputHeaderConfiguration.Builder> outputHeaderConfiguration) {
            return outputHeaderConfiguration(OutputHeaderConfiguration.builder().applyMutation(outputHeaderConfiguration).build());
        }

        /**
         * <p>
         * A comma-separated list of tag key:value pairs that you define. For example:
         * </p>
         * <p>
         * <code>"Key1": "Value1",</code>
         * </p>
         * <p>
         * <code>"Key2": "Value2"</code>
         * </p>
         * 
         * @param tags
         *        A comma-separated list of tag key:value pairs that you define. For example:</p>
         *        <p>
         *        <code>"Key1": "Value1",</code>
         *        </p>
         *        <p>
         *        <code>"Key2": "Value2"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageV2Request.BuilderImpl implements Builder {
        private String channelGroupName;

        private String channelName;

        private String clientToken;

        private String inputType;

        private String description;

        private InputSwitchConfiguration inputSwitchConfiguration;

        private OutputHeaderConfiguration outputHeaderConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            channelGroupName(model.channelGroupName);
            channelName(model.channelName);
            clientToken(model.clientToken);
            inputType(model.inputType);
            description(model.description);
            inputSwitchConfiguration(model.inputSwitchConfiguration);
            outputHeaderConfiguration(model.outputHeaderConfiguration);
            tags(model.tags);
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getInputType() {
            return inputType;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public final Builder inputType(InputType inputType) {
            this.inputType(inputType == null ? null : inputType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final InputSwitchConfiguration.Builder getInputSwitchConfiguration() {
            return inputSwitchConfiguration != null ? inputSwitchConfiguration.toBuilder() : null;
        }

        public final void setInputSwitchConfiguration(InputSwitchConfiguration.BuilderImpl inputSwitchConfiguration) {
            this.inputSwitchConfiguration = inputSwitchConfiguration != null ? inputSwitchConfiguration.build() : null;
        }

        @Override
        public final Builder inputSwitchConfiguration(InputSwitchConfiguration inputSwitchConfiguration) {
            this.inputSwitchConfiguration = inputSwitchConfiguration;
            return this;
        }

        public final OutputHeaderConfiguration.Builder getOutputHeaderConfiguration() {
            return outputHeaderConfiguration != null ? outputHeaderConfiguration.toBuilder() : null;
        }

        public final void setOutputHeaderConfiguration(OutputHeaderConfiguration.BuilderImpl outputHeaderConfiguration) {
            this.outputHeaderConfiguration = outputHeaderConfiguration != null ? outputHeaderConfiguration.build() : null;
        }

        @Override
        public final Builder outputHeaderConfiguration(OutputHeaderConfiguration outputHeaderConfiguration) {
            this.outputHeaderConfiguration = outputHeaderConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
