/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class CreateHlsManifestsCopier {
    static List<CreateHlsManifestConfiguration> copy(Collection<? extends CreateHlsManifestConfiguration> createHlsManifestsParam) {
        List<CreateHlsManifestConfiguration> list;
        if (createHlsManifestsParam == null || createHlsManifestsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CreateHlsManifestConfiguration> modifiableList = new ArrayList<>(createHlsManifestsParam.size());
            createHlsManifestsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CreateHlsManifestConfiguration> copyFromBuilder(
            Collection<? extends CreateHlsManifestConfiguration.Builder> createHlsManifestsParam) {
        List<CreateHlsManifestConfiguration> list;
        if (createHlsManifestsParam == null || createHlsManifestsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CreateHlsManifestConfiguration> modifiableList = new ArrayList<>(createHlsManifestsParam.size());
            createHlsManifestsParam.forEach(entry -> {
                CreateHlsManifestConfiguration member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CreateHlsManifestConfiguration.Builder> copyToBuilder(
            Collection<? extends CreateHlsManifestConfiguration> createHlsManifestsParam) {
        List<CreateHlsManifestConfiguration.Builder> list;
        if (createHlsManifestsParam == null || createHlsManifestsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CreateHlsManifestConfiguration.Builder> modifiableList = new ArrayList<>(createHlsManifestsParam.size());
            createHlsManifestsParam.forEach(entry -> {
                CreateHlsManifestConfiguration.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
