/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The base URLs to use for retrieving segments. You can specify multiple locations and indicate the priority and weight
 * for when each should be used, for use in mutli-CDN workflows.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashBaseUrl implements SdkPojo, Serializable, ToCopyableBuilder<DashBaseUrl.Builder, DashBaseUrl> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(DashBaseUrl::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> SERVICE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceLocation").getter(getter(DashBaseUrl::serviceLocation)).setter(setter(Builder::serviceLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLocation").build()).build();

    private static final SdkField<Integer> DVB_PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DvbPriority").getter(getter(DashBaseUrl::dvbPriority)).setter(setter(Builder::dvbPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DvbPriority").build()).build();

    private static final SdkField<Integer> DVB_WEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DvbWeight").getter(getter(DashBaseUrl::dvbWeight)).setter(setter(Builder::dvbWeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DvbWeight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD,
            SERVICE_LOCATION_FIELD, DVB_PRIORITY_FIELD, DVB_WEIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String url;

    private final String serviceLocation;

    private final Integer dvbPriority;

    private final Integer dvbWeight;

    private DashBaseUrl(BuilderImpl builder) {
        this.url = builder.url;
        this.serviceLocation = builder.serviceLocation;
        this.dvbPriority = builder.dvbPriority;
        this.dvbWeight = builder.dvbWeight;
    }

    /**
     * <p>
     * A source location for segments.
     * </p>
     * 
     * @return A source location for segments.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The name of the source location.
     * </p>
     * 
     * @return The name of the source location.
     */
    public final String serviceLocation() {
        return serviceLocation;
    }

    /**
     * <p>
     * For use with DVB-DASH profiles only. The priority of this location for servings segments. The lower the number,
     * the higher the priority.
     * </p>
     * 
     * @return For use with DVB-DASH profiles only. The priority of this location for servings segments. The lower the
     *         number, the higher the priority.
     */
    public final Integer dvbPriority() {
        return dvbPriority;
    }

    /**
     * <p>
     * For use with DVB-DASH profiles only. The weighting for source locations that have the same priority.
     * </p>
     * 
     * @return For use with DVB-DASH profiles only. The weighting for source locations that have the same priority.
     */
    public final Integer dvbWeight() {
        return dvbWeight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(serviceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(dvbPriority());
        hashCode = 31 * hashCode + Objects.hashCode(dvbWeight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashBaseUrl)) {
            return false;
        }
        DashBaseUrl other = (DashBaseUrl) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(serviceLocation(), other.serviceLocation())
                && Objects.equals(dvbPriority(), other.dvbPriority()) && Objects.equals(dvbWeight(), other.dvbWeight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashBaseUrl").add("Url", url()).add("ServiceLocation", serviceLocation())
                .add("DvbPriority", dvbPriority()).add("DvbWeight", dvbWeight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "ServiceLocation":
            return Optional.ofNullable(clazz.cast(serviceLocation()));
        case "DvbPriority":
            return Optional.ofNullable(clazz.cast(dvbPriority()));
        case "DvbWeight":
            return Optional.ofNullable(clazz.cast(dvbWeight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Url", URL_FIELD);
        map.put("ServiceLocation", SERVICE_LOCATION_FIELD);
        map.put("DvbPriority", DVB_PRIORITY_FIELD);
        map.put("DvbWeight", DVB_WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashBaseUrl, T> g) {
        return obj -> g.apply((DashBaseUrl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashBaseUrl> {
        /**
         * <p>
         * A source location for segments.
         * </p>
         * 
         * @param url
         *        A source location for segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The name of the source location.
         * </p>
         * 
         * @param serviceLocation
         *        The name of the source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceLocation(String serviceLocation);

        /**
         * <p>
         * For use with DVB-DASH profiles only. The priority of this location for servings segments. The lower the
         * number, the higher the priority.
         * </p>
         * 
         * @param dvbPriority
         *        For use with DVB-DASH profiles only. The priority of this location for servings segments. The lower
         *        the number, the higher the priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbPriority(Integer dvbPriority);

        /**
         * <p>
         * For use with DVB-DASH profiles only. The weighting for source locations that have the same priority.
         * </p>
         * 
         * @param dvbWeight
         *        For use with DVB-DASH profiles only. The weighting for source locations that have the same priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbWeight(Integer dvbWeight);
    }

    static final class BuilderImpl implements Builder {
        private String url;

        private String serviceLocation;

        private Integer dvbPriority;

        private Integer dvbWeight;

        private BuilderImpl() {
        }

        private BuilderImpl(DashBaseUrl model) {
            url(model.url);
            serviceLocation(model.serviceLocation);
            dvbPriority(model.dvbPriority);
            dvbWeight(model.dvbWeight);
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getServiceLocation() {
            return serviceLocation;
        }

        public final void setServiceLocation(String serviceLocation) {
            this.serviceLocation = serviceLocation;
        }

        @Override
        public final Builder serviceLocation(String serviceLocation) {
            this.serviceLocation = serviceLocation;
            return this;
        }

        public final Integer getDvbPriority() {
            return dvbPriority;
        }

        public final void setDvbPriority(Integer dvbPriority) {
            this.dvbPriority = dvbPriority;
        }

        @Override
        public final Builder dvbPriority(Integer dvbPriority) {
            this.dvbPriority = dvbPriority;
            return this;
        }

        public final Integer getDvbWeight() {
            return dvbWeight;
        }

        public final void setDvbWeight(Integer dvbWeight) {
            this.dvbWeight = dvbWeight;
        }

        @Override
        public final Builder dvbWeight(Integer dvbWeight) {
            this.dvbWeight = dvbWeight;
            return this;
        }

        @Override
        public DashBaseUrl build() {
            return new DashBaseUrl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
