/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For endpoints that use the DVB-DASH profile only. The font download and error reporting information that you want
 * MediaPackage to pass through to the manifest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashDvbSettings implements SdkPojo, Serializable, ToCopyableBuilder<DashDvbSettings.Builder, DashDvbSettings> {
    private static final SdkField<DashDvbFontDownload> FONT_DOWNLOAD_FIELD = SdkField
            .<DashDvbFontDownload> builder(MarshallingType.SDK_POJO).memberName("FontDownload")
            .getter(getter(DashDvbSettings::fontDownload)).setter(setter(Builder::fontDownload))
            .constructor(DashDvbFontDownload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontDownload").build()).build();

    private static final SdkField<List<DashDvbMetricsReporting>> ERROR_METRICS_FIELD = SdkField
            .<List<DashDvbMetricsReporting>> builder(MarshallingType.LIST)
            .memberName("ErrorMetrics")
            .getter(getter(DashDvbSettings::errorMetrics))
            .setter(setter(Builder::errorMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DashDvbMetricsReporting> builder(MarshallingType.SDK_POJO)
                                            .constructor(DashDvbMetricsReporting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_DOWNLOAD_FIELD,
            ERROR_METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DashDvbFontDownload fontDownload;

    private final List<DashDvbMetricsReporting> errorMetrics;

    private DashDvbSettings(BuilderImpl builder) {
        this.fontDownload = builder.fontDownload;
        this.errorMetrics = builder.errorMetrics;
    }

    /**
     * <p>
     * Subtitle font settings.
     * </p>
     * 
     * @return Subtitle font settings.
     */
    public final DashDvbFontDownload fontDownload() {
        return fontDownload;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasErrorMetrics() {
        return errorMetrics != null && !(errorMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Playback device error reporting settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorMetrics} method.
     * </p>
     * 
     * @return Playback device error reporting settings.
     */
    public final List<DashDvbMetricsReporting> errorMetrics() {
        return errorMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fontDownload());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorMetrics() ? errorMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashDvbSettings)) {
            return false;
        }
        DashDvbSettings other = (DashDvbSettings) obj;
        return Objects.equals(fontDownload(), other.fontDownload()) && hasErrorMetrics() == other.hasErrorMetrics()
                && Objects.equals(errorMetrics(), other.errorMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashDvbSettings").add("FontDownload", fontDownload())
                .add("ErrorMetrics", hasErrorMetrics() ? errorMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FontDownload":
            return Optional.ofNullable(clazz.cast(fontDownload()));
        case "ErrorMetrics":
            return Optional.ofNullable(clazz.cast(errorMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FontDownload", FONT_DOWNLOAD_FIELD);
        map.put("ErrorMetrics", ERROR_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashDvbSettings, T> g) {
        return obj -> g.apply((DashDvbSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashDvbSettings> {
        /**
         * <p>
         * Subtitle font settings.
         * </p>
         * 
         * @param fontDownload
         *        Subtitle font settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontDownload(DashDvbFontDownload fontDownload);

        /**
         * <p>
         * Subtitle font settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashDvbFontDownload.Builder} avoiding the
         * need to create one manually via {@link DashDvbFontDownload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashDvbFontDownload.Builder#build()} is called immediately and
         * its result is passed to {@link #fontDownload(DashDvbFontDownload)}.
         * 
         * @param fontDownload
         *        a consumer that will call methods on {@link DashDvbFontDownload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fontDownload(DashDvbFontDownload)
         */
        default Builder fontDownload(Consumer<DashDvbFontDownload.Builder> fontDownload) {
            return fontDownload(DashDvbFontDownload.builder().applyMutation(fontDownload).build());
        }

        /**
         * <p>
         * Playback device error reporting settings.
         * </p>
         * 
         * @param errorMetrics
         *        Playback device error reporting settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMetrics(Collection<DashDvbMetricsReporting> errorMetrics);

        /**
         * <p>
         * Playback device error reporting settings.
         * </p>
         * 
         * @param errorMetrics
         *        Playback device error reporting settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMetrics(DashDvbMetricsReporting... errorMetrics);

        /**
         * <p>
         * Playback device error reporting settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.DashDvbMetricsReporting.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.DashDvbMetricsReporting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.DashDvbMetricsReporting.Builder#build()} is
         * called immediately and its result is passed to {@link #errorMetrics(List<DashDvbMetricsReporting>)}.
         * 
         * @param errorMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.DashDvbMetricsReporting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorMetrics(java.util.Collection<DashDvbMetricsReporting>)
         */
        Builder errorMetrics(Consumer<DashDvbMetricsReporting.Builder>... errorMetrics);
    }

    static final class BuilderImpl implements Builder {
        private DashDvbFontDownload fontDownload;

        private List<DashDvbMetricsReporting> errorMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DashDvbSettings model) {
            fontDownload(model.fontDownload);
            errorMetrics(model.errorMetrics);
        }

        public final DashDvbFontDownload.Builder getFontDownload() {
            return fontDownload != null ? fontDownload.toBuilder() : null;
        }

        public final void setFontDownload(DashDvbFontDownload.BuilderImpl fontDownload) {
            this.fontDownload = fontDownload != null ? fontDownload.build() : null;
        }

        @Override
        public final Builder fontDownload(DashDvbFontDownload fontDownload) {
            this.fontDownload = fontDownload;
            return this;
        }

        public final List<DashDvbMetricsReporting.Builder> getErrorMetrics() {
            List<DashDvbMetricsReporting.Builder> result = DashDvbErrorMetricsCopier.copyToBuilder(this.errorMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorMetrics(Collection<DashDvbMetricsReporting.BuilderImpl> errorMetrics) {
            this.errorMetrics = DashDvbErrorMetricsCopier.copyFromBuilder(errorMetrics);
        }

        @Override
        public final Builder errorMetrics(Collection<DashDvbMetricsReporting> errorMetrics) {
            this.errorMetrics = DashDvbErrorMetricsCopier.copy(errorMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorMetrics(DashDvbMetricsReporting... errorMetrics) {
            errorMetrics(Arrays.asList(errorMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorMetrics(Consumer<DashDvbMetricsReporting.Builder>... errorMetrics) {
            errorMetrics(Stream.of(errorMetrics).map(c -> DashDvbMetricsReporting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DashDvbSettings build() {
            return new DashDvbSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
