/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for DASH subtitles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashSubtitleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DashSubtitleConfiguration.Builder, DashSubtitleConfiguration> {
    private static final SdkField<DashTtmlConfiguration> TTML_CONFIGURATION_FIELD = SdkField
            .<DashTtmlConfiguration> builder(MarshallingType.SDK_POJO).memberName("TtmlConfiguration")
            .getter(getter(DashSubtitleConfiguration::ttmlConfiguration)).setter(setter(Builder::ttmlConfiguration))
            .constructor(DashTtmlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TtmlConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TTML_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DashTtmlConfiguration ttmlConfiguration;

    private DashSubtitleConfiguration(BuilderImpl builder) {
        this.ttmlConfiguration = builder.ttmlConfiguration;
    }

    /**
     * <p>
     * Settings for TTML subtitles.
     * </p>
     * 
     * @return Settings for TTML subtitles.
     */
    public final DashTtmlConfiguration ttmlConfiguration() {
        return ttmlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ttmlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashSubtitleConfiguration)) {
            return false;
        }
        DashSubtitleConfiguration other = (DashSubtitleConfiguration) obj;
        return Objects.equals(ttmlConfiguration(), other.ttmlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashSubtitleConfiguration").add("TtmlConfiguration", ttmlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TtmlConfiguration":
            return Optional.ofNullable(clazz.cast(ttmlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TtmlConfiguration", TTML_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashSubtitleConfiguration, T> g) {
        return obj -> g.apply((DashSubtitleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashSubtitleConfiguration> {
        /**
         * <p>
         * Settings for TTML subtitles.
         * </p>
         * 
         * @param ttmlConfiguration
         *        Settings for TTML subtitles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttmlConfiguration(DashTtmlConfiguration ttmlConfiguration);

        /**
         * <p>
         * Settings for TTML subtitles.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashTtmlConfiguration.Builder} avoiding
         * the need to create one manually via {@link DashTtmlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashTtmlConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #ttmlConfiguration(DashTtmlConfiguration)}.
         * 
         * @param ttmlConfiguration
         *        a consumer that will call methods on {@link DashTtmlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ttmlConfiguration(DashTtmlConfiguration)
         */
        default Builder ttmlConfiguration(Consumer<DashTtmlConfiguration.Builder> ttmlConfiguration) {
            return ttmlConfiguration(DashTtmlConfiguration.builder().applyMutation(ttmlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DashTtmlConfiguration ttmlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DashSubtitleConfiguration model) {
            ttmlConfiguration(model.ttmlConfiguration);
        }

        public final DashTtmlConfiguration.Builder getTtmlConfiguration() {
            return ttmlConfiguration != null ? ttmlConfiguration.toBuilder() : null;
        }

        public final void setTtmlConfiguration(DashTtmlConfiguration.BuilderImpl ttmlConfiguration) {
            this.ttmlConfiguration = ttmlConfiguration != null ? ttmlConfiguration.build() : null;
        }

        @Override
        public final Builder ttmlConfiguration(DashTtmlConfiguration ttmlConfiguration) {
            this.ttmlConfiguration = ttmlConfiguration;
            return this;
        }

        @Override
        public DashSubtitleConfiguration build() {
            return new DashSubtitleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
