/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for TTML subtitles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashTtmlConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DashTtmlConfiguration.Builder, DashTtmlConfiguration> {
    private static final SdkField<String> TTML_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TtmlProfile").getter(getter(DashTtmlConfiguration::ttmlProfileAsString))
            .setter(setter(Builder::ttmlProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TtmlProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TTML_PROFILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ttmlProfile;

    private DashTtmlConfiguration(BuilderImpl builder) {
        this.ttmlProfile = builder.ttmlProfile;
    }

    /**
     * <p>
     * The profile that MediaPackage uses when signaling subtitles in the manifest. <code>IMSC</code> is the default
     * profile. <code>EBU-TT-D</code> produces subtitles that are compliant with the EBU-TT-D TTML profile. MediaPackage
     * passes through subtitle styles to the manifest. For more information about EBU-TT-D subtitles, see <a
     * href="https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution Format</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ttmlProfile} will
     * return {@link DashTtmlProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ttmlProfileAsString}.
     * </p>
     * 
     * @return The profile that MediaPackage uses when signaling subtitles in the manifest. <code>IMSC</code> is the
     *         default profile. <code>EBU-TT-D</code> produces subtitles that are compliant with the EBU-TT-D TTML
     *         profile. MediaPackage passes through subtitle styles to the manifest. For more information about EBU-TT-D
     *         subtitles, see <a href="https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution
     *         Format</a>.
     * @see DashTtmlProfile
     */
    public final DashTtmlProfile ttmlProfile() {
        return DashTtmlProfile.fromValue(ttmlProfile);
    }

    /**
     * <p>
     * The profile that MediaPackage uses when signaling subtitles in the manifest. <code>IMSC</code> is the default
     * profile. <code>EBU-TT-D</code> produces subtitles that are compliant with the EBU-TT-D TTML profile. MediaPackage
     * passes through subtitle styles to the manifest. For more information about EBU-TT-D subtitles, see <a
     * href="https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution Format</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ttmlProfile} will
     * return {@link DashTtmlProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ttmlProfileAsString}.
     * </p>
     * 
     * @return The profile that MediaPackage uses when signaling subtitles in the manifest. <code>IMSC</code> is the
     *         default profile. <code>EBU-TT-D</code> produces subtitles that are compliant with the EBU-TT-D TTML
     *         profile. MediaPackage passes through subtitle styles to the manifest. For more information about EBU-TT-D
     *         subtitles, see <a href="https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution
     *         Format</a>.
     * @see DashTtmlProfile
     */
    public final String ttmlProfileAsString() {
        return ttmlProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ttmlProfileAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashTtmlConfiguration)) {
            return false;
        }
        DashTtmlConfiguration other = (DashTtmlConfiguration) obj;
        return Objects.equals(ttmlProfileAsString(), other.ttmlProfileAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashTtmlConfiguration").add("TtmlProfile", ttmlProfileAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TtmlProfile":
            return Optional.ofNullable(clazz.cast(ttmlProfileAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TtmlProfile", TTML_PROFILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashTtmlConfiguration, T> g) {
        return obj -> g.apply((DashTtmlConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashTtmlConfiguration> {
        /**
         * <p>
         * The profile that MediaPackage uses when signaling subtitles in the manifest. <code>IMSC</code> is the default
         * profile. <code>EBU-TT-D</code> produces subtitles that are compliant with the EBU-TT-D TTML profile.
         * MediaPackage passes through subtitle styles to the manifest. For more information about EBU-TT-D subtitles,
         * see <a href="https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution Format</a>.
         * </p>
         * 
         * @param ttmlProfile
         *        The profile that MediaPackage uses when signaling subtitles in the manifest. <code>IMSC</code> is the
         *        default profile. <code>EBU-TT-D</code> produces subtitles that are compliant with the EBU-TT-D TTML
         *        profile. MediaPackage passes through subtitle styles to the manifest. For more information about
         *        EBU-TT-D subtitles, see <a href="https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling
         *        Distribution Format</a>.
         * @see DashTtmlProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashTtmlProfile
         */
        Builder ttmlProfile(String ttmlProfile);

        /**
         * <p>
         * The profile that MediaPackage uses when signaling subtitles in the manifest. <code>IMSC</code> is the default
         * profile. <code>EBU-TT-D</code> produces subtitles that are compliant with the EBU-TT-D TTML profile.
         * MediaPackage passes through subtitle styles to the manifest. For more information about EBU-TT-D subtitles,
         * see <a href="https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution Format</a>.
         * </p>
         * 
         * @param ttmlProfile
         *        The profile that MediaPackage uses when signaling subtitles in the manifest. <code>IMSC</code> is the
         *        default profile. <code>EBU-TT-D</code> produces subtitles that are compliant with the EBU-TT-D TTML
         *        profile. MediaPackage passes through subtitle styles to the manifest. For more information about
         *        EBU-TT-D subtitles, see <a href="https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling
         *        Distribution Format</a>.
         * @see DashTtmlProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashTtmlProfile
         */
        Builder ttmlProfile(DashTtmlProfile ttmlProfile);
    }

    static final class BuilderImpl implements Builder {
        private String ttmlProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(DashTtmlConfiguration model) {
            ttmlProfile(model.ttmlProfile);
        }

        public final String getTtmlProfile() {
            return ttmlProfile;
        }

        public final void setTtmlProfile(String ttmlProfile) {
            this.ttmlProfile = ttmlProfile;
        }

        @Override
        public final Builder ttmlProfile(String ttmlProfile) {
            this.ttmlProfile = ttmlProfile;
            return this;
        }

        @Override
        public final Builder ttmlProfile(DashTtmlProfile ttmlProfile) {
            this.ttmlProfile(ttmlProfile == null ? null : ttmlProfile.toString());
            return this;
        }

        @Override
        public DashTtmlConfiguration build() {
            return new DashTtmlConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
