/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a harvest job resource in MediaPackage v2, which is used to export content from an origin endpoint to an
 * S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HarvestJob implements SdkPojo, Serializable, ToCopyableBuilder<HarvestJob.Builder, HarvestJob> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(HarvestJob::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(HarvestJob::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginEndpointName").getter(getter(HarvestJob::originEndpointName))
            .setter(setter(Builder::originEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginEndpointName").build())
            .build();

    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .memberName("Destination").getter(getter(HarvestJob::destination)).setter(setter(Builder::destination))
            .constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> HARVEST_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HarvestJobName").getter(getter(HarvestJob::harvestJobName)).setter(setter(Builder::harvestJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HarvestJobName").build()).build();

    private static final SdkField<HarvestedManifests> HARVESTED_MANIFESTS_FIELD = SdkField
            .<HarvestedManifests> builder(MarshallingType.SDK_POJO).memberName("HarvestedManifests")
            .getter(getter(HarvestJob::harvestedManifests)).setter(setter(Builder::harvestedManifests))
            .constructor(HarvestedManifests::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HarvestedManifests").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(HarvestJob::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<HarvesterScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField
            .<HarvesterScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScheduleConfiguration")
            .getter(getter(HarvestJob::scheduleConfiguration)).setter(setter(Builder::scheduleConfiguration))
            .constructor(HarvesterScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(HarvestJob::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(HarvestJob::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt").getter(getter(HarvestJob::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(HarvestJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(HarvestJob::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(HarvestJob::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD,
            CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, DESTINATION_FIELD, HARVEST_JOB_NAME_FIELD, HARVESTED_MANIFESTS_FIELD,
            DESCRIPTION_FIELD, SCHEDULE_CONFIGURATION_FIELD, ARN_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, STATUS_FIELD,
            ERROR_MESSAGE_FIELD, E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String channelGroupName;

    private final String channelName;

    private final String originEndpointName;

    private final Destination destination;

    private final String harvestJobName;

    private final HarvestedManifests harvestedManifests;

    private final String description;

    private final HarvesterScheduleConfiguration scheduleConfiguration;

    private final String arn;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String status;

    private final String errorMessage;

    private final String eTag;

    private HarvestJob(BuilderImpl builder) {
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.destination = builder.destination;
        this.harvestJobName = builder.harvestJobName;
        this.harvestedManifests = builder.harvestedManifests;
        this.description = builder.description;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The name of the channel group containing the channel associated with this harvest job.
     * </p>
     * 
     * @return The name of the channel group containing the channel associated with this harvest job.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The name of the channel associated with this harvest job.
     * </p>
     * 
     * @return The name of the channel associated with this harvest job.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name of the origin endpoint associated with this harvest job.
     * </p>
     * 
     * @return The name of the origin endpoint associated with this harvest job.
     */
    public final String originEndpointName() {
        return originEndpointName;
    }

    /**
     * <p>
     * The S3 destination where the harvested content will be placed.
     * </p>
     * 
     * @return The S3 destination where the harvested content will be placed.
     */
    public final Destination destination() {
        return destination;
    }

    /**
     * <p>
     * The name of the harvest job.
     * </p>
     * 
     * @return The name of the harvest job.
     */
    public final String harvestJobName() {
        return harvestJobName;
    }

    /**
     * <p>
     * A list of manifests that are being or have been harvested.
     * </p>
     * 
     * @return A list of manifests that are being or have been harvested.
     */
    public final HarvestedManifests harvestedManifests() {
        return harvestedManifests;
    }

    /**
     * <p>
     * An optional description of the harvest job.
     * </p>
     * 
     * @return An optional description of the harvest job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration for when the harvest job is scheduled to run.
     * </p>
     * 
     * @return The configuration for when the harvest job is scheduled to run.
     */
    public final HarvesterScheduleConfiguration scheduleConfiguration() {
        return scheduleConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the harvest job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the harvest job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time when the harvest job was created.
     * </p>
     * 
     * @return The date and time when the harvest job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time when the harvest job was last modified.
     * </p>
     * 
     * @return The date and time when the harvest job was last modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The current status of the harvest job (e.g., QUEUED, IN_PROGRESS, CANCELLED, COMPLETED, FAILED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HarvestJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the harvest job (e.g., QUEUED, IN_PROGRESS, CANCELLED, COMPLETED, FAILED).
     * @see HarvestJobStatus
     */
    public final HarvestJobStatus status() {
        return HarvestJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the harvest job (e.g., QUEUED, IN_PROGRESS, CANCELLED, COMPLETED, FAILED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HarvestJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the harvest job (e.g., QUEUED, IN_PROGRESS, CANCELLED, COMPLETED, FAILED).
     * @see HarvestJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An error message if the harvest job encountered any issues.
     * </p>
     * 
     * @return An error message if the harvest job encountered any issues.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The current version of the harvest job. Used for concurrency control.
     * </p>
     * 
     * @return The current version of the harvest job. Used for concurrency control.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(harvestJobName());
        hashCode = 31 * hashCode + Objects.hashCode(harvestedManifests());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HarvestJob)) {
            return false;
        }
        HarvestJob other = (HarvestJob) obj;
        return Objects.equals(channelGroupName(), other.channelGroupName()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(originEndpointName(), other.originEndpointName())
                && Objects.equals(destination(), other.destination()) && Objects.equals(harvestJobName(), other.harvestJobName())
                && Objects.equals(harvestedManifests(), other.harvestedManifests())
                && Objects.equals(description(), other.description())
                && Objects.equals(scheduleConfiguration(), other.scheduleConfiguration()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(modifiedAt(), other.modifiedAt())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HarvestJob").add("ChannelGroupName", channelGroupName()).add("ChannelName", channelName())
                .add("OriginEndpointName", originEndpointName()).add("Destination", destination())
                .add("HarvestJobName", harvestJobName()).add("HarvestedManifests", harvestedManifests())
                .add("Description", description()).add("ScheduleConfiguration", scheduleConfiguration()).add("Arn", arn())
                .add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt()).add("Status", statusAsString())
                .add("ErrorMessage", errorMessage()).add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "OriginEndpointName":
            return Optional.ofNullable(clazz.cast(originEndpointName()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "HarvestJobName":
            return Optional.ofNullable(clazz.cast(harvestJobName()));
        case "HarvestedManifests":
            return Optional.ofNullable(clazz.cast(harvestedManifests()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ScheduleConfiguration":
            return Optional.ofNullable(clazz.cast(scheduleConfiguration()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("OriginEndpointName", ORIGIN_ENDPOINT_NAME_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("HarvestJobName", HARVEST_JOB_NAME_FIELD);
        map.put("HarvestedManifests", HARVESTED_MANIFESTS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ScheduleConfiguration", SCHEDULE_CONFIGURATION_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HarvestJob, T> g) {
        return obj -> g.apply((HarvestJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HarvestJob> {
        /**
         * <p>
         * The name of the channel group containing the channel associated with this harvest job.
         * </p>
         * 
         * @param channelGroupName
         *        The name of the channel group containing the channel associated with this harvest job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The name of the channel associated with this harvest job.
         * </p>
         * 
         * @param channelName
         *        The name of the channel associated with this harvest job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name of the origin endpoint associated with this harvest job.
         * </p>
         * 
         * @param originEndpointName
         *        The name of the origin endpoint associated with this harvest job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpointName(String originEndpointName);

        /**
         * <p>
         * The S3 destination where the harvested content will be placed.
         * </p>
         * 
         * @param destination
         *        The S3 destination where the harvested content will be placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * The S3 destination where the harvested content will be placed.
         * </p>
         * This is a convenience method that creates an instance of the {@link Destination.Builder} avoiding the need to
         * create one manually via {@link Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The name of the harvest job.
         * </p>
         * 
         * @param harvestJobName
         *        The name of the harvest job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder harvestJobName(String harvestJobName);

        /**
         * <p>
         * A list of manifests that are being or have been harvested.
         * </p>
         * 
         * @param harvestedManifests
         *        A list of manifests that are being or have been harvested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder harvestedManifests(HarvestedManifests harvestedManifests);

        /**
         * <p>
         * A list of manifests that are being or have been harvested.
         * </p>
         * This is a convenience method that creates an instance of the {@link HarvestedManifests.Builder} avoiding the
         * need to create one manually via {@link HarvestedManifests#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HarvestedManifests.Builder#build()} is called immediately and its
         * result is passed to {@link #harvestedManifests(HarvestedManifests)}.
         * 
         * @param harvestedManifests
         *        a consumer that will call methods on {@link HarvestedManifests.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #harvestedManifests(HarvestedManifests)
         */
        default Builder harvestedManifests(Consumer<HarvestedManifests.Builder> harvestedManifests) {
            return harvestedManifests(HarvestedManifests.builder().applyMutation(harvestedManifests).build());
        }

        /**
         * <p>
         * An optional description of the harvest job.
         * </p>
         * 
         * @param description
         *        An optional description of the harvest job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration for when the harvest job is scheduled to run.
         * </p>
         * 
         * @param scheduleConfiguration
         *        The configuration for when the harvest job is scheduled to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfiguration(HarvesterScheduleConfiguration scheduleConfiguration);

        /**
         * <p>
         * The configuration for when the harvest job is scheduled to run.
         * </p>
         * This is a convenience method that creates an instance of the {@link HarvesterScheduleConfiguration.Builder}
         * avoiding the need to create one manually via {@link HarvesterScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HarvesterScheduleConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #scheduleConfiguration(HarvesterScheduleConfiguration)}.
         * 
         * @param scheduleConfiguration
         *        a consumer that will call methods on {@link HarvesterScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfiguration(HarvesterScheduleConfiguration)
         */
        default Builder scheduleConfiguration(Consumer<HarvesterScheduleConfiguration.Builder> scheduleConfiguration) {
            return scheduleConfiguration(HarvesterScheduleConfiguration.builder().applyMutation(scheduleConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the harvest job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the harvest job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time when the harvest job was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the harvest job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time when the harvest job was last modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time when the harvest job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The current status of the harvest job (e.g., QUEUED, IN_PROGRESS, CANCELLED, COMPLETED, FAILED).
         * </p>
         * 
         * @param status
         *        The current status of the harvest job (e.g., QUEUED, IN_PROGRESS, CANCELLED, COMPLETED, FAILED).
         * @see HarvestJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HarvestJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the harvest job (e.g., QUEUED, IN_PROGRESS, CANCELLED, COMPLETED, FAILED).
         * </p>
         * 
         * @param status
         *        The current status of the harvest job (e.g., QUEUED, IN_PROGRESS, CANCELLED, COMPLETED, FAILED).
         * @see HarvestJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HarvestJobStatus
         */
        Builder status(HarvestJobStatus status);

        /**
         * <p>
         * An error message if the harvest job encountered any issues.
         * </p>
         * 
         * @param errorMessage
         *        An error message if the harvest job encountered any issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The current version of the harvest job. Used for concurrency control.
         * </p>
         * 
         * @param eTag
         *        The current version of the harvest job. Used for concurrency control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl implements Builder {
        private String channelGroupName;

        private String channelName;

        private String originEndpointName;

        private Destination destination;

        private String harvestJobName;

        private HarvestedManifests harvestedManifests;

        private String description;

        private HarvesterScheduleConfiguration scheduleConfiguration;

        private String arn;

        private Instant createdAt;

        private Instant modifiedAt;

        private String status;

        private String errorMessage;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(HarvestJob model) {
            channelGroupName(model.channelGroupName);
            channelName(model.channelName);
            originEndpointName(model.originEndpointName);
            destination(model.destination);
            harvestJobName(model.harvestJobName);
            harvestedManifests(model.harvestedManifests);
            description(model.description);
            scheduleConfiguration(model.scheduleConfiguration);
            arn(model.arn);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            status(model.status);
            errorMessage(model.errorMessage);
            eTag(model.eTag);
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final String getHarvestJobName() {
            return harvestJobName;
        }

        public final void setHarvestJobName(String harvestJobName) {
            this.harvestJobName = harvestJobName;
        }

        @Override
        public final Builder harvestJobName(String harvestJobName) {
            this.harvestJobName = harvestJobName;
            return this;
        }

        public final HarvestedManifests.Builder getHarvestedManifests() {
            return harvestedManifests != null ? harvestedManifests.toBuilder() : null;
        }

        public final void setHarvestedManifests(HarvestedManifests.BuilderImpl harvestedManifests) {
            this.harvestedManifests = harvestedManifests != null ? harvestedManifests.build() : null;
        }

        @Override
        public final Builder harvestedManifests(HarvestedManifests harvestedManifests) {
            this.harvestedManifests = harvestedManifests;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final HarvesterScheduleConfiguration.Builder getScheduleConfiguration() {
            return scheduleConfiguration != null ? scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(HarvesterScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(HarvesterScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HarvestJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public HarvestJob build() {
            return new HarvestJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
