/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for input switching based on the media quality confidence score (MQCS) as provided from AWS
 * Elemental MediaLive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputSwitchConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InputSwitchConfiguration.Builder, InputSwitchConfiguration> {
    private static final SdkField<Boolean> MQCS_INPUT_SWITCHING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MQCSInputSwitching").getter(getter(InputSwitchConfiguration::mqcsInputSwitching))
            .setter(setter(Builder::mqcsInputSwitching))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MQCSInputSwitching").build())
            .build();

    private static final SdkField<Integer> PREFERRED_INPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PreferredInput").getter(getter(InputSwitchConfiguration::preferredInput))
            .setter(setter(Builder::preferredInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MQCS_INPUT_SWITCHING_FIELD,
            PREFERRED_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean mqcsInputSwitching;

    private final Integer preferredInput;

    private InputSwitchConfiguration(BuilderImpl builder) {
        this.mqcsInputSwitching = builder.mqcsInputSwitching;
        this.preferredInput = builder.preferredInput;
    }

    /**
     * <p>
     * When true, AWS Elemental MediaPackage performs input switching based on the MQCS. Default is true. This setting
     * is valid only when <code>InputType</code> is <code>CMAF</code>.
     * </p>
     * 
     * @return When true, AWS Elemental MediaPackage performs input switching based on the MQCS. Default is true. This
     *         setting is valid only when <code>InputType</code> is <code>CMAF</code>.
     */
    public final Boolean mqcsInputSwitching() {
        return mqcsInputSwitching;
    }

    /**
     * <p>
     * For CMAF inputs, indicates which input MediaPackage should prefer when both inputs have equal MQCS scores. Select
     * <code>1</code> to prefer the first ingest endpoint, or <code>2</code> to prefer the second ingest endpoint. If
     * you don't specify a preferred input, MediaPackage uses its default switching behavior when MQCS scores are equal.
     * </p>
     * 
     * @return For CMAF inputs, indicates which input MediaPackage should prefer when both inputs have equal MQCS
     *         scores. Select <code>1</code> to prefer the first ingest endpoint, or <code>2</code> to prefer the second
     *         ingest endpoint. If you don't specify a preferred input, MediaPackage uses its default switching behavior
     *         when MQCS scores are equal.
     */
    public final Integer preferredInput() {
        return preferredInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mqcsInputSwitching());
        hashCode = 31 * hashCode + Objects.hashCode(preferredInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSwitchConfiguration)) {
            return false;
        }
        InputSwitchConfiguration other = (InputSwitchConfiguration) obj;
        return Objects.equals(mqcsInputSwitching(), other.mqcsInputSwitching())
                && Objects.equals(preferredInput(), other.preferredInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputSwitchConfiguration").add("MQCSInputSwitching", mqcsInputSwitching())
                .add("PreferredInput", preferredInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MQCSInputSwitching":
            return Optional.ofNullable(clazz.cast(mqcsInputSwitching()));
        case "PreferredInput":
            return Optional.ofNullable(clazz.cast(preferredInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MQCSInputSwitching", MQCS_INPUT_SWITCHING_FIELD);
        map.put("PreferredInput", PREFERRED_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputSwitchConfiguration, T> g) {
        return obj -> g.apply((InputSwitchConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputSwitchConfiguration> {
        /**
         * <p>
         * When true, AWS Elemental MediaPackage performs input switching based on the MQCS. Default is true. This
         * setting is valid only when <code>InputType</code> is <code>CMAF</code>.
         * </p>
         * 
         * @param mqcsInputSwitching
         *        When true, AWS Elemental MediaPackage performs input switching based on the MQCS. Default is true.
         *        This setting is valid only when <code>InputType</code> is <code>CMAF</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mqcsInputSwitching(Boolean mqcsInputSwitching);

        /**
         * <p>
         * For CMAF inputs, indicates which input MediaPackage should prefer when both inputs have equal MQCS scores.
         * Select <code>1</code> to prefer the first ingest endpoint, or <code>2</code> to prefer the second ingest
         * endpoint. If you don't specify a preferred input, MediaPackage uses its default switching behavior when MQCS
         * scores are equal.
         * </p>
         * 
         * @param preferredInput
         *        For CMAF inputs, indicates which input MediaPackage should prefer when both inputs have equal MQCS
         *        scores. Select <code>1</code> to prefer the first ingest endpoint, or <code>2</code> to prefer the
         *        second ingest endpoint. If you don't specify a preferred input, MediaPackage uses its default
         *        switching behavior when MQCS scores are equal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredInput(Integer preferredInput);
    }

    static final class BuilderImpl implements Builder {
        private Boolean mqcsInputSwitching;

        private Integer preferredInput;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSwitchConfiguration model) {
            mqcsInputSwitching(model.mqcsInputSwitching);
            preferredInput(model.preferredInput);
        }

        public final Boolean getMqcsInputSwitching() {
            return mqcsInputSwitching;
        }

        public final void setMqcsInputSwitching(Boolean mqcsInputSwitching) {
            this.mqcsInputSwitching = mqcsInputSwitching;
        }

        @Override
        public final Builder mqcsInputSwitching(Boolean mqcsInputSwitching) {
            this.mqcsInputSwitching = mqcsInputSwitching;
            return this;
        }

        public final Integer getPreferredInput() {
            return preferredInput;
        }

        public final void setPreferredInput(Integer preferredInput) {
            this.preferredInput = preferredInput;
        }

        @Override
        public final Builder preferredInput(Integer preferredInput) {
            this.preferredInput = preferredInput;
            return this;
        }

        @Override
        public InputSwitchConfiguration build() {
            return new InputSwitchConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
