/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IsmEncryptionMethod {
    CENC("CENC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IsmEncryptionMethod> VALUE_MAP;
    private final String value;

    private IsmEncryptionMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IsmEncryptionMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IsmEncryptionMethod> knownValues() {
        EnumSet<IsmEncryptionMethod> knownValues = EnumSet.allOf(IsmEncryptionMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IsmEncryptionMethod.class, IsmEncryptionMethod::toString);
    }
}

