/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagevod.model.MediaPackageVodResponse;
import software.amazon.awssdk.services.mediapackagevod.model.PackagingGroup;
import software.amazon.awssdk.services.mediapackagevod.model.___listOfPackagingGroupCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPackagingGroupsResponse
extends MediaPackageVodResponse
implements ToCopyableBuilder<Builder, ListPackagingGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPackagingGroupsResponse.getter(ListPackagingGroupsResponse::nextToken)).setter(ListPackagingGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<PackagingGroup>> PACKAGING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListPackagingGroupsResponse.getter(ListPackagingGroupsResponse::packagingGroups)).setter(ListPackagingGroupsResponse.setter(Builder::packagingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackagingGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PACKAGING_GROUPS_FIELD));
    private final String nextToken;
    private final List<PackagingGroup> packagingGroups;

    private ListPackagingGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.packagingGroups = builder.packagingGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasPackagingGroups() {
        return this.packagingGroups != null && !(this.packagingGroups instanceof SdkAutoConstructList);
    }

    public List<PackagingGroup> packagingGroups() {
        return this.packagingGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.packagingGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackagingGroupsResponse)) {
            return false;
        }
        ListPackagingGroupsResponse other = (ListPackagingGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.packagingGroups(), other.packagingGroups());
    }

    public String toString() {
        return ToString.builder((String)"ListPackagingGroupsResponse").add("NextToken", (Object)this.nextToken()).add("PackagingGroups", this.packagingGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PackagingGroups": {
                return Optional.ofNullable(clazz.cast(this.packagingGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackagingGroupsResponse, T> g) {
        return obj -> g.apply((ListPackagingGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageVodResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PackagingGroup> packagingGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackagingGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.packagingGroups(model.packagingGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<PackagingGroup.Builder> getPackagingGroups() {
            return this.packagingGroups != null ? (Collection)this.packagingGroups.stream().map(PackagingGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder packagingGroups(Collection<PackagingGroup> packagingGroups) {
            this.packagingGroups = ___listOfPackagingGroupCopier.copy(packagingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packagingGroups(PackagingGroup ... packagingGroups) {
            this.packagingGroups(Arrays.asList(packagingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packagingGroups(Consumer<PackagingGroup.Builder> ... packagingGroups) {
            this.packagingGroups(Stream.of(packagingGroups).map(c -> (PackagingGroup)((PackagingGroup.Builder)PackagingGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPackagingGroups(Collection<PackagingGroup.BuilderImpl> packagingGroups) {
            this.packagingGroups = ___listOfPackagingGroupCopier.copyFromBuilder(packagingGroups);
        }

        @Override
        public ListPackagingGroupsResponse build() {
            return new ListPackagingGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageVodResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPackagingGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder packagingGroups(Collection<PackagingGroup> var1);

        public Builder packagingGroups(PackagingGroup ... var1);

        public Builder packagingGroups(Consumer<PackagingGroup.Builder> ... var1);
    }
}

