/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * CDN Authorization credentials
 */
@Generated("software.amazon.awssdk:codegen")
public final class Authorization implements SdkPojo, Serializable, ToCopyableBuilder<Authorization.Builder, Authorization> {
    private static final SdkField<String> CDN_IDENTIFIER_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CdnIdentifierSecret").getter(getter(Authorization::cdnIdentifierSecret))
            .setter(setter(Builder::cdnIdentifierSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cdnIdentifierSecret").build())
            .build();

    private static final SdkField<String> SECRETS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretsRoleArn").getter(getter(Authorization::secretsRoleArn)).setter(setter(Builder::secretsRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CDN_IDENTIFIER_SECRET_FIELD,
            SECRETS_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cdnIdentifierSecret;

    private final String secretsRoleArn;

    private Authorization(BuilderImpl builder) {
        this.cdnIdentifierSecret = builder.cdnIdentifierSecret;
        this.secretsRoleArn = builder.secretsRoleArn;
    }

    /**
     * The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that is used for CDN authorization.
     * 
     * @return The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that is used for CDN authorization.
     */
    public String cdnIdentifierSecret() {
        return cdnIdentifierSecret;
    }

    /**
     * The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
     * 
     * @return The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets
     *         Manager.
     */
    public String secretsRoleArn() {
        return secretsRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cdnIdentifierSecret());
        hashCode = 31 * hashCode + Objects.hashCode(secretsRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Authorization)) {
            return false;
        }
        Authorization other = (Authorization) obj;
        return Objects.equals(cdnIdentifierSecret(), other.cdnIdentifierSecret())
                && Objects.equals(secretsRoleArn(), other.secretsRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Authorization").add("CdnIdentifierSecret", cdnIdentifierSecret())
                .add("SecretsRoleArn", secretsRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CdnIdentifierSecret":
            return Optional.ofNullable(clazz.cast(cdnIdentifierSecret()));
        case "SecretsRoleArn":
            return Optional.ofNullable(clazz.cast(secretsRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Authorization, T> g) {
        return obj -> g.apply((Authorization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Authorization> {
        /**
         * The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that is used for CDN authorization.
         * 
         * @param cdnIdentifierSecret
         *        The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that is used for CDN
         *        authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdnIdentifierSecret(String cdnIdentifierSecret);

        /**
         * The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets
         * Manager.
         * 
         * @param secretsRoleArn
         *        The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS
         *        Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsRoleArn(String secretsRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String cdnIdentifierSecret;

        private String secretsRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Authorization model) {
            cdnIdentifierSecret(model.cdnIdentifierSecret);
            secretsRoleArn(model.secretsRoleArn);
        }

        public final String getCdnIdentifierSecret() {
            return cdnIdentifierSecret;
        }

        @Override
        public final Builder cdnIdentifierSecret(String cdnIdentifierSecret) {
            this.cdnIdentifierSecret = cdnIdentifierSecret;
            return this;
        }

        public final void setCdnIdentifierSecret(String cdnIdentifierSecret) {
            this.cdnIdentifierSecret = cdnIdentifierSecret;
        }

        public final String getSecretsRoleArn() {
            return secretsRoleArn;
        }

        @Override
        public final Builder secretsRoleArn(String secretsRoleArn) {
            this.secretsRoleArn = secretsRoleArn;
            return this;
        }

        public final void setSecretsRoleArn(String secretsRoleArn) {
            this.secretsRoleArn = secretsRoleArn;
        }

        @Override
        public Authorization build() {
            return new Authorization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
