/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MssPackage implements SdkPojo, Serializable, ToCopyableBuilder<MssPackage.Builder, MssPackage> {
    private static final SdkField<MssEncryption> ENCRYPTION_FIELD = SdkField.<MssEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(MssPackage::encryption)).setter(setter(Builder::encryption))
            .constructor(MssEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<List<MssManifest>> MSS_MANIFESTS_FIELD = SdkField
            .<List<MssManifest>> builder(MarshallingType.LIST)
            .memberName("MssManifests")
            .getter(getter(MssPackage::mssManifests))
            .setter(setter(Builder::mssManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mssManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MssManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(MssManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentDurationSeconds").getter(getter(MssPackage::segmentDurationSeconds))
            .setter(setter(Builder::segmentDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD,
            MSS_MANIFESTS_FIELD, SEGMENT_DURATION_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final MssEncryption encryption;

    private final List<MssManifest> mssManifests;

    private final Integer segmentDurationSeconds;

    private MssPackage(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.mssManifests = builder.mssManifests;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
    }

    /**
     * Returns the value of the Encryption property for this object.
     * 
     * @return The value of the Encryption property for this object.
     */
    public MssEncryption encryption() {
        return encryption;
    }

    /**
     * Returns true if the MssManifests property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMssManifests() {
        return mssManifests != null && !(mssManifests instanceof SdkAutoConstructList);
    }

    /**
     * A list of MSS manifest configurations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMssManifests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of MSS manifest configurations.
     */
    public List<MssManifest> mssManifests() {
        return mssManifests;
    }

    /**
     * The duration (in seconds) of each segment.
     * 
     * @return The duration (in seconds) of each segment.
     */
    public Integer segmentDurationSeconds() {
        return segmentDurationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(hasMssManifests() ? mssManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(segmentDurationSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MssPackage)) {
            return false;
        }
        MssPackage other = (MssPackage) obj;
        return Objects.equals(encryption(), other.encryption()) && hasMssManifests() == other.hasMssManifests()
                && Objects.equals(mssManifests(), other.mssManifests())
                && Objects.equals(segmentDurationSeconds(), other.segmentDurationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MssPackage").add("Encryption", encryption())
                .add("MssManifests", hasMssManifests() ? mssManifests() : null)
                .add("SegmentDurationSeconds", segmentDurationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "MssManifests":
            return Optional.ofNullable(clazz.cast(mssManifests()));
        case "SegmentDurationSeconds":
            return Optional.ofNullable(clazz.cast(segmentDurationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MssPackage, T> g) {
        return obj -> g.apply((MssPackage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MssPackage> {
        /**
         * Sets the value of the Encryption property for this object.
         *
         * @param encryption
         *        The new value for the Encryption property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(MssEncryption encryption);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * This is a convenience that creates an instance of the {@link MssEncryption.Builder} avoiding the need to
         * create one manually via {@link MssEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link MssEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(MssEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link MssEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(MssEncryption)
         */
        default Builder encryption(Consumer<MssEncryption.Builder> encryption) {
            return encryption(MssEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * A list of MSS manifest configurations.
         * 
         * @param mssManifests
         *        A list of MSS manifest configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mssManifests(Collection<MssManifest> mssManifests);

        /**
         * A list of MSS manifest configurations.
         * 
         * @param mssManifests
         *        A list of MSS manifest configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mssManifests(MssManifest... mssManifests);

        /**
         * A list of MSS manifest configurations. This is a convenience that creates an instance of the {@link List
         * <MssManifest>.Builder} avoiding the need to create one manually via {@link List<MssManifest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MssManifest>.Builder#build()} is called immediately and its
         * result is passed to {@link #mssManifests(List<MssManifest>)}.
         * 
         * @param mssManifests
         *        a consumer that will call methods on {@link List<MssManifest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mssManifests(List<MssManifest>)
         */
        Builder mssManifests(Consumer<MssManifest.Builder>... mssManifests);

        /**
         * The duration (in seconds) of each segment.
         * 
         * @param segmentDurationSeconds
         *        The duration (in seconds) of each segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDurationSeconds(Integer segmentDurationSeconds);
    }

    static final class BuilderImpl implements Builder {
        private MssEncryption encryption;

        private List<MssManifest> mssManifests = DefaultSdkAutoConstructList.getInstance();

        private Integer segmentDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(MssPackage model) {
            encryption(model.encryption);
            mssManifests(model.mssManifests);
            segmentDurationSeconds(model.segmentDurationSeconds);
        }

        public final MssEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(MssEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(MssEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Collection<MssManifest.Builder> getMssManifests() {
            if (mssManifests instanceof SdkAutoConstructList) {
                return null;
            }
            return mssManifests != null ? mssManifests.stream().map(MssManifest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mssManifests(Collection<MssManifest> mssManifests) {
            this.mssManifests = ___listOfMssManifestCopier.copy(mssManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mssManifests(MssManifest... mssManifests) {
            mssManifests(Arrays.asList(mssManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mssManifests(Consumer<MssManifest.Builder>... mssManifests) {
            mssManifests(Stream.of(mssManifests).map(c -> MssManifest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMssManifests(Collection<MssManifest.BuilderImpl> mssManifests) {
            this.mssManifests = ___listOfMssManifestCopier.copyFromBuilder(mssManifests);
        }

        public final Integer getSegmentDurationSeconds() {
            return segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        @Override
        public MssPackage build() {
            return new MssPackage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
