/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.mediapackagevod.model.CreateAssetRequest;
import software.amazon.awssdk.services.mediapackagevod.model.CreateAssetResponse;
import software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationRequest;
import software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationResponse;
import software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest;
import software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupResponse;
import software.amazon.awssdk.services.mediapackagevod.model.DeleteAssetRequest;
import software.amazon.awssdk.services.mediapackagevod.model.DeleteAssetResponse;
import software.amazon.awssdk.services.mediapackagevod.model.DeletePackagingConfigurationRequest;
import software.amazon.awssdk.services.mediapackagevod.model.DeletePackagingConfigurationResponse;
import software.amazon.awssdk.services.mediapackagevod.model.DeletePackagingGroupRequest;
import software.amazon.awssdk.services.mediapackagevod.model.DeletePackagingGroupResponse;
import software.amazon.awssdk.services.mediapackagevod.model.DescribeAssetRequest;
import software.amazon.awssdk.services.mediapackagevod.model.DescribeAssetResponse;
import software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingConfigurationRequest;
import software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingConfigurationResponse;
import software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingGroupRequest;
import software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingGroupResponse;
import software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListAssetsResponse;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse;
import software.amazon.awssdk.services.mediapackagevod.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediapackagevod.model.TagResourceRequest;
import software.amazon.awssdk.services.mediapackagevod.model.TagResourceResponse;
import software.amazon.awssdk.services.mediapackagevod.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediapackagevod.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediapackagevod.model.UpdatePackagingGroupRequest;
import software.amazon.awssdk.services.mediapackagevod.model.UpdatePackagingGroupResponse;
import software.amazon.awssdk.services.mediapackagevod.paginators.ListAssetsPublisher;
import software.amazon.awssdk.services.mediapackagevod.paginators.ListPackagingConfigurationsPublisher;
import software.amazon.awssdk.services.mediapackagevod.paginators.ListPackagingGroupsPublisher;

/**
 * Service client for accessing MediaPackage Vod asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * AWS Elemental MediaPackage VOD
 */
@Generated("software.amazon.awssdk:codegen")
public interface MediaPackageVodAsyncClient extends SdkClient {
    String SERVICE_NAME = "mediapackage-vod";

    /**
     * Create a {@link MediaPackageVodAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaPackageVodAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaPackageVodAsyncClient}.
     */
    static MediaPackageVodAsyncClientBuilder builder() {
        return new DefaultMediaPackageVodAsyncClientBuilder();
    }

    /**
     * Creates a new MediaPackage VOD Asset resource.
     *
     * @param createAssetRequest
     *        A new MediaPackage VOD Asset configuration.
     * @return A Java Future containing the result of the CreateAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.CreateAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CreateAsset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssetResponse> createAsset(CreateAssetRequest createAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a new MediaPackage VOD Asset resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAssetRequest#builder()}
     * </p>
     *
     * @param createAssetRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssetRequest.Builder} to create a request. A new
     *        MediaPackage VOD Asset configuration.
     * @return A Java Future containing the result of the CreateAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.CreateAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CreateAsset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssetResponse> createAsset(Consumer<CreateAssetRequest.Builder> createAssetRequest) {
        return createAsset(CreateAssetRequest.builder().applyMutation(createAssetRequest).build());
    }

    /**
     * Creates a new MediaPackage VOD PackagingConfiguration resource.
     *
     * @param createPackagingConfigurationRequest
     *        A new MediaPackage VOD PackagingConfiguration resource configuration.
     * @return A Java Future containing the result of the CreatePackagingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.CreatePackagingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CreatePackagingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePackagingConfigurationResponse> createPackagingConfiguration(
            CreatePackagingConfigurationRequest createPackagingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a new MediaPackage VOD PackagingConfiguration resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePackagingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePackagingConfigurationRequest#builder()}
     * </p>
     *
     * @param createPackagingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreatePackagingConfigurationRequest.Builder} to create
     *        a request. A new MediaPackage VOD PackagingConfiguration resource configuration.
     * @return A Java Future containing the result of the CreatePackagingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.CreatePackagingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CreatePackagingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePackagingConfigurationResponse> createPackagingConfiguration(
            Consumer<CreatePackagingConfigurationRequest.Builder> createPackagingConfigurationRequest) {
        return createPackagingConfiguration(CreatePackagingConfigurationRequest.builder()
                .applyMutation(createPackagingConfigurationRequest).build());
    }

    /**
     * Creates a new MediaPackage VOD PackagingGroup resource.
     *
     * @param createPackagingGroupRequest
     *        A new MediaPackage VOD PackagingGroup resource configuration.
     * @return A Java Future containing the result of the CreatePackagingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.CreatePackagingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CreatePackagingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePackagingGroupResponse> createPackagingGroup(
            CreatePackagingGroupRequest createPackagingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a new MediaPackage VOD PackagingGroup resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePackagingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePackagingGroupRequest#builder()}
     * </p>
     *
     * @param createPackagingGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreatePackagingGroupRequest.Builder} to create a
     *        request. A new MediaPackage VOD PackagingGroup resource configuration.
     * @return A Java Future containing the result of the CreatePackagingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.CreatePackagingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CreatePackagingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePackagingGroupResponse> createPackagingGroup(
            Consumer<CreatePackagingGroupRequest.Builder> createPackagingGroupRequest) {
        return createPackagingGroup(CreatePackagingGroupRequest.builder().applyMutation(createPackagingGroupRequest).build());
    }

    /**
     * Deletes an existing MediaPackage VOD Asset resource.
     *
     * @param deleteAssetRequest
     * @return A Java Future containing the result of the DeleteAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.DeleteAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DeleteAsset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAssetResponse> deleteAsset(DeleteAssetRequest deleteAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an existing MediaPackage VOD Asset resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAssetRequest#builder()}
     * </p>
     *
     * @param deleteAssetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.DeleteAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DeleteAsset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAssetResponse> deleteAsset(Consumer<DeleteAssetRequest.Builder> deleteAssetRequest) {
        return deleteAsset(DeleteAssetRequest.builder().applyMutation(deleteAssetRequest).build());
    }

    /**
     * Deletes a MediaPackage VOD PackagingConfiguration resource.
     *
     * @param deletePackagingConfigurationRequest
     * @return A Java Future containing the result of the DeletePackagingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.DeletePackagingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DeletePackagingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePackagingConfigurationResponse> deletePackagingConfiguration(
            DeletePackagingConfigurationRequest deletePackagingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a MediaPackage VOD PackagingConfiguration resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePackagingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePackagingConfigurationRequest#builder()}
     * </p>
     *
     * @param deletePackagingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeletePackagingConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeletePackagingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.DeletePackagingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DeletePackagingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePackagingConfigurationResponse> deletePackagingConfiguration(
            Consumer<DeletePackagingConfigurationRequest.Builder> deletePackagingConfigurationRequest) {
        return deletePackagingConfiguration(DeletePackagingConfigurationRequest.builder()
                .applyMutation(deletePackagingConfigurationRequest).build());
    }

    /**
     * Deletes a MediaPackage VOD PackagingGroup resource.
     *
     * @param deletePackagingGroupRequest
     * @return A Java Future containing the result of the DeletePackagingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.DeletePackagingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DeletePackagingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePackagingGroupResponse> deletePackagingGroup(
            DeletePackagingGroupRequest deletePackagingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a MediaPackage VOD PackagingGroup resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePackagingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePackagingGroupRequest#builder()}
     * </p>
     *
     * @param deletePackagingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeletePackagingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePackagingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.DeletePackagingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DeletePackagingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePackagingGroupResponse> deletePackagingGroup(
            Consumer<DeletePackagingGroupRequest.Builder> deletePackagingGroupRequest) {
        return deletePackagingGroup(DeletePackagingGroupRequest.builder().applyMutation(deletePackagingGroupRequest).build());
    }

    /**
     * Returns a description of a MediaPackage VOD Asset resource.
     *
     * @param describeAssetRequest
     * @return A Java Future containing the result of the DescribeAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.DescribeAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribeAsset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAssetResponse> describeAsset(DescribeAssetRequest describeAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a description of a MediaPackage VOD Asset resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssetRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAssetRequest#builder()}
     * </p>
     *
     * @param describeAssetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.DescribeAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribeAsset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAssetResponse> describeAsset(Consumer<DescribeAssetRequest.Builder> describeAssetRequest) {
        return describeAsset(DescribeAssetRequest.builder().applyMutation(describeAssetRequest).build());
    }

    /**
     * Returns a description of a MediaPackage VOD PackagingConfiguration resource.
     *
     * @param describePackagingConfigurationRequest
     * @return A Java Future containing the result of the DescribePackagingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.DescribePackagingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribePackagingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePackagingConfigurationResponse> describePackagingConfiguration(
            DescribePackagingConfigurationRequest describePackagingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a description of a MediaPackage VOD PackagingConfiguration resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackagingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePackagingConfigurationRequest#builder()}
     * </p>
     *
     * @param describePackagingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribePackagingConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribePackagingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.DescribePackagingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribePackagingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePackagingConfigurationResponse> describePackagingConfiguration(
            Consumer<DescribePackagingConfigurationRequest.Builder> describePackagingConfigurationRequest) {
        return describePackagingConfiguration(DescribePackagingConfigurationRequest.builder()
                .applyMutation(describePackagingConfigurationRequest).build());
    }

    /**
     * Returns a description of a MediaPackage VOD PackagingGroup resource.
     *
     * @param describePackagingGroupRequest
     * @return A Java Future containing the result of the DescribePackagingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.DescribePackagingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribePackagingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePackagingGroupResponse> describePackagingGroup(
            DescribePackagingGroupRequest describePackagingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a description of a MediaPackage VOD PackagingGroup resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackagingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePackagingGroupRequest#builder()}
     * </p>
     *
     * @param describePackagingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribePackagingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePackagingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.DescribePackagingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribePackagingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePackagingGroupResponse> describePackagingGroup(
            Consumer<DescribePackagingGroupRequest.Builder> describePackagingGroupRequest) {
        return describePackagingGroup(DescribePackagingGroupRequest.builder().applyMutation(describePackagingGroupRequest)
                .build());
    }

    /**
     * Returns a collection of MediaPackage VOD Asset resources.
     *
     * @param listAssetsRequest
     * @return A Java Future containing the result of the ListAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssetsResponse> listAssets(ListAssetsRequest listAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a collection of MediaPackage VOD Asset resources.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssetsRequest#builder()}
     * </p>
     *
     * @param listAssetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssetsResponse> listAssets(Consumer<ListAssetsRequest.Builder> listAssetsRequest) {
        return listAssets(ListAssetsRequest.builder().applyMutation(listAssetsRequest).build());
    }

    /**
     * Returns a collection of MediaPackage VOD Asset resources.<br/>
     * <p>
     * This is a variant of {@link #listAssets(software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagevod.paginators.ListAssetsPublisher publisher = client.listAssetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagevod.paginators.ListAssetsPublisher publisher = client.listAssetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediapackagevod.model.ListAssetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediapackagevod.model.ListAssetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssets(software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest)} operation.</b>
     * </p>
     *
     * @param listAssetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetsPublisher listAssetsPaginator(ListAssetsRequest listAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a collection of MediaPackage VOD Asset resources.<br/>
     * <p>
     * This is a variant of {@link #listAssets(software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagevod.paginators.ListAssetsPublisher publisher = client.listAssetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagevod.paginators.ListAssetsPublisher publisher = client.listAssetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediapackagevod.model.ListAssetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediapackagevod.model.ListAssetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssets(software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssetsRequest#builder()}
     * </p>
     *
     * @param listAssetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetsPublisher listAssetsPaginator(Consumer<ListAssetsRequest.Builder> listAssetsRequest) {
        return listAssetsPaginator(ListAssetsRequest.builder().applyMutation(listAssetsRequest).build());
    }

    /**
     * Returns a collection of MediaPackage VOD PackagingConfiguration resources.
     *
     * @param listPackagingConfigurationsRequest
     * @return A Java Future containing the result of the ListPackagingConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListPackagingConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListPackagingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPackagingConfigurationsResponse> listPackagingConfigurations(
            ListPackagingConfigurationsRequest listPackagingConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a collection of MediaPackage VOD PackagingConfiguration resources.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagingConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPackagingConfigurationsRequest#builder()}
     * </p>
     *
     * @param listPackagingConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListPackagingConfigurationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListPackagingConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListPackagingConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListPackagingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPackagingConfigurationsResponse> listPackagingConfigurations(
            Consumer<ListPackagingConfigurationsRequest.Builder> listPackagingConfigurationsRequest) {
        return listPackagingConfigurations(ListPackagingConfigurationsRequest.builder()
                .applyMutation(listPackagingConfigurationsRequest).build());
    }

    /**
     * Returns a collection of MediaPackage VOD PackagingConfiguration resources.<br/>
     * <p>
     * This is a variant of
     * {@link #listPackagingConfigurations(software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagevod.paginators.ListPackagingConfigurationsPublisher publisher = client.listPackagingConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagevod.paginators.ListPackagingConfigurationsPublisher publisher = client.listPackagingConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackagingConfigurations(software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPackagingConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListPackagingConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListPackagingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackagingConfigurationsPublisher listPackagingConfigurationsPaginator(
            ListPackagingConfigurationsRequest listPackagingConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a collection of MediaPackage VOD PackagingConfiguration resources.<br/>
     * <p>
     * This is a variant of
     * {@link #listPackagingConfigurations(software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagevod.paginators.ListPackagingConfigurationsPublisher publisher = client.listPackagingConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagevod.paginators.ListPackagingConfigurationsPublisher publisher = client.listPackagingConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackagingConfigurations(software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagingConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPackagingConfigurationsRequest#builder()}
     * </p>
     *
     * @param listPackagingConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListPackagingConfigurationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListPackagingConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListPackagingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackagingConfigurationsPublisher listPackagingConfigurationsPaginator(
            Consumer<ListPackagingConfigurationsRequest.Builder> listPackagingConfigurationsRequest) {
        return listPackagingConfigurationsPaginator(ListPackagingConfigurationsRequest.builder()
                .applyMutation(listPackagingConfigurationsRequest).build());
    }

    /**
     * Returns a collection of MediaPackage VOD PackagingGroup resources.
     *
     * @param listPackagingGroupsRequest
     * @return A Java Future containing the result of the ListPackagingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListPackagingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListPackagingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPackagingGroupsResponse> listPackagingGroups(
            ListPackagingGroupsRequest listPackagingGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a collection of MediaPackage VOD PackagingGroup resources.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagingGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackagingGroupsRequest#builder()}
     * </p>
     *
     * @param listPackagingGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListPackagingGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPackagingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListPackagingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListPackagingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPackagingGroupsResponse> listPackagingGroups(
            Consumer<ListPackagingGroupsRequest.Builder> listPackagingGroupsRequest) {
        return listPackagingGroups(ListPackagingGroupsRequest.builder().applyMutation(listPackagingGroupsRequest).build());
    }

    /**
     * Returns a collection of MediaPackage VOD PackagingGroup resources.<br/>
     * <p>
     * This is a variant of
     * {@link #listPackagingGroups(software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagevod.paginators.ListPackagingGroupsPublisher publisher = client.listPackagingGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagevod.paginators.ListPackagingGroupsPublisher publisher = client.listPackagingGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackagingGroups(software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPackagingGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListPackagingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListPackagingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackagingGroupsPublisher listPackagingGroupsPaginator(ListPackagingGroupsRequest listPackagingGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a collection of MediaPackage VOD PackagingGroup resources.<br/>
     * <p>
     * This is a variant of
     * {@link #listPackagingGroups(software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagevod.paginators.ListPackagingGroupsPublisher publisher = client.listPackagingGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagevod.paginators.ListPackagingGroupsPublisher publisher = client.listPackagingGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackagingGroups(software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagingGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackagingGroupsRequest#builder()}
     * </p>
     *
     * @param listPackagingGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListPackagingGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListPackagingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListPackagingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackagingGroupsPublisher listPackagingGroupsPaginator(
            Consumer<ListPackagingGroupsRequest.Builder> listPackagingGroupsRequest) {
        return listPackagingGroupsPaginator(ListPackagingGroupsRequest.builder().applyMutation(listPackagingGroupsRequest)
                .build());
    }

    /**
     * Returns a list of the tags assigned to the specified resource.
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a list of the tags assigned to the specified resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * Adds tags to the specified resource. You can specify one or more tags to add.
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Adds tags to the specified resource. You can specify one or more tags to add.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * Removes tags from the specified resource. You can specify one or more tags to remove.
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Removes tags from the specified resource. You can specify one or more tags to remove.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Updates a specific packaging group. You can't change the id attribute or any other system-generated attributes.
     *
     * @param updatePackagingGroupRequest
     *        A MediaPackage VOD PackagingGroup resource configuration.
     * @return A Java Future containing the result of the UpdatePackagingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.UpdatePackagingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/UpdatePackagingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePackagingGroupResponse> updatePackagingGroup(
            UpdatePackagingGroupRequest updatePackagingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a specific packaging group. You can't change the id attribute or any other system-generated attributes.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePackagingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePackagingGroupRequest#builder()}
     * </p>
     *
     * @param updatePackagingGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePackagingGroupRequest.Builder} to create a
     *        request. A MediaPackage VOD PackagingGroup resource configuration.
     * @return A Java Future containing the result of the UpdatePackagingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The parameters sent in the request are not valid.</li>
     *         <li>InternalServerErrorException An unexpected error occurred.</li>
     *         <li>ForbiddenException The client is not authorized to access the requested resource.</li>
     *         <li>NotFoundException The requested resource does not exist.</li>
     *         <li>ServiceUnavailableException An unexpected error occurred.</li>
     *         <li>TooManyRequestsException The client has exceeded their resource or throttling limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageVodException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageVodAsyncClient.UpdatePackagingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/UpdatePackagingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePackagingGroupResponse> updatePackagingGroup(
            Consumer<UpdatePackagingGroupRequest.Builder> updatePackagingGroupRequest) {
        return updatePackagingGroup(UpdatePackagingGroupRequest.builder().applyMutation(updatePackagingGroupRequest).build());
    }
}
