/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A new MediaPackage VOD PackagingConfiguration resource configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePackagingConfigurationRequest extends MediaPackageVodRequest implements
        ToCopyableBuilder<CreatePackagingConfigurationRequest.Builder, CreatePackagingConfigurationRequest> {
    private static final SdkField<CmafPackage> CMAF_PACKAGE_FIELD = SdkField.<CmafPackage> builder(MarshallingType.SDK_POJO)
            .memberName("CmafPackage").getter(getter(CreatePackagingConfigurationRequest::cmafPackage))
            .setter(setter(Builder::cmafPackage)).constructor(CmafPackage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmafPackage").build()).build();

    private static final SdkField<DashPackage> DASH_PACKAGE_FIELD = SdkField.<DashPackage> builder(MarshallingType.SDK_POJO)
            .memberName("DashPackage").getter(getter(CreatePackagingConfigurationRequest::dashPackage))
            .setter(setter(Builder::dashPackage)).constructor(DashPackage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashPackage").build()).build();

    private static final SdkField<HlsPackage> HLS_PACKAGE_FIELD = SdkField.<HlsPackage> builder(MarshallingType.SDK_POJO)
            .memberName("HlsPackage").getter(getter(CreatePackagingConfigurationRequest::hlsPackage))
            .setter(setter(Builder::hlsPackage)).constructor(HlsPackage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsPackage").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CreatePackagingConfigurationRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<MssPackage> MSS_PACKAGE_FIELD = SdkField.<MssPackage> builder(MarshallingType.SDK_POJO)
            .memberName("MssPackage").getter(getter(CreatePackagingConfigurationRequest::mssPackage))
            .setter(setter(Builder::mssPackage)).constructor(MssPackage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mssPackage").build()).build();

    private static final SdkField<String> PACKAGING_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackagingGroupId").getter(getter(CreatePackagingConfigurationRequest::packagingGroupId))
            .setter(setter(Builder::packagingGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingGroupId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreatePackagingConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CMAF_PACKAGE_FIELD,
            DASH_PACKAGE_FIELD, HLS_PACKAGE_FIELD, ID_FIELD, MSS_PACKAGE_FIELD, PACKAGING_GROUP_ID_FIELD, TAGS_FIELD));

    private final CmafPackage cmafPackage;

    private final DashPackage dashPackage;

    private final HlsPackage hlsPackage;

    private final String id;

    private final MssPackage mssPackage;

    private final String packagingGroupId;

    private final Map<String, String> tags;

    private CreatePackagingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.cmafPackage = builder.cmafPackage;
        this.dashPackage = builder.dashPackage;
        this.hlsPackage = builder.hlsPackage;
        this.id = builder.id;
        this.mssPackage = builder.mssPackage;
        this.packagingGroupId = builder.packagingGroupId;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the CmafPackage property for this object.
     * 
     * @return The value of the CmafPackage property for this object.
     */
    public final CmafPackage cmafPackage() {
        return cmafPackage;
    }

    /**
     * Returns the value of the DashPackage property for this object.
     * 
     * @return The value of the DashPackage property for this object.
     */
    public final DashPackage dashPackage() {
        return dashPackage;
    }

    /**
     * Returns the value of the HlsPackage property for this object.
     * 
     * @return The value of the HlsPackage property for this object.
     */
    public final HlsPackage hlsPackage() {
        return hlsPackage;
    }

    /**
     * The ID of the PackagingConfiguration.
     * 
     * @return The ID of the PackagingConfiguration.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the MssPackage property for this object.
     * 
     * @return The value of the MssPackage property for this object.
     */
    public final MssPackage mssPackage() {
        return mssPackage;
    }

    /**
     * The ID of a PackagingGroup.
     * 
     * @return The ID of a PackagingGroup.
     */
    public final String packagingGroupId() {
        return packagingGroupId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cmafPackage());
        hashCode = 31 * hashCode + Objects.hashCode(dashPackage());
        hashCode = 31 * hashCode + Objects.hashCode(hlsPackage());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(mssPackage());
        hashCode = 31 * hashCode + Objects.hashCode(packagingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackagingConfigurationRequest)) {
            return false;
        }
        CreatePackagingConfigurationRequest other = (CreatePackagingConfigurationRequest) obj;
        return Objects.equals(cmafPackage(), other.cmafPackage()) && Objects.equals(dashPackage(), other.dashPackage())
                && Objects.equals(hlsPackage(), other.hlsPackage()) && Objects.equals(id(), other.id())
                && Objects.equals(mssPackage(), other.mssPackage())
                && Objects.equals(packagingGroupId(), other.packagingGroupId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePackagingConfigurationRequest").add("CmafPackage", cmafPackage())
                .add("DashPackage", dashPackage()).add("HlsPackage", hlsPackage()).add("Id", id())
                .add("MssPackage", mssPackage()).add("PackagingGroupId", packagingGroupId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CmafPackage":
            return Optional.ofNullable(clazz.cast(cmafPackage()));
        case "DashPackage":
            return Optional.ofNullable(clazz.cast(dashPackage()));
        case "HlsPackage":
            return Optional.ofNullable(clazz.cast(hlsPackage()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MssPackage":
            return Optional.ofNullable(clazz.cast(mssPackage()));
        case "PackagingGroupId":
            return Optional.ofNullable(clazz.cast(packagingGroupId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePackagingConfigurationRequest, T> g) {
        return obj -> g.apply((CreatePackagingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageVodRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePackagingConfigurationRequest> {
        /**
         * Sets the value of the CmafPackage property for this object.
         *
         * @param cmafPackage
         *        The new value for the CmafPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cmafPackage(CmafPackage cmafPackage);

        /**
         * Sets the value of the CmafPackage property for this object.
         *
         * This is a convenience that creates an instance of the {@link CmafPackage.Builder} avoiding the need to create
         * one manually via {@link CmafPackage#builder()}.
         *
         * When the {@link Consumer} completes, {@link CmafPackage.Builder#build()} is called immediately and its result
         * is passed to {@link #cmafPackage(CmafPackage)}.
         * 
         * @param cmafPackage
         *        a consumer that will call methods on {@link CmafPackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cmafPackage(CmafPackage)
         */
        default Builder cmafPackage(Consumer<CmafPackage.Builder> cmafPackage) {
            return cmafPackage(CmafPackage.builder().applyMutation(cmafPackage).build());
        }

        /**
         * Sets the value of the DashPackage property for this object.
         *
         * @param dashPackage
         *        The new value for the DashPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashPackage(DashPackage dashPackage);

        /**
         * Sets the value of the DashPackage property for this object.
         *
         * This is a convenience that creates an instance of the {@link DashPackage.Builder} avoiding the need to create
         * one manually via {@link DashPackage#builder()}.
         *
         * When the {@link Consumer} completes, {@link DashPackage.Builder#build()} is called immediately and its result
         * is passed to {@link #dashPackage(DashPackage)}.
         * 
         * @param dashPackage
         *        a consumer that will call methods on {@link DashPackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashPackage(DashPackage)
         */
        default Builder dashPackage(Consumer<DashPackage.Builder> dashPackage) {
            return dashPackage(DashPackage.builder().applyMutation(dashPackage).build());
        }

        /**
         * Sets the value of the HlsPackage property for this object.
         *
         * @param hlsPackage
         *        The new value for the HlsPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsPackage(HlsPackage hlsPackage);

        /**
         * Sets the value of the HlsPackage property for this object.
         *
         * This is a convenience that creates an instance of the {@link HlsPackage.Builder} avoiding the need to create
         * one manually via {@link HlsPackage#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsPackage.Builder#build()} is called immediately and its result
         * is passed to {@link #hlsPackage(HlsPackage)}.
         * 
         * @param hlsPackage
         *        a consumer that will call methods on {@link HlsPackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsPackage(HlsPackage)
         */
        default Builder hlsPackage(Consumer<HlsPackage.Builder> hlsPackage) {
            return hlsPackage(HlsPackage.builder().applyMutation(hlsPackage).build());
        }

        /**
         * The ID of the PackagingConfiguration.
         * 
         * @param id
         *        The ID of the PackagingConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the MssPackage property for this object.
         *
         * @param mssPackage
         *        The new value for the MssPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mssPackage(MssPackage mssPackage);

        /**
         * Sets the value of the MssPackage property for this object.
         *
         * This is a convenience that creates an instance of the {@link MssPackage.Builder} avoiding the need to create
         * one manually via {@link MssPackage#builder()}.
         *
         * When the {@link Consumer} completes, {@link MssPackage.Builder#build()} is called immediately and its result
         * is passed to {@link #mssPackage(MssPackage)}.
         * 
         * @param mssPackage
         *        a consumer that will call methods on {@link MssPackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mssPackage(MssPackage)
         */
        default Builder mssPackage(Consumer<MssPackage.Builder> mssPackage) {
            return mssPackage(MssPackage.builder().applyMutation(mssPackage).build());
        }

        /**
         * The ID of a PackagingGroup.
         * 
         * @param packagingGroupId
         *        The ID of a PackagingGroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagingGroupId(String packagingGroupId);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageVodRequest.BuilderImpl implements Builder {
        private CmafPackage cmafPackage;

        private DashPackage dashPackage;

        private HlsPackage hlsPackage;

        private String id;

        private MssPackage mssPackage;

        private String packagingGroupId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackagingConfigurationRequest model) {
            super(model);
            cmafPackage(model.cmafPackage);
            dashPackage(model.dashPackage);
            hlsPackage(model.hlsPackage);
            id(model.id);
            mssPackage(model.mssPackage);
            packagingGroupId(model.packagingGroupId);
            tags(model.tags);
        }

        public final CmafPackage.Builder getCmafPackage() {
            return cmafPackage != null ? cmafPackage.toBuilder() : null;
        }

        @Override
        public final Builder cmafPackage(CmafPackage cmafPackage) {
            this.cmafPackage = cmafPackage;
            return this;
        }

        public final void setCmafPackage(CmafPackage.BuilderImpl cmafPackage) {
            this.cmafPackage = cmafPackage != null ? cmafPackage.build() : null;
        }

        public final DashPackage.Builder getDashPackage() {
            return dashPackage != null ? dashPackage.toBuilder() : null;
        }

        @Override
        public final Builder dashPackage(DashPackage dashPackage) {
            this.dashPackage = dashPackage;
            return this;
        }

        public final void setDashPackage(DashPackage.BuilderImpl dashPackage) {
            this.dashPackage = dashPackage != null ? dashPackage.build() : null;
        }

        public final HlsPackage.Builder getHlsPackage() {
            return hlsPackage != null ? hlsPackage.toBuilder() : null;
        }

        @Override
        public final Builder hlsPackage(HlsPackage hlsPackage) {
            this.hlsPackage = hlsPackage;
            return this;
        }

        public final void setHlsPackage(HlsPackage.BuilderImpl hlsPackage) {
            this.hlsPackage = hlsPackage != null ? hlsPackage.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final MssPackage.Builder getMssPackage() {
            return mssPackage != null ? mssPackage.toBuilder() : null;
        }

        @Override
        public final Builder mssPackage(MssPackage mssPackage) {
            this.mssPackage = mssPackage;
            return this;
        }

        public final void setMssPackage(MssPackage.BuilderImpl mssPackage) {
            this.mssPackage = mssPackage != null ? mssPackage.build() : null;
        }

        public final String getPackagingGroupId() {
            return packagingGroupId;
        }

        @Override
        public final Builder packagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
            return this;
        }

        public final void setPackagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePackagingConfigurationRequest build() {
            return new CreatePackagingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
