/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssetResponse extends MediaPackageVodResponse implements
        ToCopyableBuilder<CreateAssetResponse.Builder, CreateAssetResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateAssetResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(CreateAssetResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<List<EgressEndpoint>> EGRESS_ENDPOINTS_FIELD = SdkField
            .<List<EgressEndpoint>> builder(MarshallingType.LIST)
            .memberName("EgressEndpoints")
            .getter(getter(CreateAssetResponse::egressEndpoints))
            .setter(setter(Builder::egressEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EgressEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(EgressEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CreateAssetResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> PACKAGING_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackagingGroupId").getter(getter(CreateAssetResponse::packagingGroupId))
            .setter(setter(Builder::packagingGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingGroupId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(CreateAssetResponse::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(CreateAssetResponse::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()).build();

    private static final SdkField<String> SOURCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRoleArn").getter(getter(CreateAssetResponse::sourceRoleArn))
            .setter(setter(Builder::sourceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRoleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateAssetResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            EGRESS_ENDPOINTS_FIELD, ID_FIELD, PACKAGING_GROUP_ID_FIELD, RESOURCE_ID_FIELD, SOURCE_ARN_FIELD,
            SOURCE_ROLE_ARN_FIELD, TAGS_FIELD));

    private final String arn;

    private final String createdAt;

    private final List<EgressEndpoint> egressEndpoints;

    private final String id;

    private final String packagingGroupId;

    private final String resourceId;

    private final String sourceArn;

    private final String sourceRoleArn;

    private final Map<String, String> tags;

    private CreateAssetResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.egressEndpoints = builder.egressEndpoints;
        this.id = builder.id;
        this.packagingGroupId = builder.packagingGroupId;
        this.resourceId = builder.resourceId;
        this.sourceArn = builder.sourceArn;
        this.sourceRoleArn = builder.sourceRoleArn;
        this.tags = builder.tags;
    }

    /**
     * The ARN of the Asset.
     * 
     * @return The ARN of the Asset.
     */
    public final String arn() {
        return arn;
    }

    /**
     * The time the Asset was initially submitted for Ingest.
     * 
     * @return The time the Asset was initially submitted for Ingest.
     */
    public final String createdAt() {
        return createdAt;
    }

    /**
     * Returns true if the EgressEndpoints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasEgressEndpoints() {
        return egressEndpoints != null && !(egressEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * The list of egress endpoints available for the Asset.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEgressEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of egress endpoints available for the Asset.
     */
    public final List<EgressEndpoint> egressEndpoints() {
        return egressEndpoints;
    }

    /**
     * The unique identifier for the Asset.
     * 
     * @return The unique identifier for the Asset.
     */
    public final String id() {
        return id;
    }

    /**
     * The ID of the PackagingGroup for the Asset.
     * 
     * @return The ID of the PackagingGroup for the Asset.
     */
    public final String packagingGroupId() {
        return packagingGroupId;
    }

    /**
     * The resource ID to include in SPEKE key requests.
     * 
     * @return The resource ID to include in SPEKE key requests.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * ARN of the source object in S3.
     * 
     * @return ARN of the source object in S3.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * The IAM role_arn used to access the source S3 bucket.
     * 
     * @return The IAM role_arn used to access the source S3 bucket.
     */
    public final String sourceRoleArn() {
        return sourceRoleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasEgressEndpoints() ? egressEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(packagingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetResponse)) {
            return false;
        }
        CreateAssetResponse other = (CreateAssetResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && hasEgressEndpoints() == other.hasEgressEndpoints()
                && Objects.equals(egressEndpoints(), other.egressEndpoints()) && Objects.equals(id(), other.id())
                && Objects.equals(packagingGroupId(), other.packagingGroupId())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(sourceRoleArn(), other.sourceRoleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssetResponse").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("EgressEndpoints", hasEgressEndpoints() ? egressEndpoints() : null).add("Id", id())
                .add("PackagingGroupId", packagingGroupId()).add("ResourceId", resourceId()).add("SourceArn", sourceArn())
                .add("SourceRoleArn", sourceRoleArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "EgressEndpoints":
            return Optional.ofNullable(clazz.cast(egressEndpoints()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "PackagingGroupId":
            return Optional.ofNullable(clazz.cast(packagingGroupId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "SourceRoleArn":
            return Optional.ofNullable(clazz.cast(sourceRoleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetResponse, T> g) {
        return obj -> g.apply((CreateAssetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageVodResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssetResponse> {
        /**
         * The ARN of the Asset.
         * 
         * @param arn
         *        The ARN of the Asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The time the Asset was initially submitted for Ingest.
         * 
         * @param createdAt
         *        The time the Asset was initially submitted for Ingest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * The list of egress endpoints available for the Asset.
         * 
         * @param egressEndpoints
         *        The list of egress endpoints available for the Asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressEndpoints(Collection<EgressEndpoint> egressEndpoints);

        /**
         * The list of egress endpoints available for the Asset.
         * 
         * @param egressEndpoints
         *        The list of egress endpoints available for the Asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressEndpoints(EgressEndpoint... egressEndpoints);

        /**
         * The list of egress endpoints available for the Asset. This is a convenience that creates an instance of the
         * {@link List<EgressEndpoint>.Builder} avoiding the need to create one manually via {@link List
         * <EgressEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EgressEndpoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #egressEndpoints(List<EgressEndpoint>)}.
         * 
         * @param egressEndpoints
         *        a consumer that will call methods on {@link List<EgressEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressEndpoints(List<EgressEndpoint>)
         */
        Builder egressEndpoints(Consumer<EgressEndpoint.Builder>... egressEndpoints);

        /**
         * The unique identifier for the Asset.
         * 
         * @param id
         *        The unique identifier for the Asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The ID of the PackagingGroup for the Asset.
         * 
         * @param packagingGroupId
         *        The ID of the PackagingGroup for the Asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagingGroupId(String packagingGroupId);

        /**
         * The resource ID to include in SPEKE key requests.
         * 
         * @param resourceId
         *        The resource ID to include in SPEKE key requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * ARN of the source object in S3.
         * 
         * @param sourceArn
         *        ARN of the source object in S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * The IAM role_arn used to access the source S3 bucket.
         * 
         * @param sourceRoleArn
         *        The IAM role_arn used to access the source S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRoleArn(String sourceRoleArn);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MediaPackageVodResponse.BuilderImpl implements Builder {
        private String arn;

        private String createdAt;

        private List<EgressEndpoint> egressEndpoints = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private String packagingGroupId;

        private String resourceId;

        private String sourceArn;

        private String sourceRoleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetResponse model) {
            super(model);
            arn(model.arn);
            createdAt(model.createdAt);
            egressEndpoints(model.egressEndpoints);
            id(model.id);
            packagingGroupId(model.packagingGroupId);
            resourceId(model.resourceId);
            sourceArn(model.sourceArn);
            sourceRoleArn(model.sourceRoleArn);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final List<EgressEndpoint.Builder> getEgressEndpoints() {
            List<EgressEndpoint.Builder> result = ___listOfEgressEndpointCopier.copyToBuilder(this.egressEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder egressEndpoints(Collection<EgressEndpoint> egressEndpoints) {
            this.egressEndpoints = ___listOfEgressEndpointCopier.copy(egressEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressEndpoints(EgressEndpoint... egressEndpoints) {
            egressEndpoints(Arrays.asList(egressEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressEndpoints(Consumer<EgressEndpoint.Builder>... egressEndpoints) {
            egressEndpoints(Stream.of(egressEndpoints).map(c -> EgressEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEgressEndpoints(Collection<EgressEndpoint.BuilderImpl> egressEndpoints) {
            this.egressEndpoints = ___listOfEgressEndpointCopier.copyFromBuilder(egressEndpoints);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getPackagingGroupId() {
            return packagingGroupId;
        }

        @Override
        public final Builder packagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
            return this;
        }

        public final void setPackagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getSourceRoleArn() {
            return sourceRoleArn;
        }

        @Override
        public final Builder sourceRoleArn(String sourceRoleArn) {
            this.sourceRoleArn = sourceRoleArn;
            return this;
        }

        public final void setSourceRoleArn(String sourceRoleArn) {
            this.sourceRoleArn = sourceRoleArn;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public CreateAssetResponse build() {
            return new CreateAssetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
