/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashPackage implements SdkPojo, Serializable, ToCopyableBuilder<DashPackage.Builder, DashPackage> {
    private static final SdkField<List<DashManifest>> DASH_MANIFESTS_FIELD = SdkField
            .<List<DashManifest>> builder(MarshallingType.LIST)
            .memberName("DashManifests")
            .getter(getter(DashPackage::dashManifests))
            .setter(setter(Builder::dashManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DashManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(DashManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DashEncryption> ENCRYPTION_FIELD = SdkField.<DashEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(DashPackage::encryption)).setter(setter(Builder::encryption))
            .constructor(DashEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<Boolean> INCLUDE_ENCODER_CONFIGURATION_IN_SEGMENTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeEncoderConfigurationInSegments")
            .getter(getter(DashPackage::includeEncoderConfigurationInSegments))
            .setter(setter(Builder::includeEncoderConfigurationInSegments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("includeEncoderConfigurationInSegments").build()).build();

    private static final SdkField<List<String>> PERIOD_TRIGGERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PeriodTriggers")
            .getter(getter(DashPackage::periodTriggersAsStrings))
            .setter(setter(Builder::periodTriggersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodTriggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentDurationSeconds").getter(getter(DashPackage::segmentDurationSeconds))
            .setter(setter(Builder::segmentDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build())
            .build();

    private static final SdkField<String> SEGMENT_TEMPLATE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentTemplateFormat").getter(getter(DashPackage::segmentTemplateFormatAsString))
            .setter(setter(Builder::segmentTemplateFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentTemplateFormat").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASH_MANIFESTS_FIELD,
            ENCRYPTION_FIELD, INCLUDE_ENCODER_CONFIGURATION_IN_SEGMENTS_FIELD, PERIOD_TRIGGERS_FIELD,
            SEGMENT_DURATION_SECONDS_FIELD, SEGMENT_TEMPLATE_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DashManifest> dashManifests;

    private final DashEncryption encryption;

    private final Boolean includeEncoderConfigurationInSegments;

    private final List<String> periodTriggers;

    private final Integer segmentDurationSeconds;

    private final String segmentTemplateFormat;

    private DashPackage(BuilderImpl builder) {
        this.dashManifests = builder.dashManifests;
        this.encryption = builder.encryption;
        this.includeEncoderConfigurationInSegments = builder.includeEncoderConfigurationInSegments;
        this.periodTriggers = builder.periodTriggers;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.segmentTemplateFormat = builder.segmentTemplateFormat;
    }

    /**
     * Returns true if the DashManifests property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDashManifests() {
        return dashManifests != null && !(dashManifests instanceof SdkAutoConstructList);
    }

    /**
     * A list of DASH manifest configurations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDashManifests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of DASH manifest configurations.
     */
    public final List<DashManifest> dashManifests() {
        return dashManifests;
    }

    /**
     * Returns the value of the Encryption property for this object.
     * 
     * @return The value of the Encryption property for this object.
     */
    public final DashEncryption encryption() {
        return encryption;
    }

    /**
     * When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter
     * Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of
     * in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
     *
     * @return When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence
     *         Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video
     *         segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets
     *         during content playback.
     */
    public final Boolean includeEncoderConfigurationInSegments() {
        return includeEncoderConfigurationInSegments;
    }

    /**
     * A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation
     * Description (MPD) will be partitioned into multiple periods. If empty, the content will not be partitioned into
     * more than one period. If the list contains "ADS", new periods will be created where the Asset contains SCTE-35 ad
     * markers.
     *
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPeriodTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
     *         Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not
     *         be partitioned into more than one period. If the list contains "ADS", new periods will be created where
     *         the Asset contains SCTE-35 ad markers.
     */
    public final List<PeriodTriggersElement> periodTriggers() {
        return ___listOf__PeriodTriggersElementCopier.copyStringToEnum(periodTriggers);
    }

    /**
     * Returns true if the PeriodTriggers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPeriodTriggers() {
        return periodTriggers != null && !(periodTriggers instanceof SdkAutoConstructList);
    }

    /**
     * A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation
     * Description (MPD) will be partitioned into multiple periods. If empty, the content will not be partitioned into
     * more than one period. If the list contains "ADS", new periods will be created where the Asset contains SCTE-35 ad
     * markers.
     *
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPeriodTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
     *         Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not
     *         be partitioned into more than one period. If the list contains "ADS", new periods will be created where
     *         the Asset contains SCTE-35 ad markers.
     */
    public final List<String> periodTriggersAsStrings() {
        return periodTriggers;
    }

    /**
     * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source
     * segment duration.
     *
     * @return Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the
     *         source segment duration.
     */
    public final Integer segmentDurationSeconds() {
        return segmentDurationSeconds;
    }

    /**
     * Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to
     * NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When set to
     * TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to
     * NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentTemplateFormat} will return {@link SegmentTemplateFormat#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #segmentTemplateFormatAsString}.
     * </p>
     * 
     * @return Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to
     *         NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.
     *         When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media
     *         URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with
     *         $Number$ media URLs.
     * @see SegmentTemplateFormat
     */
    public final SegmentTemplateFormat segmentTemplateFormat() {
        return SegmentTemplateFormat.fromValue(segmentTemplateFormat);
    }

    /**
     * Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to
     * NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When set to
     * TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to
     * NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentTemplateFormat} will return {@link SegmentTemplateFormat#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #segmentTemplateFormatAsString}.
     * </p>
     * 
     * @return Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to
     *         NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.
     *         When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media
     *         URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with
     *         $Number$ media URLs.
     * @see SegmentTemplateFormat
     */
    public final String segmentTemplateFormatAsString() {
        return segmentTemplateFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDashManifests() ? dashManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(includeEncoderConfigurationInSegments());
        hashCode = 31 * hashCode + Objects.hashCode(hasPeriodTriggers() ? periodTriggersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(segmentTemplateFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashPackage)) {
            return false;
        }
        DashPackage other = (DashPackage) obj;
        return hasDashManifests() == other.hasDashManifests() && Objects.equals(dashManifests(), other.dashManifests())
                && Objects.equals(encryption(), other.encryption())
                && Objects.equals(includeEncoderConfigurationInSegments(), other.includeEncoderConfigurationInSegments())
                && hasPeriodTriggers() == other.hasPeriodTriggers()
                && Objects.equals(periodTriggersAsStrings(), other.periodTriggersAsStrings())
                && Objects.equals(segmentDurationSeconds(), other.segmentDurationSeconds())
                && Objects.equals(segmentTemplateFormatAsString(), other.segmentTemplateFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashPackage").add("DashManifests", hasDashManifests() ? dashManifests() : null)
                .add("Encryption", encryption())
                .add("IncludeEncoderConfigurationInSegments", includeEncoderConfigurationInSegments())
                .add("PeriodTriggers", hasPeriodTriggers() ? periodTriggersAsStrings() : null)
                .add("SegmentDurationSeconds", segmentDurationSeconds())
                .add("SegmentTemplateFormat", segmentTemplateFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashManifests":
            return Optional.ofNullable(clazz.cast(dashManifests()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "IncludeEncoderConfigurationInSegments":
            return Optional.ofNullable(clazz.cast(includeEncoderConfigurationInSegments()));
        case "PeriodTriggers":
            return Optional.ofNullable(clazz.cast(periodTriggersAsStrings()));
        case "SegmentDurationSeconds":
            return Optional.ofNullable(clazz.cast(segmentDurationSeconds()));
        case "SegmentTemplateFormat":
            return Optional.ofNullable(clazz.cast(segmentTemplateFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashPackage, T> g) {
        return obj -> g.apply((DashPackage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashPackage> {
        /**
         * A list of DASH manifest configurations.
         * 
         * @param dashManifests
         *        A list of DASH manifest configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashManifests(Collection<DashManifest> dashManifests);

        /**
         * A list of DASH manifest configurations.
         * 
         * @param dashManifests
         *        A list of DASH manifest configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashManifests(DashManifest... dashManifests);

        /**
         * A list of DASH manifest configurations. This is a convenience that creates an instance of the {@link List
         * <DashManifest>.Builder} avoiding the need to create one manually via {@link List<DashManifest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DashManifest>.Builder#build()} is called immediately and its
         * result is passed to {@link #dashManifests(List<DashManifest>)}.
         * 
         * @param dashManifests
         *        a consumer that will call methods on {@link List<DashManifest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashManifests(List<DashManifest>)
         */
        Builder dashManifests(Consumer<DashManifest.Builder>... dashManifests);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * @param encryption
         *        The new value for the Encryption property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(DashEncryption encryption);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * This is a convenience that creates an instance of the {@link DashEncryption.Builder} avoiding the need to
         * create one manually via {@link DashEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link DashEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(DashEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link DashEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(DashEncryption)
         */
        default Builder encryption(Consumer<DashEncryption.Builder> encryption) {
            return encryption(DashEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence
         * Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video
         * segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets
         * during content playback.
         *
         * @param includeEncoderConfigurationInSegments
         *        When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence
         *        Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every
         *        video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for
         *        your assets during content playback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeEncoderConfigurationInSegments(Boolean includeEncoderConfigurationInSegments);

        /**
         * A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         * Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be
         * partitioned into more than one period. If the list contains "ADS", new periods will be created where the
         * Asset contains SCTE-35 ad markers.
         *
         * @param periodTriggers
         *        A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         *        Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will
         *        not be partitioned into more than one period. If the list contains "ADS", new periods will be created
         *        where the Asset contains SCTE-35 ad markers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodTriggersWithStrings(Collection<String> periodTriggers);

        /**
         * A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         * Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be
         * partitioned into more than one period. If the list contains "ADS", new periods will be created where the
         * Asset contains SCTE-35 ad markers.
         *
         * @param periodTriggers
         *        A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         *        Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will
         *        not be partitioned into more than one period. If the list contains "ADS", new periods will be created
         *        where the Asset contains SCTE-35 ad markers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodTriggersWithStrings(String... periodTriggers);

        /**
         * A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         * Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be
         * partitioned into more than one period. If the list contains "ADS", new periods will be created where the
         * Asset contains SCTE-35 ad markers.
         *
         * @param periodTriggers
         *        A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         *        Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will
         *        not be partitioned into more than one period. If the list contains "ADS", new periods will be created
         *        where the Asset contains SCTE-35 ad markers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodTriggers(Collection<PeriodTriggersElement> periodTriggers);

        /**
         * A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         * Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be
         * partitioned into more than one period. If the list contains "ADS", new periods will be created where the
         * Asset contains SCTE-35 ad markers.
         *
         * @param periodTriggers
         *        A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         *        Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will
         *        not be partitioned into more than one period. If the list contains "ADS", new periods will be created
         *        where the Asset contains SCTE-35 ad markers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodTriggers(PeriodTriggersElement... periodTriggers);

        /**
         * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source
         * segment duration.
         *
         * @param segmentDurationSeconds
         *        Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the
         *        source segment duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDurationSeconds(Integer segmentDurationSeconds);

        /**
         * Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to
         * NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When
         * set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When
         * set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
         * 
         * @param segmentTemplateFormat
         *        Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set
         *        to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media
         *        URLs. When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with
         *        $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each
         *        SegmentTemplate, with $Number$ media URLs.
         * @see SegmentTemplateFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentTemplateFormat
         */
        Builder segmentTemplateFormat(String segmentTemplateFormat);

        /**
         * Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to
         * NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When
         * set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When
         * set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
         * 
         * @param segmentTemplateFormat
         *        Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set
         *        to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media
         *        URLs. When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with
         *        $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each
         *        SegmentTemplate, with $Number$ media URLs.
         * @see SegmentTemplateFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentTemplateFormat
         */
        Builder segmentTemplateFormat(SegmentTemplateFormat segmentTemplateFormat);
    }

    static final class BuilderImpl implements Builder {
        private List<DashManifest> dashManifests = DefaultSdkAutoConstructList.getInstance();

        private DashEncryption encryption;

        private Boolean includeEncoderConfigurationInSegments;

        private List<String> periodTriggers = DefaultSdkAutoConstructList.getInstance();

        private Integer segmentDurationSeconds;

        private String segmentTemplateFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(DashPackage model) {
            dashManifests(model.dashManifests);
            encryption(model.encryption);
            includeEncoderConfigurationInSegments(model.includeEncoderConfigurationInSegments);
            periodTriggersWithStrings(model.periodTriggers);
            segmentDurationSeconds(model.segmentDurationSeconds);
            segmentTemplateFormat(model.segmentTemplateFormat);
        }

        public final List<DashManifest.Builder> getDashManifests() {
            List<DashManifest.Builder> result = ___listOfDashManifestCopier.copyToBuilder(this.dashManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dashManifests(Collection<DashManifest> dashManifests) {
            this.dashManifests = ___listOfDashManifestCopier.copy(dashManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(DashManifest... dashManifests) {
            dashManifests(Arrays.asList(dashManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(Consumer<DashManifest.Builder>... dashManifests) {
            dashManifests(Stream.of(dashManifests).map(c -> DashManifest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDashManifests(Collection<DashManifest.BuilderImpl> dashManifests) {
            this.dashManifests = ___listOfDashManifestCopier.copyFromBuilder(dashManifests);
        }

        public final DashEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(DashEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(DashEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Boolean getIncludeEncoderConfigurationInSegments() {
            return includeEncoderConfigurationInSegments;
        }

        @Override
        public final Builder includeEncoderConfigurationInSegments(Boolean includeEncoderConfigurationInSegments) {
            this.includeEncoderConfigurationInSegments = includeEncoderConfigurationInSegments;
            return this;
        }

        public final void setIncludeEncoderConfigurationInSegments(Boolean includeEncoderConfigurationInSegments) {
            this.includeEncoderConfigurationInSegments = includeEncoderConfigurationInSegments;
        }

        public final Collection<String> getPeriodTriggers() {
            if (periodTriggers instanceof SdkAutoConstructList) {
                return null;
            }
            return periodTriggers;
        }

        @Override
        public final Builder periodTriggersWithStrings(Collection<String> periodTriggers) {
            this.periodTriggers = ___listOf__PeriodTriggersElementCopier.copy(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggersWithStrings(String... periodTriggers) {
            periodTriggersWithStrings(Arrays.asList(periodTriggers));
            return this;
        }

        @Override
        public final Builder periodTriggers(Collection<PeriodTriggersElement> periodTriggers) {
            this.periodTriggers = ___listOf__PeriodTriggersElementCopier.copyEnumToString(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggers(PeriodTriggersElement... periodTriggers) {
            periodTriggers(Arrays.asList(periodTriggers));
            return this;
        }

        public final void setPeriodTriggers(Collection<String> periodTriggers) {
            this.periodTriggers = ___listOf__PeriodTriggersElementCopier.copy(periodTriggers);
        }

        public final Integer getSegmentDurationSeconds() {
            return segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final String getSegmentTemplateFormat() {
            return segmentTemplateFormat;
        }

        @Override
        public final Builder segmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
            return this;
        }

        @Override
        public final Builder segmentTemplateFormat(SegmentTemplateFormat segmentTemplateFormat) {
            this.segmentTemplateFormat(segmentTemplateFormat == null ? null : segmentTemplateFormat.toString());
            return this;
        }

        public final void setSegmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
        }

        @Override
        public DashPackage build() {
            return new DashPackage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
