/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPackagingConfigurationsResponse extends MediaPackageVodResponse implements
        ToCopyableBuilder<ListPackagingConfigurationsResponse.Builder, ListPackagingConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPackagingConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<PackagingConfiguration>> PACKAGING_CONFIGURATIONS_FIELD = SdkField
            .<List<PackagingConfiguration>> builder(MarshallingType.LIST)
            .memberName("PackagingConfigurations")
            .getter(getter(ListPackagingConfigurationsResponse::packagingConfigurations))
            .setter(setter(Builder::packagingConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackagingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackagingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PACKAGING_CONFIGURATIONS_FIELD));

    private final String nextToken;

    private final List<PackagingConfiguration> packagingConfigurations;

    private ListPackagingConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.packagingConfigurations = builder.packagingConfigurations;
    }

    /**
     * A token that can be used to resume pagination from the end of the collection.
     * 
     * @return A token that can be used to resume pagination from the end of the collection.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the PackagingConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPackagingConfigurations() {
        return packagingConfigurations != null && !(packagingConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * A list of MediaPackage VOD PackagingConfiguration resources.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPackagingConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of MediaPackage VOD PackagingConfiguration resources.
     */
    public final List<PackagingConfiguration> packagingConfigurations() {
        return packagingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPackagingConfigurations() ? packagingConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackagingConfigurationsResponse)) {
            return false;
        }
        ListPackagingConfigurationsResponse other = (ListPackagingConfigurationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasPackagingConfigurations() == other.hasPackagingConfigurations()
                && Objects.equals(packagingConfigurations(), other.packagingConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPackagingConfigurationsResponse").add("NextToken", nextToken())
                .add("PackagingConfigurations", hasPackagingConfigurations() ? packagingConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PackagingConfigurations":
            return Optional.ofNullable(clazz.cast(packagingConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackagingConfigurationsResponse, T> g) {
        return obj -> g.apply((ListPackagingConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageVodResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPackagingConfigurationsResponse> {
        /**
         * A token that can be used to resume pagination from the end of the collection.
         * 
         * @param nextToken
         *        A token that can be used to resume pagination from the end of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * A list of MediaPackage VOD PackagingConfiguration resources.
         * 
         * @param packagingConfigurations
         *        A list of MediaPackage VOD PackagingConfiguration resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagingConfigurations(Collection<PackagingConfiguration> packagingConfigurations);

        /**
         * A list of MediaPackage VOD PackagingConfiguration resources.
         * 
         * @param packagingConfigurations
         *        A list of MediaPackage VOD PackagingConfiguration resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagingConfigurations(PackagingConfiguration... packagingConfigurations);

        /**
         * A list of MediaPackage VOD PackagingConfiguration resources. This is a convenience that creates an instance
         * of the {@link List<PackagingConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <PackagingConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PackagingConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #packagingConfigurations(List<PackagingConfiguration>)}.
         * 
         * @param packagingConfigurations
         *        a consumer that will call methods on {@link List<PackagingConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packagingConfigurations(List<PackagingConfiguration>)
         */
        Builder packagingConfigurations(Consumer<PackagingConfiguration.Builder>... packagingConfigurations);
    }

    static final class BuilderImpl extends MediaPackageVodResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PackagingConfiguration> packagingConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackagingConfigurationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            packagingConfigurations(model.packagingConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<PackagingConfiguration.Builder> getPackagingConfigurations() {
            List<PackagingConfiguration.Builder> result = ___listOfPackagingConfigurationCopier
                    .copyToBuilder(this.packagingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder packagingConfigurations(Collection<PackagingConfiguration> packagingConfigurations) {
            this.packagingConfigurations = ___listOfPackagingConfigurationCopier.copy(packagingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packagingConfigurations(PackagingConfiguration... packagingConfigurations) {
            packagingConfigurations(Arrays.asList(packagingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packagingConfigurations(Consumer<PackagingConfiguration.Builder>... packagingConfigurations) {
            packagingConfigurations(Stream.of(packagingConfigurations)
                    .map(c -> PackagingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPackagingConfigurations(Collection<PackagingConfiguration.BuilderImpl> packagingConfigurations) {
            this.packagingConfigurations = ___listOfPackagingConfigurationCopier.copyFromBuilder(packagingConfigurations);
        }

        @Override
        public ListPackagingConfigurationsResponse build() {
            return new ListPackagingConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
