/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagevod.model.MssEncryption;
import software.amazon.awssdk.services.mediapackagevod.model.MssManifest;
import software.amazon.awssdk.services.mediapackagevod.model.___listOfMssManifestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MssPackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MssPackage> {
    private static final SdkField<MssEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(MssPackage.getter(MssPackage::encryption)).setter(MssPackage.setter(Builder::encryption)).constructor(MssEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<List<MssManifest>> MSS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MssManifests").getter(MssPackage.getter(MssPackage::mssManifests)).setter(MssPackage.setter(Builder::mssManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mssManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MssManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentDurationSeconds").getter(MssPackage.getter(MssPackage::segmentDurationSeconds)).setter(MssPackage.setter(Builder::segmentDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD, MSS_MANIFESTS_FIELD, SEGMENT_DURATION_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final MssEncryption encryption;
    private final List<MssManifest> mssManifests;
    private final Integer segmentDurationSeconds;

    private MssPackage(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.mssManifests = builder.mssManifests;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
    }

    public final MssEncryption encryption() {
        return this.encryption;
    }

    public final boolean hasMssManifests() {
        return this.mssManifests != null && !(this.mssManifests instanceof SdkAutoConstructList);
    }

    public final List<MssManifest> mssManifests() {
        return this.mssManifests;
    }

    public final Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMssManifests() ? this.mssManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MssPackage)) {
            return false;
        }
        MssPackage other = (MssPackage)obj;
        return Objects.equals(this.encryption(), other.encryption()) && this.hasMssManifests() == other.hasMssManifests() && Objects.equals(this.mssManifests(), other.mssManifests()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"MssPackage").add("Encryption", (Object)this.encryption()).add("MssManifests", this.hasMssManifests() ? this.mssManifests() : null).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "MssManifests": {
                return Optional.ofNullable(clazz.cast(this.mssManifests()));
            }
            case "SegmentDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.segmentDurationSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MssPackage, T> g) {
        return obj -> g.apply((MssPackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MssEncryption encryption;
        private List<MssManifest> mssManifests = DefaultSdkAutoConstructList.getInstance();
        private Integer segmentDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(MssPackage model) {
            this.encryption(model.encryption);
            this.mssManifests(model.mssManifests);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
        }

        public final MssEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(MssEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(MssEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final List<MssManifest.Builder> getMssManifests() {
            List<MssManifest.Builder> result = ___listOfMssManifestCopier.copyToBuilder(this.mssManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder mssManifests(Collection<MssManifest> mssManifests) {
            this.mssManifests = ___listOfMssManifestCopier.copy(mssManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mssManifests(MssManifest ... mssManifests) {
            this.mssManifests(Arrays.asList(mssManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mssManifests(Consumer<MssManifest.Builder> ... mssManifests) {
            this.mssManifests(Stream.of(mssManifests).map(c -> (MssManifest)((MssManifest.Builder)MssManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMssManifests(Collection<MssManifest.BuilderImpl> mssManifests) {
            this.mssManifests = ___listOfMssManifestCopier.copyFromBuilder(mssManifests);
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public MssPackage build() {
            return new MssPackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MssPackage> {
        public Builder encryption(MssEncryption var1);

        default public Builder encryption(Consumer<MssEncryption.Builder> encryption) {
            return this.encryption((MssEncryption)((MssEncryption.Builder)MssEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder mssManifests(Collection<MssManifest> var1);

        public Builder mssManifests(MssManifest ... var1);

        public Builder mssManifests(Consumer<MssManifest.Builder> ... var1);

        public Builder segmentDurationSeconds(Integer var1);
    }
}

