/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackagevod.model.Authorization;
import software.amazon.awssdk.services.mediapackagevod.model.EgressAccessLogs;
import software.amazon.awssdk.services.mediapackagevod.model.MediaPackageVodResponse;
import software.amazon.awssdk.services.mediapackagevod.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePackagingGroupResponse
extends MediaPackageVodResponse
implements ToCopyableBuilder<Builder, UpdatePackagingGroupResponse> {
    private static final SdkField<Integer> APPROXIMATE_ASSET_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ApproximateAssetCount").getter(UpdatePackagingGroupResponse.getter(UpdatePackagingGroupResponse::approximateAssetCount)).setter(UpdatePackagingGroupResponse.setter(Builder::approximateAssetCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateAssetCount").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdatePackagingGroupResponse.getter(UpdatePackagingGroupResponse::arn)).setter(UpdatePackagingGroupResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Authorization> AUTHORIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Authorization").getter(UpdatePackagingGroupResponse.getter(UpdatePackagingGroupResponse::authorization)).setter(UpdatePackagingGroupResponse.setter(Builder::authorization)).constructor(Authorization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorization").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(UpdatePackagingGroupResponse.getter(UpdatePackagingGroupResponse::createdAt)).setter(UpdatePackagingGroupResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpdatePackagingGroupResponse.getter(UpdatePackagingGroupResponse::domainName)).setter(UpdatePackagingGroupResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<EgressAccessLogs> EGRESS_ACCESS_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EgressAccessLogs").getter(UpdatePackagingGroupResponse.getter(UpdatePackagingGroupResponse::egressAccessLogs)).setter(UpdatePackagingGroupResponse.setter(Builder::egressAccessLogs)).constructor(EgressAccessLogs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressAccessLogs").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdatePackagingGroupResponse.getter(UpdatePackagingGroupResponse::id)).setter(UpdatePackagingGroupResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdatePackagingGroupResponse.getter(UpdatePackagingGroupResponse::tags)).setter(UpdatePackagingGroupResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROXIMATE_ASSET_COUNT_FIELD, ARN_FIELD, AUTHORIZATION_FIELD, CREATED_AT_FIELD, DOMAIN_NAME_FIELD, EGRESS_ACCESS_LOGS_FIELD, ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePackagingGroupResponse.memberNameToFieldInitializer();
    private final Integer approximateAssetCount;
    private final String arn;
    private final Authorization authorization;
    private final String createdAt;
    private final String domainName;
    private final EgressAccessLogs egressAccessLogs;
    private final String id;
    private final Map<String, String> tags;

    private UpdatePackagingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.approximateAssetCount = builder.approximateAssetCount;
        this.arn = builder.arn;
        this.authorization = builder.authorization;
        this.createdAt = builder.createdAt;
        this.domainName = builder.domainName;
        this.egressAccessLogs = builder.egressAccessLogs;
        this.id = builder.id;
        this.tags = builder.tags;
    }

    public final Integer approximateAssetCount() {
        return this.approximateAssetCount;
    }

    public final String arn() {
        return this.arn;
    }

    public final Authorization authorization() {
        return this.authorization;
    }

    public final String createdAt() {
        return this.createdAt;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final EgressAccessLogs egressAccessLogs() {
        return this.egressAccessLogs;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateAssetCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorization());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressAccessLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackagingGroupResponse)) {
            return false;
        }
        UpdatePackagingGroupResponse other = (UpdatePackagingGroupResponse)((Object)obj);
        return Objects.equals(this.approximateAssetCount(), other.approximateAssetCount()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.authorization(), other.authorization()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.egressAccessLogs(), other.egressAccessLogs()) && Objects.equals(this.id(), other.id()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePackagingGroupResponse").add("ApproximateAssetCount", (Object)this.approximateAssetCount()).add("Arn", (Object)this.arn()).add("Authorization", (Object)this.authorization()).add("CreatedAt", (Object)this.createdAt()).add("DomainName", (Object)this.domainName()).add("EgressAccessLogs", (Object)this.egressAccessLogs()).add("Id", (Object)this.id()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApproximateAssetCount": {
                return Optional.ofNullable(clazz.cast(this.approximateAssetCount()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Authorization": {
                return Optional.ofNullable(clazz.cast(this.authorization()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "EgressAccessLogs": {
                return Optional.ofNullable(clazz.cast(this.egressAccessLogs()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("approximateAssetCount", APPROXIMATE_ASSET_COUNT_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("authorization", AUTHORIZATION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("egressAccessLogs", EGRESS_ACCESS_LOGS_FIELD);
        map.put("id", ID_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackagingGroupResponse, T> g) {
        return obj -> g.apply((UpdatePackagingGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageVodResponse.BuilderImpl
    implements Builder {
        private Integer approximateAssetCount;
        private String arn;
        private Authorization authorization;
        private String createdAt;
        private String domainName;
        private EgressAccessLogs egressAccessLogs;
        private String id;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackagingGroupResponse model) {
            super(model);
            this.approximateAssetCount(model.approximateAssetCount);
            this.arn(model.arn);
            this.authorization(model.authorization);
            this.createdAt(model.createdAt);
            this.domainName(model.domainName);
            this.egressAccessLogs(model.egressAccessLogs);
            this.id(model.id);
            this.tags(model.tags);
        }

        public final Integer getApproximateAssetCount() {
            return this.approximateAssetCount;
        }

        public final void setApproximateAssetCount(Integer approximateAssetCount) {
            this.approximateAssetCount = approximateAssetCount;
        }

        @Override
        public final Builder approximateAssetCount(Integer approximateAssetCount) {
            this.approximateAssetCount = approximateAssetCount;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Authorization.Builder getAuthorization() {
            return this.authorization != null ? this.authorization.toBuilder() : null;
        }

        public final void setAuthorization(Authorization.BuilderImpl authorization) {
            this.authorization = authorization != null ? authorization.build() : null;
        }

        @Override
        public final Builder authorization(Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final EgressAccessLogs.Builder getEgressAccessLogs() {
            return this.egressAccessLogs != null ? this.egressAccessLogs.toBuilder() : null;
        }

        public final void setEgressAccessLogs(EgressAccessLogs.BuilderImpl egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs != null ? egressAccessLogs.build() : null;
        }

        @Override
        public final Builder egressAccessLogs(EgressAccessLogs egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public UpdatePackagingGroupResponse build() {
            return new UpdatePackagingGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaPackageVodResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePackagingGroupResponse> {
        public Builder approximateAssetCount(Integer var1);

        public Builder arn(String var1);

        public Builder authorization(Authorization var1);

        default public Builder authorization(Consumer<Authorization.Builder> authorization) {
            return this.authorization((Authorization)((Authorization.Builder)Authorization.builder().applyMutation(authorization)).build());
        }

        public Builder createdAt(String var1);

        public Builder domainName(String var1);

        public Builder egressAccessLogs(EgressAccessLogs var1);

        default public Builder egressAccessLogs(Consumer<EgressAccessLogs.Builder> egressAccessLogs) {
            return this.egressAccessLogs((EgressAccessLogs)((EgressAccessLogs.Builder)EgressAccessLogs.builder().applyMutation(egressAccessLogs)).build());
        }

        public Builder id(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

