/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The option to configure log subscription.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigureLogsRequest extends MediaPackageVodRequest implements
        ToCopyableBuilder<ConfigureLogsRequest.Builder, ConfigureLogsRequest> {
    private static final SdkField<EgressAccessLogs> EGRESS_ACCESS_LOGS_FIELD = SdkField
            .<EgressAccessLogs> builder(MarshallingType.SDK_POJO).memberName("EgressAccessLogs")
            .getter(getter(ConfigureLogsRequest::egressAccessLogs)).setter(setter(Builder::egressAccessLogs))
            .constructor(EgressAccessLogs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressAccessLogs").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ConfigureLogsRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_ACCESS_LOGS_FIELD,
            ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final EgressAccessLogs egressAccessLogs;

    private final String id;

    private ConfigureLogsRequest(BuilderImpl builder) {
        super(builder);
        this.egressAccessLogs = builder.egressAccessLogs;
        this.id = builder.id;
    }

    /**
     * Returns the value of the EgressAccessLogs property for this object.
     * 
     * @return The value of the EgressAccessLogs property for this object.
     */
    public final EgressAccessLogs egressAccessLogs() {
        return egressAccessLogs;
    }

    /**
     * The ID of a MediaPackage VOD PackagingGroup resource.
     * 
     * @return The ID of a MediaPackage VOD PackagingGroup resource.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(egressAccessLogs());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureLogsRequest)) {
            return false;
        }
        ConfigureLogsRequest other = (ConfigureLogsRequest) obj;
        return Objects.equals(egressAccessLogs(), other.egressAccessLogs()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigureLogsRequest").add("EgressAccessLogs", egressAccessLogs()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EgressAccessLogs":
            return Optional.ofNullable(clazz.cast(egressAccessLogs()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("egressAccessLogs", EGRESS_ACCESS_LOGS_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigureLogsRequest, T> g) {
        return obj -> g.apply((ConfigureLogsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageVodRequest.Builder, SdkPojo, CopyableBuilder<Builder, ConfigureLogsRequest> {
        /**
         * Sets the value of the EgressAccessLogs property for this object.
         *
         * @param egressAccessLogs
         *        The new value for the EgressAccessLogs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressAccessLogs(EgressAccessLogs egressAccessLogs);

        /**
         * Sets the value of the EgressAccessLogs property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EgressAccessLogs.Builder} avoiding the
         * need to create one manually via {@link EgressAccessLogs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EgressAccessLogs.Builder#build()} is called immediately and its
         * result is passed to {@link #egressAccessLogs(EgressAccessLogs)}.
         * 
         * @param egressAccessLogs
         *        a consumer that will call methods on {@link EgressAccessLogs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressAccessLogs(EgressAccessLogs)
         */
        default Builder egressAccessLogs(Consumer<EgressAccessLogs.Builder> egressAccessLogs) {
            return egressAccessLogs(EgressAccessLogs.builder().applyMutation(egressAccessLogs).build());
        }

        /**
         * The ID of a MediaPackage VOD PackagingGroup resource.
         * 
         * @param id
         *        The ID of a MediaPackage VOD PackagingGroup resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageVodRequest.BuilderImpl implements Builder {
        private EgressAccessLogs egressAccessLogs;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureLogsRequest model) {
            super(model);
            egressAccessLogs(model.egressAccessLogs);
            id(model.id);
        }

        public final EgressAccessLogs.Builder getEgressAccessLogs() {
            return egressAccessLogs != null ? egressAccessLogs.toBuilder() : null;
        }

        public final void setEgressAccessLogs(EgressAccessLogs.BuilderImpl egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs != null ? egressAccessLogs.build() : null;
        }

        @Override
        public final Builder egressAccessLogs(EgressAccessLogs egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfigureLogsRequest build() {
            return new ConfigureLogsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
