/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An HTTP Live Streaming (HLS) packaging configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsPackage implements SdkPojo, Serializable, ToCopyableBuilder<HlsPackage.Builder, HlsPackage> {
    private static final SdkField<HlsEncryption> ENCRYPTION_FIELD = SdkField.<HlsEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(HlsPackage::encryption)).setter(setter(Builder::encryption))
            .constructor(HlsEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<List<HlsManifest>> HLS_MANIFESTS_FIELD = SdkField
            .<List<HlsManifest>> builder(MarshallingType.LIST)
            .memberName("HlsManifests")
            .getter(getter(HlsPackage::hlsManifests))
            .setter(setter(Builder::hlsManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HlsManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(HlsManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INCLUDE_DVB_SUBTITLES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeDvbSubtitles").getter(getter(HlsPackage::includeDvbSubtitles))
            .setter(setter(Builder::includeDvbSubtitles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeDvbSubtitles").build())
            .build();

    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentDurationSeconds").getter(getter(HlsPackage::segmentDurationSeconds))
            .setter(setter(Builder::segmentDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build())
            .build();

    private static final SdkField<Boolean> USE_AUDIO_RENDITION_GROUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseAudioRenditionGroup").getter(getter(HlsPackage::useAudioRenditionGroup))
            .setter(setter(Builder::useAudioRenditionGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useAudioRenditionGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD,
            HLS_MANIFESTS_FIELD, INCLUDE_DVB_SUBTITLES_FIELD, SEGMENT_DURATION_SECONDS_FIELD, USE_AUDIO_RENDITION_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HlsEncryption encryption;

    private final List<HlsManifest> hlsManifests;

    private final Boolean includeDvbSubtitles;

    private final Integer segmentDurationSeconds;

    private final Boolean useAudioRenditionGroup;

    private HlsPackage(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.hlsManifests = builder.hlsManifests;
        this.includeDvbSubtitles = builder.includeDvbSubtitles;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.useAudioRenditionGroup = builder.useAudioRenditionGroup;
    }

    /**
     * Returns the value of the Encryption property for this object.
     * 
     * @return The value of the Encryption property for this object.
     */
    public final HlsEncryption encryption() {
        return encryption;
    }

    /**
     * For responses, this returns true if the service returned a value for the HlsManifests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHlsManifests() {
        return hlsManifests != null && !(hlsManifests instanceof SdkAutoConstructList);
    }

    /**
     * A list of HLS manifest configurations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHlsManifests} method.
     * </p>
     * 
     * @return A list of HLS manifest configurations.
     */
    public final List<HlsManifest> hlsManifests() {
        return hlsManifests;
    }

    /**
     * When enabled, MediaPackage passes through digital video broadcasting (DVB) subtitles into the output.
     * 
     * @return When enabled, MediaPackage passes through digital video broadcasting (DVB) subtitles into the output.
     */
    public final Boolean includeDvbSubtitles() {
        return includeDvbSubtitles;
    }

    /**
     * Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the source
     * fragment duration.
     *
     * @return Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the
     *         source fragment duration.
     */
    public final Integer segmentDurationSeconds() {
        return segmentDurationSeconds;
    }

    /**
     * When enabled, audio streams will be placed in rendition groups in the output.
     * 
     * @return When enabled, audio streams will be placed in rendition groups in the output.
     */
    public final Boolean useAudioRenditionGroup() {
        return useAudioRenditionGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(hasHlsManifests() ? hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(includeDvbSubtitles());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(useAudioRenditionGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsPackage)) {
            return false;
        }
        HlsPackage other = (HlsPackage) obj;
        return Objects.equals(encryption(), other.encryption()) && hasHlsManifests() == other.hasHlsManifests()
                && Objects.equals(hlsManifests(), other.hlsManifests())
                && Objects.equals(includeDvbSubtitles(), other.includeDvbSubtitles())
                && Objects.equals(segmentDurationSeconds(), other.segmentDurationSeconds())
                && Objects.equals(useAudioRenditionGroup(), other.useAudioRenditionGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsPackage").add("Encryption", encryption())
                .add("HlsManifests", hasHlsManifests() ? hlsManifests() : null).add("IncludeDvbSubtitles", includeDvbSubtitles())
                .add("SegmentDurationSeconds", segmentDurationSeconds()).add("UseAudioRenditionGroup", useAudioRenditionGroup())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "HlsManifests":
            return Optional.ofNullable(clazz.cast(hlsManifests()));
        case "IncludeDvbSubtitles":
            return Optional.ofNullable(clazz.cast(includeDvbSubtitles()));
        case "SegmentDurationSeconds":
            return Optional.ofNullable(clazz.cast(segmentDurationSeconds()));
        case "UseAudioRenditionGroup":
            return Optional.ofNullable(clazz.cast(useAudioRenditionGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("encryption", ENCRYPTION_FIELD);
        map.put("hlsManifests", HLS_MANIFESTS_FIELD);
        map.put("includeDvbSubtitles", INCLUDE_DVB_SUBTITLES_FIELD);
        map.put("segmentDurationSeconds", SEGMENT_DURATION_SECONDS_FIELD);
        map.put("useAudioRenditionGroup", USE_AUDIO_RENDITION_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HlsPackage, T> g) {
        return obj -> g.apply((HlsPackage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsPackage> {
        /**
         * Sets the value of the Encryption property for this object.
         *
         * @param encryption
         *        The new value for the Encryption property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(HlsEncryption encryption);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * This is a convenience method that creates an instance of the {@link HlsEncryption.Builder} avoiding the need
         * to create one manually via {@link HlsEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HlsEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(HlsEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link HlsEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(HlsEncryption)
         */
        default Builder encryption(Consumer<HlsEncryption.Builder> encryption) {
            return encryption(HlsEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * A list of HLS manifest configurations.
         * 
         * @param hlsManifests
         *        A list of HLS manifest configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(Collection<HlsManifest> hlsManifests);

        /**
         * A list of HLS manifest configurations.
         * 
         * @param hlsManifests
         *        A list of HLS manifest configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(HlsManifest... hlsManifests);

        /**
         * A list of HLS manifest configurations. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagevod.model.HlsManifest.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediapackagevod.model.HlsManifest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagevod.model.HlsManifest.Builder#build()} is called
         * immediately and its result is passed to {@link #hlsManifests(List<HlsManifest>)}.
         * 
         * @param hlsManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagevod.model.HlsManifest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsManifests(java.util.Collection<HlsManifest>)
         */
        Builder hlsManifests(Consumer<HlsManifest.Builder>... hlsManifests);

        /**
         * When enabled, MediaPackage passes through digital video broadcasting (DVB) subtitles into the output.
         * 
         * @param includeDvbSubtitles
         *        When enabled, MediaPackage passes through digital video broadcasting (DVB) subtitles into the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeDvbSubtitles(Boolean includeDvbSubtitles);

        /**
         * Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the
         * source fragment duration.
         *
         * @param segmentDurationSeconds
         *        Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of
         *        the source fragment duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDurationSeconds(Integer segmentDurationSeconds);

        /**
         * When enabled, audio streams will be placed in rendition groups in the output.
         * 
         * @param useAudioRenditionGroup
         *        When enabled, audio streams will be placed in rendition groups in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useAudioRenditionGroup(Boolean useAudioRenditionGroup);
    }

    static final class BuilderImpl implements Builder {
        private HlsEncryption encryption;

        private List<HlsManifest> hlsManifests = DefaultSdkAutoConstructList.getInstance();

        private Boolean includeDvbSubtitles;

        private Integer segmentDurationSeconds;

        private Boolean useAudioRenditionGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsPackage model) {
            encryption(model.encryption);
            hlsManifests(model.hlsManifests);
            includeDvbSubtitles(model.includeDvbSubtitles);
            segmentDurationSeconds(model.segmentDurationSeconds);
            useAudioRenditionGroup(model.useAudioRenditionGroup);
        }

        public final HlsEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(HlsEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(HlsEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final List<HlsManifest.Builder> getHlsManifests() {
            List<HlsManifest.Builder> result = ___listOfHlsManifestCopier.copyToBuilder(this.hlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHlsManifests(Collection<HlsManifest.BuilderImpl> hlsManifests) {
            this.hlsManifests = ___listOfHlsManifestCopier.copyFromBuilder(hlsManifests);
        }

        @Override
        public final Builder hlsManifests(Collection<HlsManifest> hlsManifests) {
            this.hlsManifests = ___listOfHlsManifestCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(HlsManifest... hlsManifests) {
            hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<HlsManifest.Builder>... hlsManifests) {
            hlsManifests(Stream.of(hlsManifests).map(c -> HlsManifest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIncludeDvbSubtitles() {
            return includeDvbSubtitles;
        }

        public final void setIncludeDvbSubtitles(Boolean includeDvbSubtitles) {
            this.includeDvbSubtitles = includeDvbSubtitles;
        }

        @Override
        public final Builder includeDvbSubtitles(Boolean includeDvbSubtitles) {
            this.includeDvbSubtitles = includeDvbSubtitles;
            return this;
        }

        public final Integer getSegmentDurationSeconds() {
            return segmentDurationSeconds;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final Boolean getUseAudioRenditionGroup() {
            return useAudioRenditionGroup;
        }

        public final void setUseAudioRenditionGroup(Boolean useAudioRenditionGroup) {
            this.useAudioRenditionGroup = useAudioRenditionGroup;
        }

        @Override
        public final Builder useAudioRenditionGroup(Boolean useAudioRenditionGroup) {
            this.useAudioRenditionGroup = useAudioRenditionGroup;
            return this;
        }

        @Override
        public HlsPackage build() {
            return new HlsPackage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
