/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MssPackage implements SdkPojo, Serializable, ToCopyableBuilder<MssPackage.Builder, MssPackage> {
    private static final SdkField<MssEncryption> ENCRYPTION_FIELD = SdkField.<MssEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(MssPackage::encryption)).setter(setter(Builder::encryption))
            .constructor(MssEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<List<MssManifest>> MSS_MANIFESTS_FIELD = SdkField
            .<List<MssManifest>> builder(MarshallingType.LIST)
            .memberName("MssManifests")
            .getter(getter(MssPackage::mssManifests))
            .setter(setter(Builder::mssManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mssManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MssManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(MssManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentDurationSeconds").getter(getter(MssPackage::segmentDurationSeconds))
            .setter(setter(Builder::segmentDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD,
            MSS_MANIFESTS_FIELD, SEGMENT_DURATION_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MssEncryption encryption;

    private final List<MssManifest> mssManifests;

    private final Integer segmentDurationSeconds;

    private MssPackage(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.mssManifests = builder.mssManifests;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
    }

    /**
     * Returns the value of the Encryption property for this object.
     * 
     * @return The value of the Encryption property for this object.
     */
    public final MssEncryption encryption() {
        return encryption;
    }

    /**
     * For responses, this returns true if the service returned a value for the MssManifests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMssManifests() {
        return mssManifests != null && !(mssManifests instanceof SdkAutoConstructList);
    }

    /**
     * A list of MSS manifest configurations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMssManifests} method.
     * </p>
     * 
     * @return A list of MSS manifest configurations.
     */
    public final List<MssManifest> mssManifests() {
        return mssManifests;
    }

    /**
     * The duration (in seconds) of each segment.
     * 
     * @return The duration (in seconds) of each segment.
     */
    public final Integer segmentDurationSeconds() {
        return segmentDurationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(hasMssManifests() ? mssManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(segmentDurationSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MssPackage)) {
            return false;
        }
        MssPackage other = (MssPackage) obj;
        return Objects.equals(encryption(), other.encryption()) && hasMssManifests() == other.hasMssManifests()
                && Objects.equals(mssManifests(), other.mssManifests())
                && Objects.equals(segmentDurationSeconds(), other.segmentDurationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MssPackage").add("Encryption", encryption())
                .add("MssManifests", hasMssManifests() ? mssManifests() : null)
                .add("SegmentDurationSeconds", segmentDurationSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "MssManifests":
            return Optional.ofNullable(clazz.cast(mssManifests()));
        case "SegmentDurationSeconds":
            return Optional.ofNullable(clazz.cast(segmentDurationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("encryption", ENCRYPTION_FIELD);
        map.put("mssManifests", MSS_MANIFESTS_FIELD);
        map.put("segmentDurationSeconds", SEGMENT_DURATION_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MssPackage, T> g) {
        return obj -> g.apply((MssPackage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MssPackage> {
        /**
         * Sets the value of the Encryption property for this object.
         *
         * @param encryption
         *        The new value for the Encryption property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(MssEncryption encryption);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MssEncryption.Builder} avoiding the need
         * to create one manually via {@link MssEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MssEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(MssEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link MssEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(MssEncryption)
         */
        default Builder encryption(Consumer<MssEncryption.Builder> encryption) {
            return encryption(MssEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * A list of MSS manifest configurations.
         * 
         * @param mssManifests
         *        A list of MSS manifest configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mssManifests(Collection<MssManifest> mssManifests);

        /**
         * A list of MSS manifest configurations.
         * 
         * @param mssManifests
         *        A list of MSS manifest configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mssManifests(MssManifest... mssManifests);

        /**
         * A list of MSS manifest configurations. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagevod.model.MssManifest.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediapackagevod.model.MssManifest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagevod.model.MssManifest.Builder#build()} is called
         * immediately and its result is passed to {@link #mssManifests(List<MssManifest>)}.
         * 
         * @param mssManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagevod.model.MssManifest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mssManifests(java.util.Collection<MssManifest>)
         */
        Builder mssManifests(Consumer<MssManifest.Builder>... mssManifests);

        /**
         * The duration (in seconds) of each segment.
         * 
         * @param segmentDurationSeconds
         *        The duration (in seconds) of each segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDurationSeconds(Integer segmentDurationSeconds);
    }

    static final class BuilderImpl implements Builder {
        private MssEncryption encryption;

        private List<MssManifest> mssManifests = DefaultSdkAutoConstructList.getInstance();

        private Integer segmentDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(MssPackage model) {
            encryption(model.encryption);
            mssManifests(model.mssManifests);
            segmentDurationSeconds(model.segmentDurationSeconds);
        }

        public final MssEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(MssEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(MssEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final List<MssManifest.Builder> getMssManifests() {
            List<MssManifest.Builder> result = ___listOfMssManifestCopier.copyToBuilder(this.mssManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMssManifests(Collection<MssManifest.BuilderImpl> mssManifests) {
            this.mssManifests = ___listOfMssManifestCopier.copyFromBuilder(mssManifests);
        }

        @Override
        public final Builder mssManifests(Collection<MssManifest> mssManifests) {
            this.mssManifests = ___listOfMssManifestCopier.copy(mssManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mssManifests(MssManifest... mssManifests) {
            mssManifests(Arrays.asList(mssManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mssManifests(Consumer<MssManifest.Builder>... mssManifests) {
            mssManifests(Stream.of(mssManifests).map(c -> MssManifest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getSegmentDurationSeconds() {
            return segmentDurationSeconds;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        @Override
        public MssPackage build() {
            return new MssPackage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
