/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A MediaPackage VOD PackagingGroup resource configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePackagingGroupRequest extends MediaPackageVodRequest implements
        ToCopyableBuilder<UpdatePackagingGroupRequest.Builder, UpdatePackagingGroupRequest> {
    private static final SdkField<Authorization> AUTHORIZATION_FIELD = SdkField.<Authorization> builder(MarshallingType.SDK_POJO)
            .memberName("Authorization").getter(getter(UpdatePackagingGroupRequest::authorization))
            .setter(setter(Builder::authorization)).constructor(Authorization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorization").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdatePackagingGroupRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AUTHORIZATION_FIELD, ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Authorization authorization;

    private final String id;

    private UpdatePackagingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.authorization = builder.authorization;
        this.id = builder.id;
    }

    /**
     * Returns the value of the Authorization property for this object.
     * 
     * @return The value of the Authorization property for this object.
     */
    public final Authorization authorization() {
        return authorization;
    }

    /**
     * The ID of a MediaPackage VOD PackagingGroup resource.
     * 
     * @return The ID of a MediaPackage VOD PackagingGroup resource.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorization());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackagingGroupRequest)) {
            return false;
        }
        UpdatePackagingGroupRequest other = (UpdatePackagingGroupRequest) obj;
        return Objects.equals(authorization(), other.authorization()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePackagingGroupRequest").add("Authorization", authorization()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Authorization":
            return Optional.ofNullable(clazz.cast(authorization()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authorization", AUTHORIZATION_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackagingGroupRequest, T> g) {
        return obj -> g.apply((UpdatePackagingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageVodRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePackagingGroupRequest> {
        /**
         * Sets the value of the Authorization property for this object.
         *
         * @param authorization
         *        The new value for the Authorization property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorization(Authorization authorization);

        /**
         * Sets the value of the Authorization property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Authorization.Builder} avoiding the need
         * to create one manually via {@link Authorization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Authorization.Builder#build()} is called immediately and its
         * result is passed to {@link #authorization(Authorization)}.
         * 
         * @param authorization
         *        a consumer that will call methods on {@link Authorization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorization(Authorization)
         */
        default Builder authorization(Consumer<Authorization.Builder> authorization) {
            return authorization(Authorization.builder().applyMutation(authorization).build());
        }

        /**
         * The ID of a MediaPackage VOD PackagingGroup resource.
         * 
         * @param id
         *        The ID of a MediaPackage VOD PackagingGroup resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageVodRequest.BuilderImpl implements Builder {
        private Authorization authorization;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackagingGroupRequest model) {
            super(model);
            authorization(model.authorization);
            id(model.id);
        }

        public final Authorization.Builder getAuthorization() {
            return authorization != null ? authorization.toBuilder() : null;
        }

        public final void setAuthorization(Authorization.BuilderImpl authorization) {
            this.authorization = authorization != null ? authorization.build() : null;
        }

        @Override
        public final Builder authorization(Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackagingGroupRequest build() {
            return new UpdatePackagingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
