/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackagevod.model.CmafPackage;
import software.amazon.awssdk.services.mediapackagevod.model.DashPackage;
import software.amazon.awssdk.services.mediapackagevod.model.HlsPackage;
import software.amazon.awssdk.services.mediapackagevod.model.MediaPackageVodResponse;
import software.amazon.awssdk.services.mediapackagevod.model.MssPackage;
import software.amazon.awssdk.services.mediapackagevod.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePackagingConfigurationResponse
extends MediaPackageVodResponse
implements ToCopyableBuilder<Builder, CreatePackagingConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::arn)).setter(CreatePackagingConfigurationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<CmafPackage> CMAF_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CmafPackage").getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::cmafPackage)).setter(CreatePackagingConfigurationResponse.setter(Builder::cmafPackage)).constructor(CmafPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmafPackage").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::createdAt)).setter(CreatePackagingConfigurationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<DashPackage> DASH_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DashPackage").getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::dashPackage)).setter(CreatePackagingConfigurationResponse.setter(Builder::dashPackage)).constructor(DashPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashPackage").build()}).build();
    private static final SdkField<HlsPackage> HLS_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsPackage").getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::hlsPackage)).setter(CreatePackagingConfigurationResponse.setter(Builder::hlsPackage)).constructor(HlsPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsPackage").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::id)).setter(CreatePackagingConfigurationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<MssPackage> MSS_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MssPackage").getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::mssPackage)).setter(CreatePackagingConfigurationResponse.setter(Builder::mssPackage)).constructor(MssPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mssPackage").build()}).build();
    private static final SdkField<String> PACKAGING_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackagingGroupId").getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::packagingGroupId)).setter(CreatePackagingConfigurationResponse.setter(Builder::packagingGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingGroupId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::tags)).setter(CreatePackagingConfigurationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CMAF_PACKAGE_FIELD, CREATED_AT_FIELD, DASH_PACKAGE_FIELD, HLS_PACKAGE_FIELD, ID_FIELD, MSS_PACKAGE_FIELD, PACKAGING_GROUP_ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePackagingConfigurationResponse.memberNameToFieldInitializer();
    private final String arn;
    private final CmafPackage cmafPackage;
    private final String createdAt;
    private final DashPackage dashPackage;
    private final HlsPackage hlsPackage;
    private final String id;
    private final MssPackage mssPackage;
    private final String packagingGroupId;
    private final Map<String, String> tags;

    private CreatePackagingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.cmafPackage = builder.cmafPackage;
        this.createdAt = builder.createdAt;
        this.dashPackage = builder.dashPackage;
        this.hlsPackage = builder.hlsPackage;
        this.id = builder.id;
        this.mssPackage = builder.mssPackage;
        this.packagingGroupId = builder.packagingGroupId;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final CmafPackage cmafPackage() {
        return this.cmafPackage;
    }

    public final String createdAt() {
        return this.createdAt;
    }

    public final DashPackage dashPackage() {
        return this.dashPackage;
    }

    public final HlsPackage hlsPackage() {
        return this.hlsPackage;
    }

    public final String id() {
        return this.id;
    }

    public final MssPackage mssPackage() {
        return this.mssPackage;
    }

    public final String packagingGroupId() {
        return this.packagingGroupId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cmafPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.mssPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.packagingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackagingConfigurationResponse)) {
            return false;
        }
        CreatePackagingConfigurationResponse other = (CreatePackagingConfigurationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.cmafPackage(), other.cmafPackage()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dashPackage(), other.dashPackage()) && Objects.equals(this.hlsPackage(), other.hlsPackage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.mssPackage(), other.mssPackage()) && Objects.equals(this.packagingGroupId(), other.packagingGroupId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePackagingConfigurationResponse").add("Arn", (Object)this.arn()).add("CmafPackage", (Object)this.cmafPackage()).add("CreatedAt", (Object)this.createdAt()).add("DashPackage", (Object)this.dashPackage()).add("HlsPackage", (Object)this.hlsPackage()).add("Id", (Object)this.id()).add("MssPackage", (Object)this.mssPackage()).add("PackagingGroupId", (Object)this.packagingGroupId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CmafPackage": {
                return Optional.ofNullable(clazz.cast(this.cmafPackage()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DashPackage": {
                return Optional.ofNullable(clazz.cast(this.dashPackage()));
            }
            case "HlsPackage": {
                return Optional.ofNullable(clazz.cast(this.hlsPackage()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "MssPackage": {
                return Optional.ofNullable(clazz.cast(this.mssPackage()));
            }
            case "PackagingGroupId": {
                return Optional.ofNullable(clazz.cast(this.packagingGroupId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("cmafPackage", CMAF_PACKAGE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("dashPackage", DASH_PACKAGE_FIELD);
        map.put("hlsPackage", HLS_PACKAGE_FIELD);
        map.put("id", ID_FIELD);
        map.put("mssPackage", MSS_PACKAGE_FIELD);
        map.put("packagingGroupId", PACKAGING_GROUP_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePackagingConfigurationResponse, T> g) {
        return obj -> g.apply((CreatePackagingConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageVodResponse.BuilderImpl
    implements Builder {
        private String arn;
        private CmafPackage cmafPackage;
        private String createdAt;
        private DashPackage dashPackage;
        private HlsPackage hlsPackage;
        private String id;
        private MssPackage mssPackage;
        private String packagingGroupId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackagingConfigurationResponse model) {
            super(model);
            this.arn(model.arn);
            this.cmafPackage(model.cmafPackage);
            this.createdAt(model.createdAt);
            this.dashPackage(model.dashPackage);
            this.hlsPackage(model.hlsPackage);
            this.id(model.id);
            this.mssPackage(model.mssPackage);
            this.packagingGroupId(model.packagingGroupId);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final CmafPackage.Builder getCmafPackage() {
            return this.cmafPackage != null ? this.cmafPackage.toBuilder() : null;
        }

        public final void setCmafPackage(CmafPackage.BuilderImpl cmafPackage) {
            this.cmafPackage = cmafPackage != null ? cmafPackage.build() : null;
        }

        @Override
        public final Builder cmafPackage(CmafPackage cmafPackage) {
            this.cmafPackage = cmafPackage;
            return this;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final DashPackage.Builder getDashPackage() {
            return this.dashPackage != null ? this.dashPackage.toBuilder() : null;
        }

        public final void setDashPackage(DashPackage.BuilderImpl dashPackage) {
            this.dashPackage = dashPackage != null ? dashPackage.build() : null;
        }

        @Override
        public final Builder dashPackage(DashPackage dashPackage) {
            this.dashPackage = dashPackage;
            return this;
        }

        public final HlsPackage.Builder getHlsPackage() {
            return this.hlsPackage != null ? this.hlsPackage.toBuilder() : null;
        }

        public final void setHlsPackage(HlsPackage.BuilderImpl hlsPackage) {
            this.hlsPackage = hlsPackage != null ? hlsPackage.build() : null;
        }

        @Override
        public final Builder hlsPackage(HlsPackage hlsPackage) {
            this.hlsPackage = hlsPackage;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MssPackage.Builder getMssPackage() {
            return this.mssPackage != null ? this.mssPackage.toBuilder() : null;
        }

        public final void setMssPackage(MssPackage.BuilderImpl mssPackage) {
            this.mssPackage = mssPackage != null ? mssPackage.build() : null;
        }

        @Override
        public final Builder mssPackage(MssPackage mssPackage) {
            this.mssPackage = mssPackage;
            return this;
        }

        public final String getPackagingGroupId() {
            return this.packagingGroupId;
        }

        public final void setPackagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
        }

        @Override
        public final Builder packagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public CreatePackagingConfigurationResponse build() {
            return new CreatePackagingConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaPackageVodResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePackagingConfigurationResponse> {
        public Builder arn(String var1);

        public Builder cmafPackage(CmafPackage var1);

        default public Builder cmafPackage(Consumer<CmafPackage.Builder> cmafPackage) {
            return this.cmafPackage((CmafPackage)((CmafPackage.Builder)CmafPackage.builder().applyMutation(cmafPackage)).build());
        }

        public Builder createdAt(String var1);

        public Builder dashPackage(DashPackage var1);

        default public Builder dashPackage(Consumer<DashPackage.Builder> dashPackage) {
            return this.dashPackage((DashPackage)((DashPackage.Builder)DashPackage.builder().applyMutation(dashPackage)).build());
        }

        public Builder hlsPackage(HlsPackage var1);

        default public Builder hlsPackage(Consumer<HlsPackage.Builder> hlsPackage) {
            return this.hlsPackage((HlsPackage)((HlsPackage.Builder)HlsPackage.builder().applyMutation(hlsPackage)).build());
        }

        public Builder id(String var1);

        public Builder mssPackage(MssPackage var1);

        default public Builder mssPackage(Consumer<MssPackage.Builder> mssPackage) {
            return this.mssPackage((MssPackage)((MssPackage.Builder)MssPackage.builder().applyMutation(mssPackage)).build());
        }

        public Builder packagingGroupId(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

