/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMetricPolicyRequest extends MediaStoreRequest implements
        ToCopyableBuilder<PutMetricPolicyRequest.Builder, PutMetricPolicyRequest> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerName").getter(getter(PutMetricPolicyRequest::containerName))
            .setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()).build();

    private static final SdkField<MetricPolicy> METRIC_POLICY_FIELD = SdkField.<MetricPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("MetricPolicy").getter(getter(PutMetricPolicyRequest::metricPolicy))
            .setter(setter(Builder::metricPolicy)).constructor(MetricPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD,
            METRIC_POLICY_FIELD));

    private final String containerName;

    private final MetricPolicy metricPolicy;

    private PutMetricPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.containerName = builder.containerName;
        this.metricPolicy = builder.metricPolicy;
    }

    /**
     * <p>
     * The name of the container that you want to add the metric policy to.
     * </p>
     * 
     * @return The name of the container that you want to add the metric policy to.
     */
    public final String containerName() {
        return containerName;
    }

    /**
     * <p>
     * The metric policy that you want to associate with the container. In the policy, you must indicate whether you
     * want MediaStore to send container-level metrics. You can also include up to five rules to define groups of
     * objects that you want MediaStore to send object-level metrics for. If you include rules in the policy, construct
     * each rule with both of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An object group that defines which objects to include in the group. The definition can be a path or a file name,
     * but it can't have more than 900 characters. Valid characters are: a-z, A-Z, 0-9, _ (underscore), = (equal), :
     * (colon), . (period), - (hyphen), ~ (tilde), / (forward slash), and * (asterisk). Wildcards (*) are acceptable.
     * </p>
     * </li>
     * <li>
     * <p>
     * An object group name that allows you to refer to the object group. The name can't have more than 30 characters.
     * Valid characters are: a-z, A-Z, 0-9, and _ (underscore).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The metric policy that you want to associate with the container. In the policy, you must indicate whether
     *         you want MediaStore to send container-level metrics. You can also include up to five rules to define
     *         groups of objects that you want MediaStore to send object-level metrics for. If you include rules in the
     *         policy, construct each rule with both of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         An object group that defines which objects to include in the group. The definition can be a path or a
     *         file name, but it can't have more than 900 characters. Valid characters are: a-z, A-Z, 0-9, _
     *         (underscore), = (equal), : (colon), . (period), - (hyphen), ~ (tilde), / (forward slash), and *
     *         (asterisk). Wildcards (*) are acceptable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An object group name that allows you to refer to the object group. The name can't have more than 30
     *         characters. Valid characters are: a-z, A-Z, 0-9, and _ (underscore).
     *         </p>
     *         </li>
     */
    public final MetricPolicy metricPolicy() {
        return metricPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        hashCode = 31 * hashCode + Objects.hashCode(metricPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricPolicyRequest)) {
            return false;
        }
        PutMetricPolicyRequest other = (PutMetricPolicyRequest) obj;
        return Objects.equals(containerName(), other.containerName()) && Objects.equals(metricPolicy(), other.metricPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutMetricPolicyRequest").add("ContainerName", containerName())
                .add("MetricPolicy", metricPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        case "MetricPolicy":
            return Optional.ofNullable(clazz.cast(metricPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMetricPolicyRequest, T> g) {
        return obj -> g.apply((PutMetricPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaStoreRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutMetricPolicyRequest> {
        /**
         * <p>
         * The name of the container that you want to add the metric policy to.
         * </p>
         * 
         * @param containerName
         *        The name of the container that you want to add the metric policy to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);

        /**
         * <p>
         * The metric policy that you want to associate with the container. In the policy, you must indicate whether you
         * want MediaStore to send container-level metrics. You can also include up to five rules to define groups of
         * objects that you want MediaStore to send object-level metrics for. If you include rules in the policy,
         * construct each rule with both of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An object group that defines which objects to include in the group. The definition can be a path or a file
         * name, but it can't have more than 900 characters. Valid characters are: a-z, A-Z, 0-9, _ (underscore), =
         * (equal), : (colon), . (period), - (hyphen), ~ (tilde), / (forward slash), and * (asterisk). Wildcards (*) are
         * acceptable.
         * </p>
         * </li>
         * <li>
         * <p>
         * An object group name that allows you to refer to the object group. The name can't have more than 30
         * characters. Valid characters are: a-z, A-Z, 0-9, and _ (underscore).
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricPolicy
         *        The metric policy that you want to associate with the container. In the policy, you must indicate
         *        whether you want MediaStore to send container-level metrics. You can also include up to five rules to
         *        define groups of objects that you want MediaStore to send object-level metrics for. If you include
         *        rules in the policy, construct each rule with both of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        An object group that defines which objects to include in the group. The definition can be a path or a
         *        file name, but it can't have more than 900 characters. Valid characters are: a-z, A-Z, 0-9, _
         *        (underscore), = (equal), : (colon), . (period), - (hyphen), ~ (tilde), / (forward slash), and *
         *        (asterisk). Wildcards (*) are acceptable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An object group name that allows you to refer to the object group. The name can't have more than 30
         *        characters. Valid characters are: a-z, A-Z, 0-9, and _ (underscore).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricPolicy(MetricPolicy metricPolicy);

        /**
         * <p>
         * The metric policy that you want to associate with the container. In the policy, you must indicate whether you
         * want MediaStore to send container-level metrics. You can also include up to five rules to define groups of
         * objects that you want MediaStore to send object-level metrics for. If you include rules in the policy,
         * construct each rule with both of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An object group that defines which objects to include in the group. The definition can be a path or a file
         * name, but it can't have more than 900 characters. Valid characters are: a-z, A-Z, 0-9, _ (underscore), =
         * (equal), : (colon), . (period), - (hyphen), ~ (tilde), / (forward slash), and * (asterisk). Wildcards (*) are
         * acceptable.
         * </p>
         * </li>
         * <li>
         * <p>
         * An object group name that allows you to refer to the object group. The name can't have more than 30
         * characters. Valid characters are: a-z, A-Z, 0-9, and _ (underscore).
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link MetricPolicy.Builder} avoiding the need
         * to create one manually via {@link MetricPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #metricPolicy(MetricPolicy)}.
         * 
         * @param metricPolicy
         *        a consumer that will call methods on {@link MetricPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricPolicy(MetricPolicy)
         */
        default Builder metricPolicy(Consumer<MetricPolicy.Builder> metricPolicy) {
            return metricPolicy(MetricPolicy.builder().applyMutation(metricPolicy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaStoreRequest.BuilderImpl implements Builder {
        private String containerName;

        private MetricPolicy metricPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricPolicyRequest model) {
            super(model);
            containerName(model.containerName);
            metricPolicy(model.metricPolicy);
        }

        public final String getContainerName() {
            return containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final MetricPolicy.Builder getMetricPolicy() {
            return metricPolicy != null ? metricPolicy.toBuilder() : null;
        }

        public final void setMetricPolicy(MetricPolicy.BuilderImpl metricPolicy) {
            this.metricPolicy = metricPolicy != null ? metricPolicy.build() : null;
        }

        @Override
        public final Builder metricPolicy(MetricPolicy metricPolicy) {
            this.metricPolicy = metricPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetricPolicyRequest build() {
            return new PutMetricPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
