/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastore.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This section describes operations that you can perform on an AWS Elemental MediaStore container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Container implements SdkPojo, Serializable, ToCopyableBuilder<Container.Builder, Container> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(Container::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Container::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(Container::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Container::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Container::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Boolean> ACCESS_LOGGING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AccessLoggingEnabled").getter(getter(Container::accessLoggingEnabled))
            .setter(setter(Builder::accessLoggingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLoggingEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD,
            CREATION_TIME_FIELD, ARN_FIELD, NAME_FIELD, STATUS_FIELD, ACCESS_LOGGING_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endpoint;

    private final Instant creationTime;

    private final String arn;

    private final String name;

    private final String status;

    private final Boolean accessLoggingEnabled;

    private Container(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.creationTime = builder.creationTime;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.accessLoggingEnabled = builder.accessLoggingEnabled;
    }

    /**
     * <p>
     * The DNS endpoint of the container. Use the endpoint to identify the specific container when sending requests to
     * the data plane. The service assigns this value when the container is created. Once the value has been assigned,
     * it does not change.
     * </p>
     * 
     * @return The DNS endpoint of the container. Use the endpoint to identify the specific container when sending
     *         requests to the data plane. The service assigns this value when the container is created. Once the value
     *         has been assigned, it does not change.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Unix timestamp.
     * </p>
     * 
     * @return Unix timestamp.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the container. The ARN has the following format:
     * </p>
     * <p>
     * arn:aws:&lt;region&gt;:&lt;account that owns this container&gt;:container/&lt;name of container&gt;
     * </p>
     * <p>
     * For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the container. The ARN has the following format:</p>
     *         <p>
     *         arn:aws:&lt;region&gt;:&lt;account that owns this container&gt;:container/&lt;name of container&gt;
     *         </p>
     *         <p>
     *         For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the container.
     * </p>
     * 
     * @return The name of the container.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of container creation or deletion. The status is one of the following: <code>CREATING</code>,
     * <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is
     * <code>CREATING</code>. When the endpoint is available, the status changes to <code>ACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContainerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of container creation or deletion. The status is one of the following: <code>CREATING</code>,
     *         <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is
     *         <code>CREATING</code>. When the endpoint is available, the status changes to <code>ACTIVE</code>.
     * @see ContainerStatus
     */
    public final ContainerStatus status() {
        return ContainerStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of container creation or deletion. The status is one of the following: <code>CREATING</code>,
     * <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is
     * <code>CREATING</code>. When the endpoint is available, the status changes to <code>ACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContainerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of container creation or deletion. The status is one of the following: <code>CREATING</code>,
     *         <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is
     *         <code>CREATING</code>. When the endpoint is available, the status changes to <code>ACTIVE</code>.
     * @see ContainerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The state of access logging on the container. This value is <code>false</code> by default, indicating that AWS
     * Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the
     * container, MediaStore changes this value to <code>true</code>, indicating that the service delivers access logs
     * for objects stored in that container to CloudWatch Logs.
     * </p>
     * 
     * @return The state of access logging on the container. This value is <code>false</code> by default, indicating
     *         that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access
     *         logging on the container, MediaStore changes this value to <code>true</code>, indicating that the service
     *         delivers access logs for objects stored in that container to CloudWatch Logs.
     */
    public final Boolean accessLoggingEnabled() {
        return accessLoggingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accessLoggingEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container) obj;
        return Objects.equals(endpoint(), other.endpoint()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(accessLoggingEnabled(), other.accessLoggingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Container").add("Endpoint", endpoint()).add("CreationTime", creationTime()).add("ARN", arn())
                .add("Name", name()).add("Status", statusAsString()).add("AccessLoggingEnabled", accessLoggingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AccessLoggingEnabled":
            return Optional.ofNullable(clazz.cast(accessLoggingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Endpoint", ENDPOINT_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AccessLoggingEnabled", ACCESS_LOGGING_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Container, T> g) {
        return obj -> g.apply((Container) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Container> {
        /**
         * <p>
         * The DNS endpoint of the container. Use the endpoint to identify the specific container when sending requests
         * to the data plane. The service assigns this value when the container is created. Once the value has been
         * assigned, it does not change.
         * </p>
         * 
         * @param endpoint
         *        The DNS endpoint of the container. Use the endpoint to identify the specific container when sending
         *        requests to the data plane. The service assigns this value when the container is created. Once the
         *        value has been assigned, it does not change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * Unix timestamp.
         * </p>
         * 
         * @param creationTime
         *        Unix timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the container. The ARN has the following format:
         * </p>
         * <p>
         * arn:aws:&lt;region&gt;:&lt;account that owns this container&gt;:container/&lt;name of container&gt;
         * </p>
         * <p>
         * For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the container. The ARN has the following format:</p>
         *        <p>
         *        arn:aws:&lt;region&gt;:&lt;account that owns this container&gt;:container/&lt;name of container&gt;
         *        </p>
         *        <p>
         *        For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the container.
         * </p>
         * 
         * @param name
         *        The name of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of container creation or deletion. The status is one of the following: <code>CREATING</code>,
         * <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is
         * <code>CREATING</code>. When the endpoint is available, the status changes to <code>ACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The status of container creation or deletion. The status is one of the following:
         *        <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating
         *        the container, the status is <code>CREATING</code>. When the endpoint is available, the status changes
         *        to <code>ACTIVE</code>.
         * @see ContainerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of container creation or deletion. The status is one of the following: <code>CREATING</code>,
         * <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is
         * <code>CREATING</code>. When the endpoint is available, the status changes to <code>ACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The status of container creation or deletion. The status is one of the following:
         *        <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating
         *        the container, the status is <code>CREATING</code>. When the endpoint is available, the status changes
         *        to <code>ACTIVE</code>.
         * @see ContainerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerStatus
         */
        Builder status(ContainerStatus status);

        /**
         * <p>
         * The state of access logging on the container. This value is <code>false</code> by default, indicating that
         * AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging
         * on the container, MediaStore changes this value to <code>true</code>, indicating that the service delivers
         * access logs for objects stored in that container to CloudWatch Logs.
         * </p>
         * 
         * @param accessLoggingEnabled
         *        The state of access logging on the container. This value is <code>false</code> by default, indicating
         *        that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable
         *        access logging on the container, MediaStore changes this value to <code>true</code>, indicating that
         *        the service delivers access logs for objects stored in that container to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLoggingEnabled(Boolean accessLoggingEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String endpoint;

        private Instant creationTime;

        private String arn;

        private String name;

        private String status;

        private Boolean accessLoggingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(Container model) {
            endpoint(model.endpoint);
            creationTime(model.creationTime);
            arn(model.arn);
            name(model.name);
            status(model.status);
            accessLoggingEnabled(model.accessLoggingEnabled);
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContainerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getAccessLoggingEnabled() {
            return accessLoggingEnabled;
        }

        public final void setAccessLoggingEnabled(Boolean accessLoggingEnabled) {
            this.accessLoggingEnabled = accessLoggingEnabled;
        }

        @Override
        public final Builder accessLoggingEnabled(Boolean accessLoggingEnabled) {
            this.accessLoggingEnabled = accessLoggingEnabled;
            return this;
        }

        @Override
        public Container build() {
            return new Container(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
