/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCorsPolicyResponse extends MediaStoreResponse implements
        ToCopyableBuilder<GetCorsPolicyResponse.Builder, GetCorsPolicyResponse> {
    private static final SdkField<List<CorsRule>> CORS_POLICY_FIELD = SdkField
            .<List<CorsRule>> builder(MarshallingType.LIST)
            .memberName("CorsPolicy")
            .getter(getter(GetCorsPolicyResponse::corsPolicy))
            .setter(setter(Builder::corsPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CorsPolicy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CorsRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CorsRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORS_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CorsRule> corsPolicy;

    private GetCorsPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.corsPolicy = builder.corsPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the CorsPolicy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCorsPolicy() {
        return corsPolicy != null && !(corsPolicy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CORS policy assigned to the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCorsPolicy} method.
     * </p>
     * 
     * @return The CORS policy assigned to the container.
     */
    public final List<CorsRule> corsPolicy() {
        return corsPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCorsPolicy() ? corsPolicy() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCorsPolicyResponse)) {
            return false;
        }
        GetCorsPolicyResponse other = (GetCorsPolicyResponse) obj;
        return hasCorsPolicy() == other.hasCorsPolicy() && Objects.equals(corsPolicy(), other.corsPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCorsPolicyResponse").add("CorsPolicy", hasCorsPolicy() ? corsPolicy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CorsPolicy":
            return Optional.ofNullable(clazz.cast(corsPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CorsPolicy", CORS_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCorsPolicyResponse, T> g) {
        return obj -> g.apply((GetCorsPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaStoreResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCorsPolicyResponse> {
        /**
         * <p>
         * The CORS policy assigned to the container.
         * </p>
         * 
         * @param corsPolicy
         *        The CORS policy assigned to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder corsPolicy(Collection<CorsRule> corsPolicy);

        /**
         * <p>
         * The CORS policy assigned to the container.
         * </p>
         * 
         * @param corsPolicy
         *        The CORS policy assigned to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder corsPolicy(CorsRule... corsPolicy);

        /**
         * <p>
         * The CORS policy assigned to the container.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediastore.model.CorsRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mediastore.model.CorsRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediastore.model.CorsRule.Builder#build()} is called immediately and
         * its result is passed to {@link #corsPolicy(List<CorsRule>)}.
         * 
         * @param corsPolicy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediastore.model.CorsRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #corsPolicy(java.util.Collection<CorsRule>)
         */
        Builder corsPolicy(Consumer<CorsRule.Builder>... corsPolicy);
    }

    static final class BuilderImpl extends MediaStoreResponse.BuilderImpl implements Builder {
        private List<CorsRule> corsPolicy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCorsPolicyResponse model) {
            super(model);
            corsPolicy(model.corsPolicy);
        }

        public final List<CorsRule.Builder> getCorsPolicy() {
            List<CorsRule.Builder> result = CorsPolicyCopier.copyToBuilder(this.corsPolicy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCorsPolicy(Collection<CorsRule.BuilderImpl> corsPolicy) {
            this.corsPolicy = CorsPolicyCopier.copyFromBuilder(corsPolicy);
        }

        @Override
        public final Builder corsPolicy(Collection<CorsRule> corsPolicy) {
            this.corsPolicy = CorsPolicyCopier.copy(corsPolicy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder corsPolicy(CorsRule... corsPolicy) {
            corsPolicy(Arrays.asList(corsPolicy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder corsPolicy(Consumer<CorsRule.Builder>... corsPolicy) {
            corsPolicy(Stream.of(corsPolicy).map(c -> CorsRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetCorsPolicyResponse build() {
            return new GetCorsPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
