/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A setting that enables metrics at the object level. Each rule contains an object group and an object group name. If
 * the policy includes the MetricPolicyRules parameter, you must include at least one rule. Each metric policy can
 * include up to five rules by default. You can also <a
 * href="https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas">request a
 * quota increase</a> to allow up to 300 rules per policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricPolicyRule implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricPolicyRule.Builder, MetricPolicyRule> {
    private static final SdkField<String> OBJECT_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectGroup").getter(getter(MetricPolicyRule::objectGroup)).setter(setter(Builder::objectGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectGroup").build()).build();

    private static final SdkField<String> OBJECT_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectGroupName").getter(getter(MetricPolicyRule::objectGroupName))
            .setter(setter(Builder::objectGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_GROUP_FIELD,
            OBJECT_GROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String objectGroup;

    private final String objectGroupName;

    private MetricPolicyRule(BuilderImpl builder) {
        this.objectGroup = builder.objectGroup;
        this.objectGroupName = builder.objectGroupName;
    }

    /**
     * <p>
     * A path or file name that defines which objects to include in the group. Wildcards (*) are acceptable.
     * </p>
     * 
     * @return A path or file name that defines which objects to include in the group. Wildcards (*) are acceptable.
     */
    public final String objectGroup() {
        return objectGroup;
    }

    /**
     * <p>
     * A name that allows you to refer to the object group.
     * </p>
     * 
     * @return A name that allows you to refer to the object group.
     */
    public final String objectGroupName() {
        return objectGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectGroup());
        hashCode = 31 * hashCode + Objects.hashCode(objectGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricPolicyRule)) {
            return false;
        }
        MetricPolicyRule other = (MetricPolicyRule) obj;
        return Objects.equals(objectGroup(), other.objectGroup()) && Objects.equals(objectGroupName(), other.objectGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricPolicyRule").add("ObjectGroup", objectGroup()).add("ObjectGroupName", objectGroupName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectGroup":
            return Optional.ofNullable(clazz.cast(objectGroup()));
        case "ObjectGroupName":
            return Optional.ofNullable(clazz.cast(objectGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ObjectGroup", OBJECT_GROUP_FIELD);
        map.put("ObjectGroupName", OBJECT_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricPolicyRule, T> g) {
        return obj -> g.apply((MetricPolicyRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricPolicyRule> {
        /**
         * <p>
         * A path or file name that defines which objects to include in the group. Wildcards (*) are acceptable.
         * </p>
         * 
         * @param objectGroup
         *        A path or file name that defines which objects to include in the group. Wildcards (*) are acceptable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectGroup(String objectGroup);

        /**
         * <p>
         * A name that allows you to refer to the object group.
         * </p>
         * 
         * @param objectGroupName
         *        A name that allows you to refer to the object group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectGroupName(String objectGroupName);
    }

    static final class BuilderImpl implements Builder {
        private String objectGroup;

        private String objectGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricPolicyRule model) {
            objectGroup(model.objectGroup);
            objectGroupName(model.objectGroupName);
        }

        public final String getObjectGroup() {
            return objectGroup;
        }

        public final void setObjectGroup(String objectGroup) {
            this.objectGroup = objectGroup;
        }

        @Override
        public final Builder objectGroup(String objectGroup) {
            this.objectGroup = objectGroup;
            return this;
        }

        public final String getObjectGroupName() {
            return objectGroupName;
        }

        public final void setObjectGroupName(String objectGroupName) {
            this.objectGroupName = objectGroupName;
        }

        @Override
        public final Builder objectGroupName(String objectGroupName) {
            this.objectGroupName = objectGroupName;
            return this;
        }

        @Override
        public MetricPolicyRule build() {
            return new MetricPolicyRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
