/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics;
import software.amazon.awssdk.services.mediastore.model.MetricPolicyRule;
import software.amazon.awssdk.services.mediastore.model.MetricPolicyRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricPolicy> {
    private static final SdkField<String> CONTAINER_LEVEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerLevelMetrics").getter(MetricPolicy.getter(MetricPolicy::containerLevelMetricsAsString)).setter(MetricPolicy.setter(Builder::containerLevelMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerLevelMetrics").build()}).build();
    private static final SdkField<List<MetricPolicyRule>> METRIC_POLICY_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricPolicyRules").getter(MetricPolicy.getter(MetricPolicy::metricPolicyRules)).setter(MetricPolicy.setter(Builder::metricPolicyRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricPolicyRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricPolicyRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_LEVEL_METRICS_FIELD, METRIC_POLICY_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String containerLevelMetrics;
    private final List<MetricPolicyRule> metricPolicyRules;

    private MetricPolicy(BuilderImpl builder) {
        this.containerLevelMetrics = builder.containerLevelMetrics;
        this.metricPolicyRules = builder.metricPolicyRules;
    }

    public final ContainerLevelMetrics containerLevelMetrics() {
        return ContainerLevelMetrics.fromValue(this.containerLevelMetrics);
    }

    public final String containerLevelMetricsAsString() {
        return this.containerLevelMetrics;
    }

    public final boolean hasMetricPolicyRules() {
        return this.metricPolicyRules != null && !(this.metricPolicyRules instanceof SdkAutoConstructList);
    }

    public final List<MetricPolicyRule> metricPolicyRules() {
        return this.metricPolicyRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerLevelMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricPolicyRules() ? this.metricPolicyRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricPolicy)) {
            return false;
        }
        MetricPolicy other = (MetricPolicy)obj;
        return Objects.equals(this.containerLevelMetricsAsString(), other.containerLevelMetricsAsString()) && this.hasMetricPolicyRules() == other.hasMetricPolicyRules() && Objects.equals(this.metricPolicyRules(), other.metricPolicyRules());
    }

    public final String toString() {
        return ToString.builder((String)"MetricPolicy").add("ContainerLevelMetrics", (Object)this.containerLevelMetricsAsString()).add("MetricPolicyRules", this.hasMetricPolicyRules() ? this.metricPolicyRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerLevelMetrics": {
                return Optional.ofNullable(clazz.cast(this.containerLevelMetricsAsString()));
            }
            case "MetricPolicyRules": {
                return Optional.ofNullable(clazz.cast(this.metricPolicyRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContainerLevelMetrics", CONTAINER_LEVEL_METRICS_FIELD);
        map.put("MetricPolicyRules", METRIC_POLICY_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricPolicy, T> g) {
        return obj -> g.apply((MetricPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerLevelMetrics;
        private List<MetricPolicyRule> metricPolicyRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricPolicy model) {
            this.containerLevelMetrics(model.containerLevelMetrics);
            this.metricPolicyRules(model.metricPolicyRules);
        }

        public final String getContainerLevelMetrics() {
            return this.containerLevelMetrics;
        }

        public final void setContainerLevelMetrics(String containerLevelMetrics) {
            this.containerLevelMetrics = containerLevelMetrics;
        }

        @Override
        public final Builder containerLevelMetrics(String containerLevelMetrics) {
            this.containerLevelMetrics = containerLevelMetrics;
            return this;
        }

        @Override
        public final Builder containerLevelMetrics(ContainerLevelMetrics containerLevelMetrics) {
            this.containerLevelMetrics(containerLevelMetrics == null ? null : containerLevelMetrics.toString());
            return this;
        }

        public final List<MetricPolicyRule.Builder> getMetricPolicyRules() {
            List<MetricPolicyRule.Builder> result = MetricPolicyRulesCopier.copyToBuilder(this.metricPolicyRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricPolicyRules(Collection<MetricPolicyRule.BuilderImpl> metricPolicyRules) {
            this.metricPolicyRules = MetricPolicyRulesCopier.copyFromBuilder(metricPolicyRules);
        }

        @Override
        public final Builder metricPolicyRules(Collection<MetricPolicyRule> metricPolicyRules) {
            this.metricPolicyRules = MetricPolicyRulesCopier.copy(metricPolicyRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricPolicyRules(MetricPolicyRule ... metricPolicyRules) {
            this.metricPolicyRules(Arrays.asList(metricPolicyRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricPolicyRules(Consumer<MetricPolicyRule.Builder> ... metricPolicyRules) {
            this.metricPolicyRules(Stream.of(metricPolicyRules).map(c -> (MetricPolicyRule)((MetricPolicyRule.Builder)MetricPolicyRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MetricPolicy build() {
            return new MetricPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricPolicy> {
        public Builder containerLevelMetrics(String var1);

        public Builder containerLevelMetrics(ContainerLevelMetrics var1);

        public Builder metricPolicyRules(Collection<MetricPolicyRule> var1);

        public Builder metricPolicyRules(MetricPolicyRule ... var1);

        public Builder metricPolicyRules(Consumer<MetricPolicyRule.Builder> ... var1);
    }
}

