/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastoredata.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeObjectRequest extends MediaStoreDataRequest implements
        ToCopyableBuilder<DescribeObjectRequest.Builder, DescribeObjectRequest> {
    private final String path;

    private DescribeObjectRequest(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
    }

    /**
     * <p>
     * The path (including the file name) where the object is stored in the container. Format: &lt;folder
     * name&gt;/&lt;folder name&gt;/&lt;file name&gt;
     * </p>
     * 
     * @return The path (including the file name) where the object is stored in the container. Format: &lt;folder
     *         name&gt;/&lt;folder name&gt;/&lt;file name&gt;
     */
    public String path() {
        return path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeObjectRequest)) {
            return false;
        }
        DescribeObjectRequest other = (DescribeObjectRequest) obj;
        return Objects.equals(path(), other.path());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeObjectRequest").add("Path", path()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MediaStoreDataRequest.Builder, CopyableBuilder<Builder, DescribeObjectRequest> {
        /**
         * <p>
         * The path (including the file name) where the object is stored in the container. Format: &lt;folder
         * name&gt;/&lt;folder name&gt;/&lt;file name&gt;
         * </p>
         * 
         * @param path
         *        The path (including the file name) where the object is stored in the container. Format: &lt;folder
         *        name&gt;/&lt;folder name&gt;/&lt;file name&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaStoreDataRequest.BuilderImpl implements Builder {
        private String path;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeObjectRequest model) {
            super(model);
            path(model.path);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeObjectRequest build() {
            return new DescribeObjectRequest(this);
        }
    }
}
