/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastoredata.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.mediastoredata.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeObjectResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeObjectResponseUnmarshaller implements Unmarshaller<DescribeObjectResponse, JsonUnmarshallerContext> {

    public DescribeObjectResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeObjectResponse.Builder describeObjectResponseBuilder = DescribeObjectResponse.builder();

        if (context.isStartOfDocument()) {
            if (context.getHeader("ETag") != null) {
                context.setCurrentHeader("ETag");
                describeObjectResponseBuilder.eTag(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("Content-Type") != null) {
                context.setCurrentHeader("Content-Type");
                describeObjectResponseBuilder.contentType(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("Content-Length") != null) {
                context.setCurrentHeader("Content-Length");
                describeObjectResponseBuilder.contentLength(context.getUnmarshaller(Long.class).unmarshall(context));
            }
            if (context.getHeader("Cache-Control") != null) {
                context.setCurrentHeader("Cache-Control");
                describeObjectResponseBuilder.cacheControl(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("Last-Modified") != null) {
                context.setCurrentHeader("Last-Modified");
                describeObjectResponseBuilder.lastModified(software.amazon.awssdk.utils.DateUtils.parseRfc1123Date(context
                        .readText()));
            }
        }

        return describeObjectResponseBuilder.build();
    }

    private static final DescribeObjectResponseUnmarshaller INSTANCE = new DescribeObjectResponseUnmarshaller();

    public static DescribeObjectResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
