/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastoredata.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.mediastoredata.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetObjectResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetObjectResponseUnmarshaller implements Unmarshaller<GetObjectResponse, JsonUnmarshallerContext> {

    public GetObjectResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetObjectResponse.Builder getObjectResponseBuilder = GetObjectResponse.builder();

        if (context.isStartOfDocument()) {
            if (context.getHeader("Cache-Control") != null) {
                context.setCurrentHeader("Cache-Control");
                getObjectResponseBuilder.cacheControl(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("Content-Range") != null) {
                context.setCurrentHeader("Content-Range");
                getObjectResponseBuilder.contentRange(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("Content-Length") != null) {
                context.setCurrentHeader("Content-Length");
                getObjectResponseBuilder.contentLength(context.getUnmarshaller(Long.class).unmarshall(context));
            }
            if (context.getHeader("Content-Type") != null) {
                context.setCurrentHeader("Content-Type");
                getObjectResponseBuilder.contentType(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("ETag") != null) {
                context.setCurrentHeader("ETag");
                getObjectResponseBuilder.eTag(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("Last-Modified") != null) {
                context.setCurrentHeader("Last-Modified");
                getObjectResponseBuilder
                        .lastModified(software.amazon.awssdk.utils.DateUtils.parseRfc1123Date(context.readText()));
            }
        }

        getObjectResponseBuilder.statusCode(context.getHttpResponse().statusCode());

        return getObjectResponseBuilder.build();
    }

    private static final GetObjectResponseUnmarshaller INSTANCE = new GetObjectResponseUnmarshaller();

    public static GetObjectResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
