/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.mediastoredata.model.MediaStoreDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetObjectResponse
extends MediaStoreDataResponse
implements ToCopyableBuilder<Builder, GetObjectResponse> {
    private final String cacheControl;
    private final String contentRange;
    private final Long contentLength;
    private final String contentType;
    private final String eTag;
    private final Instant lastModified;
    private final Integer statusCode;

    private GetObjectResponse(BuilderImpl builder) {
        super(builder);
        this.cacheControl = builder.cacheControl;
        this.contentRange = builder.contentRange;
        this.contentLength = builder.contentLength;
        this.contentType = builder.contentType;
        this.eTag = builder.eTag;
        this.lastModified = builder.lastModified;
        this.statusCode = builder.statusCode;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public String contentRange() {
        return this.contentRange;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public String contentType() {
        return this.contentType;
    }

    public String eTag() {
        return this.eTag;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public Integer statusCode() {
        return this.statusCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectResponse)) {
            return false;
        }
        GetObjectResponse other = (GetObjectResponse)((Object)obj);
        return Objects.equals(this.cacheControl(), other.cacheControl()) && Objects.equals(this.contentRange(), other.contentRange()) && Objects.equals(this.contentLength(), other.contentLength()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.statusCode(), other.statusCode());
    }

    public String toString() {
        return ToString.builder((String)"GetObjectResponse").add("CacheControl", (Object)this.cacheControl()).add("ContentRange", (Object)this.contentRange()).add("ContentLength", (Object)this.contentLength()).add("ContentType", (Object)this.contentType()).add("ETag", (Object)this.eTag()).add("LastModified", (Object)this.lastModified()).add("StatusCode", (Object)this.statusCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheControl": {
                return Optional.ofNullable(clazz.cast(this.cacheControl()));
            }
            case "ContentRange": {
                return Optional.ofNullable(clazz.cast(this.contentRange()));
            }
            case "ContentLength": {
                return Optional.ofNullable(clazz.cast(this.contentLength()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaStoreDataResponse.BuilderImpl
    implements Builder {
        private String cacheControl;
        private String contentRange;
        private Long contentLength;
        private String contentType;
        private String eTag;
        private Instant lastModified;
        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectResponse model) {
            super(model);
            this.cacheControl(model.cacheControl);
            this.contentRange(model.contentRange);
            this.contentLength(model.contentLength);
            this.contentType(model.contentType);
            this.eTag(model.eTag);
            this.lastModified(model.lastModified);
            this.statusCode(model.statusCode);
        }

        public final String getCacheControl() {
            return this.cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        public final String getContentRange() {
            return this.contentRange;
        }

        @Override
        public final Builder contentRange(String contentRange) {
            this.contentRange = contentRange;
            return this;
        }

        public final void setContentRange(String contentRange) {
            this.contentRange = contentRange;
        }

        public final Long getContentLength() {
            return this.contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public GetObjectResponse build() {
            return new GetObjectResponse(this);
        }
    }

    public static interface Builder
    extends MediaStoreDataResponse.Builder,
    CopyableBuilder<Builder, GetObjectResponse> {
        public Builder cacheControl(String var1);

        public Builder contentRange(String var1);

        public Builder contentLength(Long var1);

        public Builder contentType(String var1);

        public Builder eTag(String var1);

        public Builder lastModified(Instant var1);

        public Builder statusCode(Integer var1);
    }
}

