/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediastoredata.model.Item;
import software.amazon.awssdk.services.mediastoredata.model.ItemListCopier;
import software.amazon.awssdk.services.mediastoredata.model.MediaStoreDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListItemsResponse
extends MediaStoreDataResponse
implements ToCopyableBuilder<Builder, ListItemsResponse> {
    private final List<Item> items;
    private final String nextToken;

    private ListItemsResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
    }

    public List<Item> items() {
        return this.items;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListItemsResponse)) {
            return false;
        }
        ListItemsResponse other = (ListItemsResponse)((Object)obj);
        return Objects.equals(this.items(), other.items()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListItemsResponse").add("Items", this.items()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaStoreDataResponse.BuilderImpl
    implements Builder {
        private List<Item> items = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListItemsResponse model) {
            super(model);
            this.items(model.items);
            this.nextToken(model.nextToken);
        }

        public final Collection<Item.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(Item::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<Item> items) {
            this.items = ItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Item ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<Item.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (Item)((Item.Builder)Item.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<Item.BuilderImpl> items) {
            this.items = ItemListCopier.copyFromBuilder(items);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListItemsResponse build() {
            return new ListItemsResponse(this);
        }
    }

    public static interface Builder
    extends MediaStoreDataResponse.Builder,
    CopyableBuilder<Builder, ListItemsResponse> {
        public Builder items(Collection<Item> var1);

        public Builder items(Item ... var1);

        public Builder items(Consumer<Item.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

