/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.mediastoredata.model.DescribeObjectRequest;
import software.amazon.awssdk.services.mediastoredata.transform.DescribeObjectRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeObjectRequestMarshaller
implements Marshaller<Request<DescribeObjectRequest>, DescribeObjectRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/{Path+}").httpMethodName(HttpMethodName.HEAD).hasExplicitPayloadMember(false).hasPayloadMembers(false).build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DescribeObjectRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeObjectRequest> marshall(DescribeObjectRequest describeObjectRequest) {
        Validate.paramNotNull((Object)((Object)describeObjectRequest), (String)"describeObjectRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)describeObjectRequest);
            protocolMarshaller.startMarshalling();
            DescribeObjectRequestModelMarshaller.getInstance().marshall(describeObjectRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

