/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.transform;

import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse;
import software.amazon.awssdk.utils.DateUtils;

public class DescribeObjectResponseUnmarshaller
implements Unmarshaller<DescribeObjectResponse, JsonUnmarshallerContext> {
    private static final DescribeObjectResponseUnmarshaller INSTANCE = new DescribeObjectResponseUnmarshaller();

    public DescribeObjectResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeObjectResponse.Builder describeObjectResponseBuilder = DescribeObjectResponse.builder();
        if (context.isStartOfDocument()) {
            if (context.getHeader("ETag") != null) {
                context.setCurrentHeader("ETag");
                describeObjectResponseBuilder.eTag((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("Content-Type") != null) {
                context.setCurrentHeader("Content-Type");
                describeObjectResponseBuilder.contentType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("Content-Length") != null) {
                context.setCurrentHeader("Content-Length");
                describeObjectResponseBuilder.contentLength((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
            }
            if (context.getHeader("Cache-Control") != null) {
                context.setCurrentHeader("Cache-Control");
                describeObjectResponseBuilder.cacheControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("Last-Modified") != null) {
                context.setCurrentHeader("Last-Modified");
                describeObjectResponseBuilder.lastModified(DateUtils.parseRfc1123Date((String)context.readText()));
            }
        }
        return (DescribeObjectResponse)((Object)describeObjectResponseBuilder.build());
    }

    public static DescribeObjectResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

