/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediastoredata.model.GetObjectRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetObjectRequestModelMarshaller {
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.GREEDY_PATH).marshallLocationName("Path").isBinary(false).build();
    private static final MarshallingInfo<String> RANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Range").isBinary(false).build();
    private static final GetObjectRequestModelMarshaller INSTANCE = new GetObjectRequestModelMarshaller();

    private GetObjectRequestModelMarshaller() {
    }

    public static GetObjectRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetObjectRequest getObjectRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getObjectRequest), (String)"getObjectRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getObjectRequest.path(), PATH_BINDING);
            protocolMarshaller.marshall((Object)getObjectRequest.range(), RANGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

